/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.updateconfiguration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.ora.Node;
import oracle.dbtools.extension.rcv.models.ora.OraConfig;
import oracle.dbtools.extension.rcv.models.ora.Sqlnet;
import oracle.dbtools.extension.rcv.utils.ConfigurationManager;
import oracle.dbtools.extension.rcv.utils.TnsnamesHelper;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;

public class UpdateConfigurationStep
implements Step {
    private WorkflowLogger logger;
    private String dbUniqueName;
    private String protectedDatabaseId;
    private FleetAgentContext fleetAgentContext;

    public UpdateConfigurationStep(String dbUniqueName, String protectedDatabaseId, WorkflowLogger logger) {
        this.dbUniqueName = dbUniqueName;
        this.protectedDatabaseId = protectedDatabaseId;
        this.fleetAgentContext = FleetAgentContext.get(dbUniqueName);
        this.logger = logger;
    }

    @Override
    public Result run() {
        try {
            boolean tnsnamesUpdated = UpdateConfigurationStep.updateRcvTnsnamesOra(this.dbUniqueName);
            if (tnsnamesUpdated) {
                this.logger.log(Level.FINE, "Updated " + this.fleetAgentContext.getTnsnamesPath());
            } else {
                this.logger.log(Level.FINE, "No change to RCV tnsnames.ora is required.");
            }
            tnsnamesUpdated = UpdateConfigurationStep.updateDefaultTnsnamesOra(this.dbUniqueName);
            if (tnsnamesUpdated) {
                this.logger.log(Level.FINE, "Updated " + TnsnamesHelper.getDefaultTnsnamesFile(this.dbUniqueName));
            } else {
                this.logger.log(Level.FINE, "No change to default tnsnames.ora is required.");
            }
            ConfigurationManager.importRecoveryServiceCertificate(this.dbUniqueName);
            UpdateConfigurationStep.updateRcvSqlnetOra(this.dbUniqueName);
        }
        catch (IOException e) {
            Workflow.logException(e, this.logger.getLogger());
            return Result.ucwUpdateClientConfError(RcvMessages.format("UCW_UPDATE_CLIENT_CONF_ERROR_MSG1", new Object[0]));
        }
        return new Result(Status.SUCCESS);
    }

    public static boolean updateRcvTnsnamesOra(String dbUniqueName) throws IOException {
        OraConfig currentTnsNames;
        FleetAgentContext fleetAgentContext = FleetAgentContext.get(dbUniqueName);
        String tnsAdmin = fleetAgentContext.getTnsAdmin();
        String tnsnamesOraPath = String.join((CharSequence)File.separator, tnsAdmin, "tnsnames.ora");
        String dbrsnamesOraPath = String.join((CharSequence)File.separator, tnsAdmin, "dbrsnames.ora.txt");
        OraConfig newTnsNames = OraConfig.load(dbrsnamesOraPath);
        boolean overwriteTnsnames = false;
        boolean isADE = System.getenv("ADE_VIEW_ROOT") != null;
        List<Node<String>> hostNodes = newTnsNames.getAllMatchingNodes("HOST");
        if (isADE) {
            String regex = "(fqdn1|fqdn2)\\.us\\.oracle\\.com";
            for (Node<String> node : hostNodes) {
                String currentHostValue = newTnsNames.getParameterValue(node);
                newTnsNames.updateParameter(node, currentHostValue.replaceAll(regex, "127.0.0.1"));
            }
        }
        for (Node node : newTnsNames.getEntries()) {
            node.setValue(ConfigurationManager.updateAliasWithDbUniqueName(dbUniqueName, (String)node.getValue()));
            List<Node<String>> descriptionNodes = node.getAllNodes("DESCRIPTION");
            for (Node<String> descNode : descriptionNodes) {
                Node<String> security = new Node<String>("SECURITY").addChild(new Node<String>("MY_WALLET_DIRECTORY").addChild(new Node<String>(fleetAgentContext.getWalletLocation())));
                descNode.addChild(security);
            }
        }
        overwriteTnsnames = Files.exists(Paths.get(tnsnamesOraPath, new String[0]), new LinkOption[0]) ? !newTnsNames.equals(currentTnsNames = OraConfig.load(tnsnamesOraPath)) : true;
        if (overwriteTnsnames) {
            if (Files.exists(Paths.get(tnsnamesOraPath, new String[0]), new LinkOption[0])) {
                try {
                    Utils.copyFileContent(tnsnamesOraPath, tnsnamesOraPath + ".prev");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            newTnsNames.write(tnsnamesOraPath);
        }
        return overwriteTnsnames;
    }

    public static boolean updateDefaultTnsnamesOra(String dbUniqueName) throws IOException {
        String dbrsTnsnamesPath = FleetAgentContext.get(dbUniqueName).getTnsnamesPath();
        String defaultTnsnamesPath = TnsnamesHelper.getDefaultTnsnamesFile(dbUniqueName);
        OraConfig defaultTnsnames = OraConfig.load(defaultTnsnamesPath);
        boolean needsUpdate = defaultTnsnames.addIfile(dbrsTnsnamesPath);
        if (needsUpdate) {
            Files.move(Paths.get(defaultTnsnamesPath, new String[0]), Paths.get(defaultTnsnamesPath + ".prev", new String[0]), StandardCopyOption.ATOMIC_MOVE);
            defaultTnsnames.write(defaultTnsnamesPath);
        }
        return needsUpdate;
    }

    public static void updateRcvSqlnetOra(String dbUniqueName) throws IOException {
        FleetAgentContext fleetAgentContext = FleetAgentContext.get(dbUniqueName);
        String walletLocation = fleetAgentContext.getProtectedDatabaseCache().getWalletLocation();
        UpdateConfigurationStep.updateRcvSqlnetOra(dbUniqueName, walletLocation);
    }

    public static void updateRcvSqlnetOra(String dbUniqueName, String walletLocation) throws IOException {
        FleetAgentContext fleetAgentContext = FleetAgentContext.get(dbUniqueName);
        String dbrsnamesOra = String.join((CharSequence)File.separator, fleetAgentContext.getTnsAdmin(), "dbrsnames.ora.txt");
        String protocol = ConfigurationManager.getProtocolFromTnsnames(dbrsnamesOra);
        boolean tls = protocol != null && protocol.equalsIgnoreCase("tcps");
        Sqlnet sqlnet = Sqlnet.load(fleetAgentContext.getSqlnetPath());
        sqlnet.updateWallet(walletLocation);
        sqlnet.setTls(tls);
        sqlnet.write(fleetAgentContext.getSqlnetPath());
    }
}

