/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.addprotecteddatabase;

import com.oracle.bmc.database.model.DatabaseSummary;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.recovery.model.CreateProtectedDatabaseDetails;
import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnetInput;
import com.oracle.bmc.recovery.model.WorkRequest;
import com.oracle.bmc.recovery.responses.CancelProtectedDatabaseDeletionResponse;
import com.oracle.bmc.recovery.responses.CreateProtectedDatabaseResponse;
import java.io.IOException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RCVGrammar;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.DatabaseUser;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.oci.DatabaseClientManager;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.ConfigurationManager;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.utils.WalletManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.UserDefinedInput;
import oracle.dbtools.extension.rcv.workflows.importprotecteddatabase.ImportProtectedDatabaseWorkflow;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public class OnboardDatabaseStep
implements Step {
    private Connection conn;
    private String dbUniqueName;
    private RecoveryClientManager recoveryClientManager;
    private WorkflowLogger logger;
    private char[] vpcPassword;
    private UserDefinedInput userDefinedInput;
    private Boolean onboard;
    private boolean dryRun;
    private FleetAgentContext fleetAgentContext;
    private ProtectedDatabase protectedDatabase;

    public OnboardDatabaseStep(Connection conn, UserDefinedInput userDefinedInput, WorkflowLogger logger) {
        this.conn = conn;
        this.logger = logger;
        this.vpcPassword = userDefinedInput.getPassword();
        this.userDefinedInput = userDefinedInput;
        this.dryRun = userDefinedInput.getDryRun();
        this.dbUniqueName = RCVCommandBase.getDbUniqueName(conn);
        this.fleetAgentContext = FleetAgentContext.get(this.dbUniqueName);
        String endpoint = userDefinedInput.getEndpoint();
        if (endpoint == null) {
            endpoint = this.fleetAgentContext.getProtectedDatabaseCache().getEndpoint();
        }
        this.recoveryClientManager = new RecoveryClientManager(endpoint, logger.getLogger());
    }

    @Override
    public Result run() {
        Result result = this.onboardDatabaseIfNotOnboarded();
        if (result.getStatus().equals((Object)Status.FAILED)) {
            return result;
        }
        if (!this.dryRun) {
            result = this.verifyLifecycleState();
            if (result.getStatus().equals((Object)Status.FAILED) || result.getStatus().equals((Object)Status.TIMED_OUT)) {
                return result;
            }
            return this.savePassword();
        }
        return result;
    }

    private Result onboardDatabaseIfNotOnboarded() {
        if (this.dryRun) {
            this.logger.log(Level.INFO, "Checking if database is ready to be onboarded to Recovery service");
        } else {
            this.logger.log(Level.INFO, "Onboarding database to Recovery Service");
        }
        ProtectedDatabaseCache cache = this.fleetAgentContext.getProtectedDatabaseCache();
        if (this.userDefinedInput.getEndpoint() != null) {
            cache.setEndpoint(this.userDefinedInput.getEndpoint());
        }
        boolean callCreateProtectedDbAPI = true;
        if (cache.getOcid() != null) {
            try {
                this.protectedDatabase = this.recoveryClientManager.getProtectedDatabase(cache.getOcid());
            }
            catch (BmcException e) {
                this.logger.getLogger().log(Level.FINE, "Failed to get protected database.", e);
                return Result.rcvGetProtectedDatabaseError(cache.getOcid(), cache.getMetadataFile());
            }
            LifecycleState state = this.protectedDatabase.getLifecycleState();
            if (state.equals((Object)LifecycleState.Active) || state.equals((Object)LifecycleState.Updating)) {
                return new Result(Status.SKIPPED, "Database is already onboarded to Recovery Service.");
            }
            if (state.equals((Object)LifecycleState.DeleteScheduled)) {
                if (this.dryRun) {
                    String message = String.format("This database is already onboarded to Recovery Service but it is scheduled for deletion. Please rerun %s without the %s option to cancel the deletion, or wait until it is deleted to create a new protected database resource.", new Object[]{String.valueOf((Object)RCVGrammar.Base.RCV) + " " + String.valueOf((Object)RCVCommand.SubCommand.ADD_DATABASE), RCVOptions.Options.VALIDATE});
                    return new Result(Status.SKIPPED, message);
                }
                try {
                    CancelProtectedDatabaseDeletionResponse response = this.recoveryClientManager.cancelProtectedDatabaseDeletion(cache.getOcid());
                    this.logger.log(Level.FINE, response.toString());
                    callCreateProtectedDbAPI = false;
                }
                catch (BmcException e) {
                    this.logger.log(Level.FINE, e.getMessage());
                    cache.clearCache();
                }
            }
        }
        if (callCreateProtectedDbAPI) {
            try {
                if (this.vpcPassword == null || this.vpcPassword.length == 0) {
                    this.vpcPassword = OnboardDatabaseStep.generateRandomPassword();
                }
                this.protectedDatabase = this.onboardProtectedDatabase(this.conn, this.userDefinedInput, this.vpcPassword);
                if (this.dryRun) {
                    this.logger.log(Level.INFO, "Database is ready to be onboarded to Recovery Service.");
                    return new Result(Status.SUCCESS);
                }
                if (this.protectedDatabase != null) {
                    cache.setOcid(this.protectedDatabase.getId());
                }
            }
            catch (BmcException e) {
                this.logger.log(Level.FINE, e.getMessage());
                if (e.getStatusCode() == 409 && (e.getServiceCode().equalsIgnoreCase("IncorrectState") || e.getServiceCode().equalsIgnoreCase("Conflict"))) {
                    String ocid = null;
                    String regex = "This database is already being protected by Autonomous Recovery Service in this compartment by protected database (.*?)\\s";
                    String regex2 = "This database is already being protected by Autonomous Recovery Service in the (.*?) compartment by protected database (.*?)\\s";
                    Pattern pattern = Pattern.compile(regex);
                    Matcher matcher = pattern.matcher(e.getMessage());
                    if (matcher.find()) {
                        ocid = matcher.group(1);
                    } else {
                        pattern = Pattern.compile(regex2);
                        matcher = pattern.matcher(e.getMessage());
                        if (matcher.find()) {
                            ocid = matcher.group(2);
                            cache.setCompartmentId(matcher.group(1));
                        }
                    }
                    if (ocid != null) {
                        cache.setOcid(ocid);
                        if (this.dryRun) {
                            cache.save();
                            this.logger.log(Level.INFO, "Database is already onboarded.");
                            return new Result(Status.SKIPPED);
                        }
                        this.logger.log(Level.FINE, "Found existing protected database. Updating VPC password");
                        ImportProtectedDatabaseWorkflow importWf = new ImportProtectedDatabaseWorkflow(ocid, null);
                        importWf.password(this.vpcPassword);
                        importWf.endpoint(cache.getEndpoint());
                        importWf.setLogger(this.logger);
                        return importWf.runWithLock(false);
                    }
                }
                String error = this.dryRun ? RcvMessages.format("APD_ONBOARD_DB_ERROR_MSG1", new Object[0]) : RcvMessages.format("APD_ONBOARD_DB_ERROR_MSG2", new Object[0]);
                Workflow.logException(e, this.logger.getLogger());
                return Result.apdOnboardDbError(error);
            }
            return new Result(Status.SUCCESS);
        }
        return new Result(Status.SKIPPED);
    }

    private Result verifyLifecycleState() {
        this.logger.log(Level.INFO, "Verifying lifecycle state");
        ProtectedDatabaseCache cache = this.fleetAgentContext.getProtectedDatabaseCache();
        String ocid = cache.getOcid();
        if (this.protectedDatabase == null) {
            Objects.requireNonNull(ocid);
            this.protectedDatabase = this.recoveryClientManager.getProtectedDatabase(cache.getOcid());
        }
        if (!this.protectedDatabase.getLifecycleState().equals((Object)LifecycleState.Active)) {
            try {
                this.protectedDatabase = this.recoveryClientManager.waitForProtectedDatabaseUpdate(ocid, 1200, 20);
            }
            catch (Exception e) {
                Workflow.logException(e, this.logger.getLogger());
                return Result.apdLifecycleGetStatusError(ocid);
            }
            LifecycleState lifeCycleState = this.protectedDatabase.getLifecycleState();
            if (lifeCycleState.equals((Object)LifecycleState.Creating)) {
                return Result.addResourceLifecycleStatusTmt("protected database");
            }
            if (!lifeCycleState.equals((Object)LifecycleState.Active)) {
                this.logger.log(Level.FINE, this.protectedDatabase.toString());
                return Result.verifyLifecycleStatusError("protected database", lifeCycleState.getValue(), LifecycleState.Active.toString(), LifecycleState.Creating.toString());
            }
        }
        return new Result(Status.SUCCESS);
    }

    private Result savePassword() {
        String vpcUserName = this.protectedDatabase.getVpcUserName();
        this.fleetAgentContext.getProtectedDatabaseCache().setVpcUserName(vpcUserName);
        String walletLocation = this.fleetAgentContext.getProtectedDatabaseCache().getWalletLocation();
        OracleWallet wallet = WalletManager.createWallet(walletLocation);
        try {
            String dbrsAlias = ConfigurationManager.updateAliasWithDbUniqueName(this.dbUniqueName, "DBRS");
            boolean walletHasDbrsAlias = false;
            List<String> aliases = WalletManager.getAliasesForUser(wallet, vpcUserName);
            for (String alias : aliases) {
                if (!alias.equalsIgnoreCase(dbrsAlias)) continue;
                walletHasDbrsAlias = true;
                break;
            }
            if (!walletHasDbrsAlias) {
                if (!aliases.isEmpty()) {
                    if (this.vpcPassword == null) {
                        this.vpcPassword = WalletManager.getSecretForUser(wallet, vpcUserName);
                    }
                } else if (this.vpcPassword == null) {
                    this.vpcPassword = OnboardDatabaseStep.generateRandomPassword();
                }
            } else {
                return new Result(Status.SKIPPED);
            }
            DatabaseUser user = new DatabaseUser(vpcUserName, this.vpcPassword);
            user.storePassword(walletLocation, dbrsAlias);
        }
        catch (IOException | OracleSecretStoreException e) {
            Workflow.logException(e, this.logger.getLogger());
            return Result.apdVpcUserWalletError(walletLocation);
        }
        return new Result(Status.SUCCESS);
    }

    private ProtectedDatabase onboardProtectedDatabase(Connection conn, UserDefinedInput input, char[] vpcPassword) {
        CreateProtectedDatabaseDetails createProtectedDatabaseDetails = OnboardDatabaseStep.createProtectedDatabaseDetails(conn, input, vpcPassword);
        CreateProtectedDatabaseResponse response = this.recoveryClientManager.onboardProtectedDatabase(createProtectedDatabaseDetails, input.getDryRun());
        String workRequestId = response.getOpcWorkRequestId();
        if (workRequestId != null) {
            this.logger.log(Level.FINE, "OPC request ID: " + response.getOpcRequestId());
            this.logger.log(Level.FINE, "OPC Work Request ID: " + workRequestId);
            WorkRequest workRequest = this.recoveryClientManager.getWorkRequest(workRequestId);
        }
        return response.getProtectedDatabase();
    }

    public static CreateProtectedDatabaseDetails createProtectedDatabaseDetails(Connection conn, UserDefinedInput input, char[] vpcPassword) {
        String systemType;
        Database database = RCVCommandBase.getDatabase(conn);
        GlobalMetadata globalMetadata = GlobalMetadata.load();
        String dbUniqueName = database.getDbUniqueName();
        String dbStatus = DatabaseUtils.getDatabaseStatus(conn);
        String displayName = input.getDisplayName();
        if (displayName == null) {
            displayName = dbUniqueName;
        }
        Map<String, String> tags = Map.of("rcvManagementType", "FLEET_AGENT_MANAGED", "rcvDbName", DatabaseUtils.getDbName(conn), "rcvDbIdentifier", DatabaseUtils.getDbId(conn));
        ArrayList<RecoveryServiceSubnetInput> subnetList = new ArrayList<RecoveryServiceSubnetInput>();
        for (String id : input.getRecoveryServiceSubnets()) {
            subnetList.add(RecoveryServiceSubnetInput.builder().recoveryServiceSubnetId(id).build());
        }
        CreateProtectedDatabaseDetails.Builder builder = CreateProtectedDatabaseDetails.builder().displayName(displayName).dbUniqueName(dbUniqueName).password(new String(vpcPassword)).protectionPolicyId(input.getProtectionPolicy()).recoveryServiceSubnets(subnetList).compartmentId(input.getCompartmentId()).freeformTags(tags);
        if (dbStatus.equalsIgnoreCase("OPEN")) {
            int dbSize = DatabaseUtils.getDbSize(conn);
            builder = builder.databaseSizeInGBs(Integer.valueOf(dbSize));
        }
        if (input.getCompressionRatio() != null) {
            builder = builder.compressionRatio(input.getCompressionRatio());
        }
        if (input.getChangeRate() != null) {
            builder = builder.changeRate(input.getChangeRate());
        }
        if ((systemType = globalMetadata.getSystemType()).equals("OCI")) {
            DatabaseClientManager databaseClientManager;
            DatabaseSummary dbSummary;
            String dbId = input.getDatabaseId();
            if (dbId == null && (dbSummary = (databaseClientManager = new DatabaseClientManager(globalMetadata.getAuthentication())).getDatabaseSummary(dbUniqueName)) != null) {
                dbId = dbSummary.getId();
            }
            builder.databaseId(dbId);
        }
        return builder.build();
    }

    public DryRunResult dryRun() {
        char[] dryRunPassword;
        String dbUniqueName = RCVCommandBase.getDbUniqueName(this.conn);
        ProtectedDatabaseCache cache = RCVCommandBase.getProtectedDatabaseCache(dbUniqueName);
        String ocid = cache.getOcid();
        if (ocid != null) {
            try {
                ProtectedDatabase protectedDatabase = this.recoveryClientManager.getProtectedDatabase(ocid);
                LifecycleState lifecycleState = protectedDatabase.getLifecycleState();
                if (!lifecycleState.equals((Object)LifecycleState.Deleted) && !lifecycleState.equals((Object)LifecycleState.Deleting)) {
                    return new DryRunResult(protectedDatabase, null);
                }
            }
            catch (BmcException protectedDatabase) {
                // empty catch block
            }
        }
        if ((dryRunPassword = this.vpcPassword) == null) {
            dryRunPassword = OnboardDatabaseStep.generateRandomPassword();
        }
        CreateProtectedDatabaseDetails createProtectedDatabaseDetails = OnboardDatabaseStep.createProtectedDatabaseDetails(this.conn, this.userDefinedInput, dryRunPassword);
        try {
            CreateProtectedDatabaseResponse createProtectedDatabaseResponse = this.recoveryClientManager.onboardProtectedDatabase(createProtectedDatabaseDetails, true);
        }
        catch (BmcException e) {
            String regex;
            Pattern pattern;
            Matcher matcher;
            if (e.getStatusCode() == 409 && e.getServiceCode().equalsIgnoreCase("IncorrectState") && (matcher = (pattern = Pattern.compile(regex = "This database is already being protected by Autonomous Recovery Service in this compartment by protected database (.*?)\\s")).matcher(e.getMessage())).find()) {
                ocid = matcher.group(1);
                cache.setOcid(ocid);
                return new DryRunResult(this.recoveryClientManager.getProtectedDatabase(ocid), e);
            }
            return new DryRunResult(null, e);
        }
        return new DryRunResult(null, null);
    }

    @Override
    public boolean isApplicable() {
        Database database = RCVCommandBase.getDatabase(this.conn);
        String walletLocation = database.getFleetAgentContext().getWalletLocation();
        DryRunResult dryRunResult = this.dryRun();
        if (dryRunResult.protectedDatabase == null) {
            return true;
        }
        ProtectedDatabase protectedDatabase = dryRunResult.protectedDatabase;
        LifecycleState state = protectedDatabase.getLifecycleState();
        if (state.equals((Object)LifecycleState.Deleted) || state.equals((Object)LifecycleState.Deleting) || state.equals((Object)LifecycleState.DeleteScheduled)) {
            return true;
        }
        String vpcUser = protectedDatabase.getVpcUserName();
        return !WalletManager.walletContainsUser(WalletManager.createWallet(walletLocation), vpcUser);
    }

    public static char[] generateRandomPassword() {
        int i;
        int length = 15;
        char[] passwordChars = new char[length];
        String specialChars = "#_-";
        String upperCaseChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String lowerCaseChars = upperCaseChars.toLowerCase();
        String numbers = "0123456789";
        String[] charTypes = new String[]{specialChars, upperCaseChars, lowerCaseChars, numbers};
        String allChars = specialChars + upperCaseChars + lowerCaseChars + numbers;
        SecureRandom random = new SecureRandom();
        for (i = 0; i < 2; ++i) {
            for (String charType : charTypes) {
                int randomPosition;
                while (passwordChars[randomPosition = random.nextInt(length)] != '\u0000') {
                }
                passwordChars[randomPosition] = charType.charAt(random.nextInt(charType.length()));
            }
        }
        for (i = 0; i < passwordChars.length; ++i) {
            if (passwordChars[i] != '\u0000') continue;
            passwordChars[i] = allChars.charAt(random.nextInt(allChars.length()));
        }
        return passwordChars;
    }

    private static class DryRunResult {
        private ProtectedDatabase protectedDatabase;
        private BmcException bmcException;

        private DryRunResult(ProtectedDatabase protectedDatabase, BmcException bmcException) {
            this.protectedDatabase = protectedDatabase;
            this.bmcException = bmcException;
        }
    }
}

