/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.addprotecteddatabase;

import com.oracle.bmc.recovery.model.ProtectionPolicySummary;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnetInput;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.WalletEntry;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.WalletManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.UserDefinedInput;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.security.pki.OracleWallet;

public class CommandLineInput
implements UserDefinedInput {
    private ParsedCommand command;
    private String endpoint;
    private String displayName;
    private String compartmentId;
    private List<RecoveryServiceSubnetInput> recoverySubnets = new ArrayList<RecoveryServiceSubnetInput>();
    private String sbtLibrary;
    private String protectionPolicyId;
    private char[] password;
    private Double compressionRatio;
    private Double changeRate;
    private boolean realtimeRedo;
    private boolean dryRun;
    private String wallet;
    private String alias;
    private String databaseId;

    public CommandLineInput(ParsedCommand command) {
        this.command = command;
        this.setEndpoint();
        this.setDisplayName();
        this.setCompartmentId();
        this.setRecoveryServiceSubnets();
        this.setProtectionPolicy();
        this.setSbtLibrary();
        this.setWallet();
        this.setAlias();
        this.setPassword(CommandLineInput.getPassword(command));
        this.setCompressionRatio();
        this.setChangeRate();
        this.setRealtimeRedo();
        this.setDryRun();
        this.setDatabaseId();
    }

    private void setEndpoint() {
        this.endpoint = (String)this.command.getOptionValue((Id)RCVOptions.Options.ENDPOINT);
    }

    private void setDisplayName() {
        this.displayName = (String)this.command.getOptionValue((Id)RCVOptions.Options.NAME);
    }

    private void setSbtLibrary() {
        this.sbtLibrary = (String)this.command.getOptionValue((Id)RCVOptions.Options.SBT_LIBRARY);
    }

    private void setCompartmentId() {
        this.compartmentId = (String)this.command.getOptionValue((Id)RCVOptions.Options.COMPARTMENT_ID);
        if (this.compartmentId == null) {
            GlobalMetadata globalMetadata = GlobalMetadata.load();
            this.compartmentId = globalMetadata.getAuthentication().getTenancyId();
            if (this.compartmentId == null) {
                throw new IllegalArgumentException("Please provide the compartment ID of the OCI compartment you want to register the database to.");
            }
        }
    }

    private void setRecoveryServiceSubnets() {
        List subnets = (List)this.command.getOptionValue((Id)RCVOptions.Options.RECOVERY_SERVICE_SUBNETS);
        for (String id : subnets) {
            this.recoverySubnets.add(RecoveryServiceSubnetInput.builder().recoveryServiceSubnetId(id).build());
        }
    }

    public void setWallet() {
        this.wallet = (String)this.command.getOptionValue((Id)RCVOptions.Options.WALLET);
    }

    public void setAlias() {
        this.alias = (String)this.command.getOptionValue((Id)RCVOptions.Options.ALIAS);
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    public static char[] getPassword(ParsedCommand command) {
        if (command.getOptionValue((Id)RCVOptions.Options.WALLET) != null) {
            String walletLocation = (String)command.getOptionValue((Id)RCVOptions.Options.WALLET);
            OracleWallet wallet = WalletManager.getWallet(walletLocation);
            if (command.getOptionValue((Id)RCVOptions.Options.ALIAS) != null) {
                String alias = (String)command.getOptionValue((Id)RCVOptions.Options.ALIAS);
                char[] password = WalletManager.getSecretForAlias(wallet, alias);
                if (password != null) {
                    return password;
                }
            } else {
                HashMap<String, WalletEntry> entries = WalletManager.getWalletEntries(wallet);
                if (entries.keySet().isEmpty()) {
                    String error = String.format("The specified wallet %s is empty. Please store the credentials for the VPC user in this wallet.", walletLocation);
                    throw new IllegalArgumentException(error);
                }
                if (entries.keySet().size() > 1) {
                    String error = String.format("The specified wallet %s has multiple entries. Please specify the alias for the vpc user with '-alias <vpc_user_alias>'", walletLocation);
                    throw new IllegalArgumentException(error);
                }
                Iterator<String> iterator = entries.keySet().iterator();
                if (iterator.hasNext()) {
                    String id = iterator.next();
                    return entries.get(id).getPassword();
                }
            }
        }
        return null;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    private void setProtectionPolicy() {
        this.protectionPolicyId = (String)this.command.getOptionValue((Id)RCVOptions.Options.PROTECTION_POLICY_ID);
        String protectionPolicyName = (String)this.command.getOptionValue((Id)RCVOptions.Options.PROTECTION_POLICY_NAME);
        if (this.protectionPolicyId == null) {
            RecoveryClientManager recoveryClientManager = new RecoveryClientManager(this.endpoint, RCVCommandBase.getLogger().getLogger());
            if (protectionPolicyName == null) {
                List<ProtectionPolicySummary> protectionPolicies = recoveryClientManager.getDefaultProtectionPolicies(this.compartmentId);
                if (protectionPolicies.isEmpty()) {
                    throw new IllegalArgumentException("Please provide a protection policy Id.");
                }
                protectionPolicies.sort(Comparator.comparingInt(ProtectionPolicySummary::getBackupRetentionPeriodInDays));
                this.protectionPolicyId = protectionPolicies.get(0).getId();
            } else {
                List<String> protectionPolicyOcids = recoveryClientManager.getProtectionPolicyOcids(protectionPolicyName = protectionPolicyName.replaceAll("^\"|\"$", ""), this.compartmentId);
                if (protectionPolicyOcids.isEmpty()) {
                    throw Result.apdMetadataInitException(protectionPolicyName);
                }
                if (protectionPolicyOcids.size() == 1) {
                    this.protectionPolicyId = protectionPolicyOcids.get(0);
                } else {
                    throw Result.apdMetadataInit2Exception(protectionPolicyName);
                }
            }
        }
    }

    private void setCompressionRatio() {
        this.compressionRatio = (Double)this.command.getOptionValue((Id)RCVOptions.Options.COMPRESSION_RATIO);
    }

    private void setChangeRate() {
        this.changeRate = (Double)this.command.getOptionValue((Id)RCVOptions.Options.CHANGE_RATE);
    }

    private void setRealtimeRedo() {
        this.realtimeRedo = this.command.isFlagSet((Id)RCVOptions.Options.REALTIME_REDO);
    }

    private void setDryRun() {
        this.dryRun = this.command.isFlagSet((Id)RCVOptions.Options.VALIDATE);
    }

    private void setDatabaseId() {
        this.databaseId = (String)this.command.getOptionValue((Id)RCVOptions.Options.DATABASE_ID);
    }

    @Override
    public String getCompartmentId() {
        return this.compartmentId;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getProtectionPolicy() {
        return this.protectionPolicyId;
    }

    @Override
    public List<String> getRecoveryServiceSubnets() {
        return (List)this.command.getOptionValue((Id)RCVOptions.Options.RECOVERY_SERVICE_SUBNETS);
    }

    @Override
    public String getSbtLibrary() {
        return this.sbtLibrary;
    }

    @Override
    public Double getCompressionRatio() {
        return this.compressionRatio;
    }

    @Override
    public Double getChangeRate() {
        return this.changeRate;
    }

    @Override
    public boolean getDryRun() {
        return this.dryRun;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getWallet() {
        return this.wallet;
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }

    public boolean getRealtimeRedo() {
        return this.realtimeRedo;
    }

    @Override
    public String getDatabaseId() {
        return this.databaseId;
    }
}

