/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.check.Checks;
import oracle.dbtools.extension.rcv.check.Group;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ShowChecksWorkflow
extends Workflow {
    private boolean listGroups;
    private WorkflowLogger logger;

    public ShowChecksWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.SHOW_CHECKS, conn, ctx);
        this.listGroups = command.isFlagSet((Id)RCVOptions.Options.GROUP);
        this.logger = this.getWorkflowLogger();
    }

    @Override
    public Result run(boolean verbose) {
        if (this.listGroups) {
            this.logger.log(Level.INFO, "Below is a list of groups of checks you can run:");
            for (Group group : Group.values()) {
                this.logger.log(Level.INFO, "\t" + group.toString().toLowerCase());
            }
            String msg = String.format("You can run any of the checks from the list above by executing: %s", new RCVCommand(RCVCommand.SubCommand.RUN_CHECKS).addOption(RCVOptions.Options.GROUP, "<group_name>").toString());
            this.logger.log(Level.INFO, msg);
        } else {
            List<String> checkIds = Checks.getCheckIds(Group.ALL);
            if (checkIds != null) {
                this.logger.log(Level.INFO, "Below is a list of checks you can run:");
                for (String id : checkIds) {
                    this.logger.log(Level.INFO, "\t" + id);
                }
                String msg = String.format("You can run any of the checks from the list above by executing: %s", new RCVCommand(RCVCommand.SubCommand.RUN_CHECKS).addOption(RCVOptions.Options.NAME, "<check_name>").toString());
                this.logger.log(Level.INFO, msg);
            }
        }
        return new Result(Status.SUCCESS);
    }
}

