/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;

public class FileLocker {
    private String lockFileName;
    private Path lockFilePath;
    int timeOut = 0;

    public FileLocker(String lockFileName, int timeOut) {
        this.lockFileName = lockFileName;
        this.lockFilePath = Paths.get(lockFileName, new String[0]);
        this.timeOut = timeOut;
        Path parentDir = this.lockFilePath.getParent();
        if (!(parentDir == null || Files.isSymbolicLink(parentDir) && Files.isDirectory(parentDir, new LinkOption[0]))) {
            try {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                RCVCommandBase.getLogger().getLogger().log(Level.FINE, "Failed to create directory.", e);
                throw new RuntimeException("Failed to create directory " + String.valueOf(parentDir) + ": " + e.getMessage());
            }
        }
    }

    /*
     * Exception decompiling
     */
    public <V> Optional<V> execute(Callable<V> function, TimeoutHandler timeoutHandler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 25[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <V> Optional<V> execute(Callable<V> function) {
        return this.execute(function, pid -> RCVCommandBase.getLogger().log(Level.FINE, String.format("Timed out waiting for process %s to release the lock", pid)));
    }

    private long readPidFromFile(File lockFile) throws IOException {
        long l;
        RandomAccessFile raf = new RandomAccessFile(lockFile, "r");
        try {
            byte[] bytes = new byte[(int)raf.length()];
            raf.readFully(bytes);
            String pidString = new String(bytes, StandardCharsets.UTF_8).trim();
            l = Long.parseLong(pidString);
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        raf.close();
        return l;
    }

    private boolean isProcessRunning(long pid) {
        return ProcessHandle.of(pid).isPresent();
    }

    @FunctionalInterface
    public static interface TimeoutHandler {
        public void onTimeout(long var1);
    }
}

