/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ResourcePrincipalAuthenticationDetailsProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.oci.OCIUtils;
import oracle.dbtools.extension.rcv.utils.SshHelper;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigureAuthenticationWorkflow
extends Workflow {
    private OCIAuthentication.Method method;
    private String ociConfig;
    private String profileName;
    private GlobalMetadata globalMetadata;
    private OCIAuthentication auth;
    private Connection conn;
    private ParsedCommand command;

    public ConfigureAuthenticationWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.CONFIGURE_AUTHENTICATION, conn, ctx);
        this.command = command;
        this.conn = conn;
        Result optionsCheck = this.checkOptions();
        if (optionsCheck.getStatus().equals((Object)Status.FAILED)) {
            throw Result.wfResultToException(optionsCheck.getMessage());
        }
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new CreateMetadataDirectory());
        steps.add(new ValidateAuthentication());
        steps.add(new UpdateMetadata());
        super.setSteps(steps);
    }

    @Override
    public String getLockFileName() {
        return String.join((CharSequence)File.separator, RCVCommandBase.getAgentBaseDirectory(), "lock", String.valueOf((Object)RCVCommand.SubCommand.CONFIGURE_AUTHENTICATION) + ".lock");
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    @Override
    public void initState() {
        this.method = OCIAuthentication.Method.valueOf((String)this.command.getOptionValue((Id)RCVOptions.Options.METHOD));
        this.ociConfig = (String)this.command.getOptionValue((Id)RCVOptions.Options.OCI_CONFIG);
        this.profileName = (String)this.command.getOptionValue((Id)RCVOptions.Options.PROFILE_NAME);
        this.globalMetadata = GlobalMetadata.load();
        this.auth = new OCIAuthentication(this.method, this.ociConfig, this.profileName);
    }

    public Result checkOptions() {
        if (this.command.getOptionValue((Id)RCVOptions.Options.METHOD).equals("RESOURCE_PRINCIPAL")) {
            if (this.command.getOptionValue((Id)RCVOptions.Options.OCI_CONFIG) != null) {
                return Result.invalidOption(RcvMessages.format("WF_INVALID_MUTUALLY_EXCLUSIVE", RCVOptions.Options.OCI_CONFIG.getName().toLowerCase(), RCVOptions.Options.METHOD.getName().toLowerCase()));
            }
            if (this.command.getOptionValue((Id)RCVOptions.Options.PROFILE_NAME) != null) {
                return Result.invalidOption(RcvMessages.format("WF_INVALID_MUTUALLY_EXCLUSIVE", RCVOptions.Options.PROFILE_NAME.getName().toLowerCase(), RCVOptions.Options.METHOD.getName().toLowerCase()));
            }
        }
        return new Result(Status.SUCCESS);
    }

    public static void copyAuthenticationFilesToRemoteNode(SshHelper sshConnection) {
        GlobalMetadata globalMetadata = GlobalMetadata.load();
        OCIAuthentication auth = globalMetadata.getAuthentication();
        if (auth.getMethod().equals((Object)OCIAuthentication.Method.API_KEY)) {
            List<Object> filePaths = new ArrayList<String>();
            String userHome = System.getProperty("user.home");
            filePaths.add(auth.getConfigFile());
            try {
                ConfigFileAuthenticationDetailsProvider provider = new ConfigFileAuthenticationDetailsProvider(auth.getConfigFile(), auth.getProfileName());
                String string = provider.getPemFilePath();
                if (string != null) {
                    filePaths.add(string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            filePaths = filePaths.stream().map(path -> {
                if (path.startsWith("~")) {
                    return path.replace("~", userHome);
                }
                return path;
            }).collect(Collectors.toList());
            for (String string : filePaths) {
                sshConnection.copy(string, string);
            }
        }
    }

    public static void copyAuthenticationFilesToRemoteNodes(List<SshHelper> sshConnections) {
        for (SshHelper sshConnection : sshConnections) {
            ConfigureAuthenticationWorkflow.copyAuthenticationFilesToRemoteNode(sshConnection);
        }
    }

    private class CreateMetadataDirectory
    implements Step {
        private CreateMetadataDirectory() {
        }

        @Override
        public Result run() {
            WorkflowLogger logger = ConfigureAuthenticationWorkflow.this.getWorkflowLogger();
            logger.log(Level.INFO, "Setting up environment");
            Path metadataFilePath = Paths.get(GlobalMetadata.getMetadataFile(), new String[0]);
            Path parentDir = metadataFilePath.getParent();
            if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(parentDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    ConfigureAuthenticationWorkflow.this.logException(e);
                    return Result.fileCreateDirectoryError(RcvMessages.format("CAU_CREATE_METADATA_DIRECTORY_ERROR_MSG", parentDir));
                }
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class ValidateAuthentication
    implements Step {
        private ValidateAuthentication() {
        }

        @Override
        public Result run() {
            WorkflowLogger logger = ConfigureAuthenticationWorkflow.this.getWorkflowLogger();
            logger.log(Level.INFO, "Validate authentication");
            if (ConfigureAuthenticationWorkflow.this.method.equals((Object)OCIAuthentication.Method.API_KEY)) {
                try {
                    ConfigFileAuthenticationDetailsProvider configFileAuthenticationDetailsProvider = new ConfigFileAuthenticationDetailsProvider(ConfigureAuthenticationWorkflow.this.auth.getConfigFile(), ConfigureAuthenticationWorkflow.this.auth.getProfileName());
                }
                catch (Exception e) {
                    ConfigureAuthenticationWorkflow.this.logException(e);
                    return Result.uawValidateAuthenticationError(ConfigureAuthenticationWorkflow.this.method.toString());
                }
            }
            if (ConfigureAuthenticationWorkflow.this.method.equals((Object)OCIAuthentication.Method.RESOURCE_PRINCIPAL)) {
                try {
                    String ociResourcePrincipalRptEndpoint = OCIUtils.getResourcePrincipalRptEndpoint();
                    ResourcePrincipalAuthenticationDetailsProvider resourcePrincipalAuthenticationDetailsProvider = ResourcePrincipalAuthenticationDetailsProvider.builder().build_1_1(ociResourcePrincipalRptEndpoint, null);
                }
                catch (Exception e) {
                    ConfigureAuthenticationWorkflow.this.logException(e);
                    return Result.uawValidateAuthenticationError(ConfigureAuthenticationWorkflow.this.method.toString());
                }
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class UpdateMetadata
    implements Step {
        private UpdateMetadata() {
        }

        @Override
        public Result run() {
            WorkflowLogger logger = ConfigureAuthenticationWorkflow.this.getWorkflowLogger();
            ScriptRunnerContext ctx = ConfigureAuthenticationWorkflow.this.getContext();
            logger.log(Level.INFO, "Update metadata");
            ConfigureAuthenticationWorkflow.this.globalMetadata.setAuthentication(new OCIAuthentication(ConfigureAuthenticationWorkflow.this.method, ConfigureAuthenticationWorkflow.this.ociConfig, ConfigureAuthenticationWorkflow.this.profileName));
            ConfigureAuthenticationWorkflow.this.globalMetadata.save();
            if (ConfigureAuthenticationWorkflow.this.conn != null) {
                Database db = RCVCommandBase.getDatabase(ConfigureAuthenticationWorkflow.this.conn);
                List<SshHelper> sshConnections = db.getDatabaseMetadataCache().getSshConnections();
                ConfigureAuthenticationWorkflow.copyAuthenticationFilesToRemoteNodes(sshConnections);
            }
            return new Result(Status.SUCCESS);
        }
    }
}

