/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVGrammar;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RCVVerbs;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.DatabaseConfig;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.jobs.FleetAgentJob;
import oracle.dbtools.extension.rcv.models.jobs.FleetAgentJobs;
import oracle.dbtools.extension.rcv.models.jobs.JobType;
import oracle.dbtools.extension.rcv.models.jobs.TimeUnit;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.utils.NamedConnectionsManager;
import oracle.dbtools.extension.rcv.utils.SshHelper;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.Token;
import oracle.dbtools.raptor.scheduler.SchedulerFile;
import oracle.dbtools.raptor.scheduler.exceptions.InvalidJobException;
import oracle.dbtools.raptor.scheduler.job.Job;

public class AddScheduleWorkflow
extends ProtectedDatabaseWorkflow {
    private boolean add = false;
    private Integer desiredInterval = null;
    private Integer desiredStartTime = null;
    private JobType jobType;
    private FleetAgentJob fleetAgentJob;
    private String connectionName;
    private boolean localOnly;
    private List<SshHelper> sshConnections = new ArrayList<SshHelper>();
    private Database database;
    private SchedulerFile schedulerFile;
    private WorkflowLogger logger;

    public AddScheduleWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        this(conn, ctx, command.getOptionValue((Id)RCVOptions.Options.JOB_TYPE) != null ? JobType.valueOf((String)command.getOptionValue((Id)RCVOptions.Options.JOB_TYPE)) : JobType.BACKUP);
        if (command.getOptionValue((Id)RCVOptions.Options.INTERVAL) != null) {
            this.desiredInterval = (Integer)command.getOptionValue((Id)RCVOptions.Options.INTERVAL);
        }
        if (command.getOptionValue((Id)RCVOptions.Options.START) != null) {
            this.desiredStartTime = (Integer)command.getOptionValue((Id)RCVOptions.Options.START);
        }
        this.add = ((Token)command.getTokens().get(1)).getValue().equalsIgnoreCase(RCVVerbs.ADD.name());
        this.localOnly = this.fleetAgentJob.isLocalOnly() || command.isFlagSet((Id)RCVOptions.Options.LOCAL);
    }

    public AddScheduleWorkflow(Connection conn, ScriptRunnerContext ctx, JobType jobType) {
        super(RCVCommand.SubCommand.CONFIGURE_SCHEDULE, conn, ctx);
        if (jobType != null) {
            this.jobType = jobType;
        }
        this.database = this.getDatabase();
        this.fleetAgentJob = FleetAgentJobs.get(this.database.getDbUniqueName(), jobType);
        this.connectionName = this.database.getFleetAgentContext().getConnectionName();
        this.localOnly = this.fleetAgentJob.isLocalOnly();
    }

    public AddScheduleWorkflow add(boolean add) {
        this.add = add;
        return this;
    }

    @Override
    public String getLockFileName() {
        return String.join((CharSequence)File.separator, FleetAgentContext.get(this.getDbUniqueName()).getLocksDirectory(), String.valueOf((Object)RCVCommand.SubCommand.CONFIGURE_SCHEDULE) + ".lock");
    }

    @Override
    public Result run(boolean verbose) {
        this.logger = this.getWorkflowLogger();
        if (verbose) {
            this.logger.log(Level.INFO, "Log file: " + this.logger.getLogFile());
        }
        String jobName = this.fleetAgentJob.getJobName();
        if (this.desiredInterval == null) {
            this.desiredInterval = this.fleetAgentJob.getDefaultInterval();
        }
        if (!this.localOnly) {
            this.sshConnections = this.database.getDatabaseMetadataCache().getSshConnections(this.getWorkflowLogger().getLogger());
        }
        this.saveConnection();
        this.schedulerFile = new SchedulerFile();
        Job job = this.createJob(this.schedulerFile);
        try {
            this.schedulerFile.addJob(job);
        }
        catch (IOException e) {
            this.logException(e);
            return Result.schedulerFileError(RcvMessages.format("SCHEDULER_FILE_ADD_JOB_ERROR_MSG", jobName));
        }
        catch (InvalidJobException e) {
            this.logException(e);
            return Result.schedulerJobSyntaxError(jobName);
        }
        if (!this.startSchedulerDaemon()) {
            return Result.sbjStartSchedulerError();
        }
        if (!this.localOnly) {
            return this.runOnRemoteNodes(job, this.fleetAgentJob.getTimeUnit());
        }
        return new Result(Status.SUCCESS);
    }

    private void saveConnection() {
        ScriptRunnerContext ctx = this.getContext();
        Connection conn = this.getConnection();
        NamedConnectionsManager.saveConnection(conn, ctx, this.connectionName);
        if (!this.localOnly) {
            NamedConnectionsManager.propagateNamedConnectionToRemoteNodes(this.connectionName, this.sshConnections);
        }
    }

    private Job createJob(SchedulerFile schedulerFile) {
        Job job = this.fleetAgentJob.getCurrentJob(schedulerFile);
        Integer currentStartTime = null;
        Integer currentInterval = null;
        if (job != null) {
            int[] currentSchedule = FleetAgentJob.getSchedule(job, this.fleetAgentJob.getTimeUnit());
            if (currentSchedule == null) {
                return this.fleetAgentJob.createJob(this.desiredStartTime, this.desiredInterval);
            }
            currentStartTime = currentSchedule[0];
            currentInterval = currentSchedule[1];
            if (this.add) {
                this.logger.log(Level.FINE, "Job is already scheduled. Please run " + String.valueOf((Object)RCVGrammar.Base.RCV) + " " + String.valueOf((Object)RCVCommand.SubCommand.CONFIGURE_SCHEDULE) + " if you want to change the existing job interval.");
                return job;
            }
        }
        if (this.desiredStartTime != null && this.desiredInterval != null ? job != null && this.desiredInterval.equals(currentInterval) && this.desiredStartTime.equals(currentStartTime) : (this.desiredStartTime != null ? job != null && this.desiredStartTime.equals(currentStartTime) : this.desiredInterval != null && job != null && this.desiredInterval.equals(currentInterval))) {
            return job;
        }
        return this.fleetAgentJob.createJob(this.desiredStartTime, this.desiredInterval);
    }

    private Result runOnRemoteNodes(Job job, TimeUnit timeUnit) {
        int[] schedule = FleetAgentJob.getSchedule(job, timeUnit);
        if (!this.localOnly && schedule != null) {
            RCVCommand rcvCommand = new RCVCommand(RCVCommand.SubCommand.CONFIGURE_SCHEDULE).addFlag(RCVOptions.Options.LOCAL).addOption(RCVOptions.Options.INTERVAL, String.valueOf(schedule[1])).addOption(RCVOptions.Options.START, String.valueOf(schedule[0])).addOption(RCVOptions.Options.JOB_TYPE, String.valueOf((Object)this.jobType));
            for (SshHelper sshConnection : this.sshConnections) {
                String remoteHost = sshConnection.getHost();
                this.logger.log(Level.FINE, String.format("running %s on remote host %s", rcvCommand.toString(), remoteHost));
                SystemCommand.ExecutionResult scheduleBackupResult = sshConnection.executeRcvCommand(this.connectionName, rcvCommand, this.database.getFleetAgentContext().getScriptsDirectory() + File.separator + "schedule_backup.sql");
                int rc = scheduleBackupResult.getReturnCode();
                String scheduleBackupResultOutput = scheduleBackupResult.getOutput();
                this.logger.log(Level.FINE, scheduleBackupResultOutput);
                if (rc != 0 || scheduleBackupResultOutput.toLowerCase().contains("fail")) {
                    return Result.wfRemoteCommandError(RcvMessages.format("SBJ_FAILED_SCHEDULE_TASK_ERROR_MSG", remoteHost));
                }
                this.logger.log(Level.FINE, "Successfully scheduled task on remote host " + remoteHost);
            }
        }
        return new Result(Status.SUCCESS);
    }

    private boolean startSchedulerDaemon() {
        String sqlclHome = System.getenv("SQL_HOME");
        if (sqlclHome == null) {
            sqlclHome = DatabaseConfig.getOracleHome(this.getDbUniqueName());
        }
        String sqlPath = String.join((CharSequence)File.separator, sqlclHome, "bin", "sql");
        List<String> daemonStatusArgs = List.of(sqlPath, "-daemon", "status");
        List<String> daemonStartArgs = List.of(sqlPath, "-daemon", "start");
        SystemCommand.ExecutionResult statusResult = new SystemCommand().logger(this.logger.getLogger()).run(daemonStatusArgs);
        this.logger.log(Level.FINE, statusResult.getOutput());
        if (statusResult.getReturnCode() == 0 && statusResult.getOutput().toLowerCase().contains("daemon is running")) {
            return true;
        }
        SystemCommand sqlDaemonCommand = new SystemCommand().logger(this.logger.getLogger());
        SystemCommand.ExecutionResult startResult = sqlDaemonCommand.run(daemonStartArgs);
        this.logger.log(Level.FINE, startResult.getOutput());
        if (startResult.getReturnCode() == 0) {
            return true;
        }
        if (statusResult.getReturnCode() == -1) {
            throw Result.commandExecException("Failed to start SQLCL daemon process.");
        }
        if (startResult.getOutput().toLowerCase().contains("daemon is already running")) {
            return true;
        }
        this.logger.log(Level.INFO, startResult.getOutput());
        return false;
    }
}

