/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.WalletEntry;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public class WalletManager {
    public static final String CREDENTIAL_CONNECT_STRING = "oracle.security.client.connect_string";
    public static final String CREDENTIAL_USERNAME = "oracle.security.client.username";
    public static final String CREDENTIAL_PASSWORD = "oracle.security.client.password";
    public static final String WALLET_FILE = "cwallet.sso";

    public static boolean walletContainsConnectString(OracleWallet wallet, String alias) {
        try {
            return WalletManager.storeContainsConnectString(wallet.getSecretStore(), alias);
        }
        catch (IOException | OracleSecretStoreException e) {
            throw Result.walletWalletWorkException(wallet.getLocation(), (Exception)e);
        }
    }

    public static boolean walletContainsUser(OracleWallet wallet, String userName) {
        try {
            return WalletManager.storeContainsUser(wallet.getSecretStore(), userName);
        }
        catch (IOException | OracleSecretStoreException e) {
            throw Result.walletWalletWorkException(wallet.getLocation(), (Exception)e);
        }
    }

    public static boolean storeContainsUser(OracleSecretStore store, String userName) {
        try {
            Enumeration e = store.internalAliases();
            while (e.hasMoreElements()) {
                String storeUserName;
                String field = (String)e.nextElement();
                if (!field.startsWith(CREDENTIAL_USERNAME) || !(storeUserName = new String(store.getSecret(field))).equals(userName)) continue;
                return true;
            }
        }
        catch (OracleSecretStoreException e) {
            String error = RcvMessages.format("WALLET_STORE_INT_ALIASES_MSG", userName);
            throw Result.walletStoreWorkException(error, (Exception)((Object)e));
        }
        return false;
    }

    public static boolean storeContainsConnectString(OracleSecretStore store, String alias) {
        try {
            Enumeration e = store.internalAliases();
            while (e.hasMoreElements()) {
                String connectString;
                String field = (String)e.nextElement();
                if (!field.startsWith(CREDENTIAL_CONNECT_STRING) || !(connectString = new String(store.getSecret(field))).equalsIgnoreCase(alias)) continue;
                return true;
            }
        }
        catch (Exception e) {
            String error = RcvMessages.format("WALLET_STORE_ALIASES_MSG", alias);
            throw Result.walletStoreWorkException(error, e);
        }
        return false;
    }

    public static char[] getSecretForUser(OracleWallet wallet, String targetUser) {
        OracleSecretStore store;
        try {
            store = wallet.getSecretStore();
        }
        catch (IOException | OracleSecretStoreException e) {
            throw Result.walletWalletWorkException(wallet.getLocation(), (Exception)e);
        }
        try {
            Enumeration e = store.internalAliases();
            while (e.hasMoreElements()) {
                String user;
                String field = (String)e.nextElement();
                if (!field.startsWith(CREDENTIAL_USERNAME) || !(user = new String(store.getSecret(field))).equals(targetUser)) continue;
                String id = field.substring(CREDENTIAL_USERNAME.length());
                return store.getSecret(CREDENTIAL_PASSWORD + id);
            }
        }
        catch (OracleSecretStoreException e) {
            String error = RcvMessages.format("WALLET_STORE_GET_SECRET_MSG", targetUser);
            throw Result.walletStoreWorkException(error, (Exception)((Object)e));
        }
        return null;
    }

    public static char[] getSecretForAlias(OracleWallet wallet, String alias) {
        try {
            OracleSecretStore store = wallet.getSecretStore();
            Enumeration e = store.internalAliases();
            while (e.hasMoreElements()) {
                String connectString;
                String field = (String)e.nextElement();
                if (!field.startsWith(CREDENTIAL_CONNECT_STRING) || !(connectString = new String(store.getSecret(field))).equals(alias)) continue;
                String id = field.substring(CREDENTIAL_CONNECT_STRING.length());
                return store.getSecret(CREDENTIAL_PASSWORD + id);
            }
        }
        catch (IOException | OracleSecretStoreException e) {
            String error = RcvMessages.format("WALLET_STORE_ALIASES_MSG", alias);
            throw Result.walletStoreWorkException(error, (Exception)e);
        }
        return null;
    }

    public static void updateAlias(OracleWallet wallet, String oldAlias, String newAlias) throws IOException, OracleSecretStoreException {
        if (oldAlias.equals(newAlias)) {
            return;
        }
        OracleSecretStore store = wallet.getSecretStore();
        Enumeration e = store.internalAliases();
        while (e.hasMoreElements()) {
            String connectString;
            String field = (String)e.nextElement();
            if (!field.startsWith(CREDENTIAL_CONNECT_STRING) || !(connectString = new String(store.getSecret(field))).equals(oldAlias)) continue;
            store.setSecret(field, newAlias.toCharArray());
            wallet.setSecretStore(store);
            wallet.save();
            return;
        }
    }

    public static OracleWallet getWallet(String path) {
        Utils.createParentDirectoryForFile(path);
        OracleWallet oraWallet = new OracleWallet();
        oraWallet.setLocation(path);
        try {
            oraWallet.open(path, null);
            OracleSecretStore store = oraWallet.getSecretStore();
            oraWallet.setSecretStore(store);
            oraWallet.save();
        }
        catch (IOException | OracleSecretStoreException e) {
            throw Result.walletCreateWalletException(path, (Exception)e);
        }
        return oraWallet;
    }

    public static OracleWallet createWallet(String path) {
        Utils.createParentDirectoryForFile(path);
        OracleWallet oraWallet = new OracleWallet();
        try {
            oraWallet.setLocation(path);
            if (!oraWallet.exists(path)) {
                oraWallet.createSSO();
                oraWallet.saveAs(path);
            }
            oraWallet.open(path, null);
            OracleSecretStore store = oraWallet.getSecretStore();
            oraWallet.setSecretStore(store);
            oraWallet.save();
        }
        catch (IOException | OracleSecretStoreException e) {
            throw Result.walletCreateWalletException(path, (Exception)e);
        }
        return oraWallet;
    }

    public static OracleWallet createWallet(String path, String password) {
        byte bWalletConf = 0;
        OracleWallet wallet = new OracleWallet();
        try {
            wallet.setLocation(path);
            if (!wallet.exists(path)) {
                wallet.create(password.toCharArray());
                wallet.saveAs(path, bWalletConf);
            }
        }
        catch (IOException e) {
            throw Result.walletCreateWalletException(path, e);
        }
        return wallet;
    }

    public static void addCertificate(OracleWallet wallet, String certificateString) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        wallet.importCertB64(certificateString, true);
        wallet.save();
    }

    public static OracleWallet addCertificate(OracleWallet wallet, Path certificatePath) {
        block3: {
            try {
                String text = Files.readString(certificatePath);
                wallet.importCertB64(text, true);
                wallet.save();
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                String error = String.format("Failed to import certificate %s into wallet %s", certificatePath.toString(), wallet.getLocation());
                throw new RuntimeException(error, e);
            }
            catch (KeyStoreException e) {
                String error = e.getMessage();
                if (error.startsWith("PKI-04003: The trusted certificate is already present in the wallet.")) break block3;
                error = String.format("Failed to import certificate %s into wallet %s", certificatePath.toString(), wallet.getLocation());
                throw new RuntimeException(e);
            }
        }
        return wallet;
    }

    public static void addCredential(OracleWallet wallet, String user, char[] password, String alias) {
        try {
            OracleSecretStore store = wallet.getSecretStore();
            if (WalletManager.storeContainsConnectString(store, alias)) {
                store.modifyCredential(alias.toCharArray(), user.toCharArray(), password);
            } else {
                store.createCredential(alias.toCharArray(), user.toCharArray(), password);
            }
            wallet.setSecretStore(store);
            wallet.save();
        }
        catch (IOException | OracleSecretStoreException e) {
            throw Result.walletAddCredentialException(wallet.getLocation(), (Exception)e);
        }
    }

    public static void deleteCredentials(OracleWallet wallet, List<String> aliases) throws OracleSecretStoreException, IOException {
        OracleSecretStore store = wallet.getSecretStore();
        for (String alias : aliases) {
            if (!WalletManager.storeContainsConnectString(store, alias)) continue;
            store.deleteCredential(alias.toCharArray());
        }
        wallet.setSecretStore(store);
        wallet.save();
    }

    public static void deleteCredential(OracleWallet wallet, String alias) throws OracleSecretStoreException, IOException {
        OracleSecretStore store = wallet.getSecretStore();
        if (WalletManager.storeContainsConnectString(store, alias)) {
            store.deleteCredential(alias.toCharArray());
        }
        wallet.setSecretStore(store);
        wallet.save();
    }

    public static List<String> getAliasesForUser(OracleWallet wallet, String targetUser) {
        ArrayList<String> aliases = new ArrayList<String>();
        try {
            OracleSecretStore store = wallet.getSecretStore();
            Enumeration e = store.internalAliases();
            while (e.hasMoreElements()) {
                String user;
                String field = (String)e.nextElement();
                if (!field.startsWith(CREDENTIAL_USERNAME) || !(user = new String(store.getSecret(field))).equals(targetUser)) continue;
                String id = field.substring(CREDENTIAL_USERNAME.length());
                aliases.add(new String(store.getSecret(CREDENTIAL_CONNECT_STRING + id)));
            }
        }
        catch (IOException | OracleSecretStoreException e) {
            throw new RuntimeException("Failed to get wallet aliases for user " + targetUser, e);
        }
        return aliases;
    }

    public static HashMap<String, WalletEntry> getWalletEntries(OracleWallet wallet) {
        HashMap<String, WalletEntry.Builder> walletEntryBuilders = new HashMap<String, WalletEntry.Builder>();
        HashMap<String, WalletEntry> walletEntries = new HashMap<String, WalletEntry>();
        try {
            OracleSecretStore store = wallet.getSecretStore();
            Enumeration e = store.internalAliases();
            while (e.hasMoreElements()) {
                WalletEntry.Builder builder;
                String id;
                String field = (String)e.nextElement();
                if (field.startsWith(CREDENTIAL_CONNECT_STRING)) {
                    String connectString = new String(store.getSecret(field));
                    id = field.substring(CREDENTIAL_CONNECT_STRING.length());
                    builder = walletEntryBuilders.getOrDefault(id, new WalletEntry.Builder());
                    walletEntryBuilders.put(id, builder.credentialAlias(connectString));
                    continue;
                }
                if (field.startsWith(CREDENTIAL_USERNAME)) {
                    String username = new String(store.getSecret(field));
                    id = field.substring(CREDENTIAL_USERNAME.length());
                    builder = walletEntryBuilders.getOrDefault(id, new WalletEntry.Builder());
                    walletEntryBuilders.put(id, builder.username(username));
                    continue;
                }
                if (!field.startsWith(CREDENTIAL_PASSWORD)) continue;
                char[] password = store.getSecret(field);
                id = field.substring(CREDENTIAL_PASSWORD.length());
                builder = walletEntryBuilders.getOrDefault(id, new WalletEntry.Builder());
                walletEntryBuilders.put(id, builder.password(password));
            }
            for (String id : walletEntryBuilders.keySet()) {
                WalletEntry.Builder builder = (WalletEntry.Builder)walletEntryBuilders.get(id);
                walletEntries.put(id, builder.build());
            }
        }
        catch (IOException | OracleSecretStoreException e) {
            throw Result.walletStoreWorkException(e.getMessage(), (Exception)e);
        }
        return walletEntries;
    }

    public static String getWalletRoot(Connection conn) {
        return DatabaseUtils.getParameter(conn, "WALLET_ROOT");
    }

    public static void migrateWallet(String sourceWalletDirectory, String targetWalletDirectory) {
        String srcWalletFile;
        Path srcWalletFilePath;
        if (Files.exists(Paths.get(sourceWalletDirectory, new String[0]), new LinkOption[0]) && Files.exists(Paths.get(targetWalletDirectory, new String[0]), new LinkOption[0]) && !sourceWalletDirectory.equals(targetWalletDirectory) && Files.exists(srcWalletFilePath = Paths.get(srcWalletFile = String.join((CharSequence)File.separator, sourceWalletDirectory, WALLET_FILE), new String[0]), new LinkOption[0])) {
            OracleWallet srcWallet = WalletManager.createWallet(sourceWalletDirectory);
            OracleWallet targetWallet = WalletManager.createWallet(targetWalletDirectory);
            HashMap<String, WalletEntry> walletEntries = WalletManager.getWalletEntries(srcWallet);
            for (String id : walletEntries.keySet()) {
                WalletEntry entry = walletEntries.get(id);
                WalletManager.addCredential(targetWallet, entry.getUserName(), entry.getPassword(), entry.getCredentialAlias());
            }
        }
    }

    public static boolean isWallet(String directory) {
        if (!Files.exists(Paths.get(directory, new String[0]), new LinkOption[0])) {
            return false;
        }
        OracleWallet oraWallet = new OracleWallet();
        try {
            oraWallet.setLocation(directory);
            return oraWallet.exists(directory);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean walletIsAccessible(String walletLocation) {
        Path walletPath = Paths.get(walletLocation, new String[0]);
        if (Files.exists(walletPath, new LinkOption[0]) && !Files.isDirectory(walletPath, new LinkOption[0])) {
            return false;
        }
        if (!WalletManager.isWallet(walletLocation)) {
            return true;
        }
        try {
            WalletManager.getWallet(walletLocation);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }
}

