/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.connections.util.ConnectionsSupport;
import oracle.dbtools.core.io.file.HomeFolder;
import oracle.dbtools.core.jdbc.tns.TNSEntry;
import oracle.dbtools.core.jdbc.tns.TNSNames;
import oracle.dbtools.core.secrets.Secrets;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.utils.SshHelper;
import oracle.dbtools.extension.rcv.utils.TnsnamesHelper;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.runner.SqlClCommandsRunner;

public class NamedConnectionsManager {
    public static List<ConnectionDefinition> getConnectionDefinitions(String connectionName) {
        return ConnectionStorage.instance().listConnectionDirectories().stream().map(arg_0 -> ((ConnectionStorage)ConnectionStorage.instance()).loadConnection(arg_0)).filter(cd -> cd.getConnectionName().equals(connectionName)).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<ConnectionDefinition> getConnectionDefinition(String connectionName) {
        List<ConnectionDefinition> definitions = NamedConnectionsManager.getConnectionDefinitions(connectionName);
        ConnectionsSupport support = ConnectionsSupport.builder().build();
        Iterator<ConnectionDefinition> iterator = definitions.iterator();
        while (iterator.hasNext()) {
            ConnectionDefinition def = iterator.next();
            try {
                ConfigurationProperties dbtoolsProps = def.getDbtoolsProperties();
                ConfigurationProperties ojdbcProps = def.getOjdbcProperties();
                String username = dbtoolsProps.getProperty((CharSequence)"userName");
                TextSecret password = def.getWallet().getPassword();
                String role = ojdbcProps.getProperty((CharSequence)"internal_logon");
                Connection conn = support.openConnection(connectionName, username, password, role);
                try {
                    if (conn == null) continue;
                    Optional<ConnectionDefinition> optional = Optional.of(def);
                    return optional;
                }
                finally {
                    if (conn == null) continue;
                    conn.close();
                }
            }
            catch (SQLException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static Connections.Identifier getConnectionDefinitionId(String connectionName) {
        Optional<ConnectionDefinition> existingConnectionDefinition = NamedConnectionsManager.getConnectionDefinition(connectionName);
        return existingConnectionDefinition.map(ConnectionDefinition::getIdentifier).orElse(null);
    }

    public static boolean connectionExists(String connectionName) {
        return NamedConnectionsManager.getConnectionDefinition(connectionName).isPresent();
    }

    public static Optional<Connection> getConnection(String connectionName) {
        ConnectionsSupport support = ConnectionsSupport.builder().build();
        try {
            return Optional.ofNullable(support.openConnection(connectionName));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static void deleteConnection(String connectionName) {
        ConnectionStorage storage = ConnectionStorage.of((HomeFolder)HomeFolder.builder().build());
        storage.deleteConnection(connectionName);
    }

    public static void saveConnection(String connectionName, String connectString, String userName, String password, String privilege) {
        List<ConnectionDefinition> connectionDefinitions = NamedConnectionsManager.getConnectionDefinitions(connectionName);
        for (int i = 0; i < connectionDefinitions.size(); ++i) {
            NamedConnectionsManager.deleteConnection(connectionName);
        }
        ConnectionStorage storage = ConnectionStorage.of((HomeFolder)HomeFolder.builder().build());
        ConnectionsSupport connectionsSupport = ConnectionsSupport.of((ConnectionStorage)storage);
        ConnectionDefinition def = connectionsSupport.createOracleConnectionDefinition(connectionName, connectString, userName, Secrets.instance().of(password.toCharArray(), true));
        connectionsSupport.storeConnection(def);
        ConfigurationProperties.Builder builder = ConfigurationProperties.builder();
        if (privilege != null) {
            builder.put("internal_logon", privilege);
        }
        storage.storeObject(def.getIdentifier(), "ojdbc.properties", (Object)builder.build(), ConnectionDefinition::outputProperties);
    }

    public static void saveConnection(Connection conn, ScriptRunnerContext ctx, String connectionName) {
        block8: {
            if (conn == null || ctx == null || ctx.getCurrentConnection() == null) {
                return;
            }
            try {
                SqlClCommandsRunner commandsRunner;
                String output;
                ConnectionContext connectionContext;
                Optional<ConnectionDefinition> existingConnectionDefinition = NamedConnectionsManager.getConnectionDefinition(connectionName);
                if (existingConnectionDefinition.isPresent() && (connectionContext = (ConnectionContext)ctx.getService(ConnectionContext.class)) != null && connectionContext.getCurrentConnectorType() != null && connectionContext.getCurrentConnectorType().getName().equalsIgnoreCase("STORE")) {
                    return;
                }
                if (existingConnectionDefinition.isEmpty() ? (output = (commandsRunner = SqlClCommandsRunner.builder().connection(ctx.getCurrentConnection()).context(ctx).build()).run("conn -save " + connectionName + " -savepwd")) == null || output.isEmpty() || output.contains("already exists") : (output = (commandsRunner = SqlClCommandsRunner.builder().connection(ctx.getCurrentConnection()).context(ctx).build()).run("conn -save " + connectionName + " -savepwd -replace")) == null || output.isEmpty()) {
                    throw Result.namedConnectionSaveSqlclException(connectionName);
                }
                existingConnectionDefinition = NamedConnectionsManager.getConnectionDefinition(connectionName);
                if (!existingConnectionDefinition.isPresent()) break block8;
                ConnectionDefinition connectionDefinition = existingConnectionDefinition.get();
                try {
                    String url = conn.getMetaData().getURL();
                    if (!url.strip().startsWith("jdbc:oracle:thin:@")) break block8;
                    url = url.substring("jdbc:oracle:thin:@".length());
                    String dbUniqueName = RCVCommandBase.getDbUniqueName(conn);
                    String tnsnamesPath = TnsnamesHelper.getDefaultTnsnamesFile(dbUniqueName);
                    if (!Files.exists(Paths.get(tnsnamesPath, new String[0]), new LinkOption[0])) break block8;
                    TNSNames tnsNames = TnsnamesHelper.getTnsNames(tnsnamesPath);
                    for (String alias : tnsNames.nsNames()) {
                        if (!alias.equalsIgnoreCase(url)) continue;
                        TNSEntry entry = tnsNames.getTNSEntry(alias);
                        String descriptors = entry.getConnectionDescriptor();
                        ConfigurationProperties properties = existingConnectionDefinition.get().getDbtoolsProperties();
                        properties = properties.withProperty((CharSequence)"connectionString", descriptors);
                        ConnectionStorage.instance().storeObject(connectionDefinition.getIdentifier(), "dbtools.properties", (Object)properties, ConnectionDefinition::outputProperties);
                        break;
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (IOException e) {
                throw Result.namedConnectionSaveException(connectionName, e);
            }
        }
    }

    public static void propagateNamedConnectionToRemoteNodes(String connectionName, List<SshHelper> sshConnections) {
        String connectionFolder = NamedConnectionsManager.getConnectionFolder(connectionName);
        String sqlclHome = System.getenv("SQL_HOME");
        String sqlPath = String.join((CharSequence)File.separator, sqlclHome, "bin", "sql");
        if (connectionFolder != null) {
            for (SshHelper sshConnection : sshConnections) {
                SystemCommand.ExecutionResult executionResult = sshConnection.executeCommand(String.format("echo 'cm list' | %s /nolog", sqlPath));
                if (executionResult.getReturnCode() == 0) {
                    String[] lines;
                    StringBuilder sb = new StringBuilder();
                    for (String line : lines = executionResult.getOutput().split("\n")) {
                        if (!line.contains(connectionName)) continue;
                        sb.append("cm delete -conn ").append(connectionName).append(";\n");
                    }
                    if (sb.length() > 0) {
                        SystemCommand.ExecutionResult executionResult2 = sshConnection.executeCommand(String.format("echo -e '%s' | %s /nolog", sb, sqlPath));
                    }
                }
                sshConnection.copy(connectionFolder, connectionFolder);
            }
        }
    }

    public static String getConnectionFolder(String connectionName) {
        Optional<String> id = ConnectionStorage.instance().listConnectionDirectories().stream().filter(dir -> {
            ConnectionDefinition cd = ConnectionStorage.instance().loadConnection(dir);
            return cd.getConnectionName().equals(connectionName);
        }).findFirst();
        if (id.isPresent()) {
            return HomeFolder.ofSystem().connectionsPath().resolve(id.get()).toString();
        }
        return null;
    }

    public static TextSecret getPasswordForConnection(String connectionName) {
        Optional<ConnectionDefinition> definition = NamedConnectionsManager.getConnectionDefinition(connectionName);
        TextSecret secret = definition.map(connectionDefinition -> connectionDefinition.getWallet().getPassword()).orElse(null);
        assert (secret != null);
        char[] passwordChars = (char[])secret.map(chars -> Arrays.copyOf(chars, chars.length));
        return secret;
    }
}

