/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.rcvconf;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.util.Optional;
import oracle.dbtools.extension.rcv.models.LogArchiveDestination;
import oracle.dbtools.extension.rcv.utils.ConfigurationManager;

public class CurrentState {
    private static final String RMAN_CATALOG_CONNECTION = "rmanCatalogConnection";
    private static final String TNSNAMES_ORA = "tnsNamesOra";
    private static final String WALLET_ENTRIES = "walletEntries";
    private static final String VPC_USER = "vpcUser";
    private static final String TNS_ALIASES = "tnsAliases";
    private static final String LOG_ARCHIVE_CONFIG = "logArchiveConfig";
    private static final String LOG_ARCHIVE_DESTINATION_GROUPS = "logArchiveDestinationGroups";
    private String dbUniqueName;
    private String rmanCatalogConnection;
    private String tnsnamesOra;
    private String vpcUser;
    private String[] tnsAliases;
    private String[] logArchiveConfig;
    private LogArchiveDestination[] logArchiveDestinationGroups;

    public static CurrentState getCurrentState(JsonObject jsonObject, String dbUniqueName) {
        CurrentState currentState = new CurrentState();
        currentState.dbUniqueName = dbUniqueName;
        for (String key : jsonObject.keySet()) {
            JsonArray jsonArray;
            int i;
            if (key.equalsIgnoreCase(RMAN_CATALOG_CONNECTION)) {
                currentState.rmanCatalogConnection = ConfigurationManager.updateAliasWithDbUniqueName(dbUniqueName, jsonObject.getString(RMAN_CATALOG_CONNECTION));
                continue;
            }
            if (key.equalsIgnoreCase(TNSNAMES_ORA)) {
                currentState.tnsnamesOra = jsonObject.getString(TNSNAMES_ORA);
                continue;
            }
            if (key.equalsIgnoreCase(WALLET_ENTRIES)) {
                JsonObject walletEntries = jsonObject.getJsonObject(WALLET_ENTRIES);
                for (String walletEntriesKey : walletEntries.keySet()) {
                    if (walletEntriesKey.equalsIgnoreCase(VPC_USER)) {
                        currentState.vpcUser = walletEntries.getString(walletEntriesKey);
                        continue;
                    }
                    if (!walletEntriesKey.equalsIgnoreCase(TNS_ALIASES)) continue;
                    currentState.tnsAliases = CurrentState.toArray(walletEntries.getJsonArray(TNS_ALIASES));
                    for (i = 0; i < currentState.tnsAliases.length; ++i) {
                        currentState.tnsAliases[i] = ConfigurationManager.updateAliasWithDbUniqueName(dbUniqueName, currentState.tnsAliases[i]);
                    }
                }
                continue;
            }
            if (key.equalsIgnoreCase(LOG_ARCHIVE_CONFIG)) {
                currentState.logArchiveConfig = CurrentState.toArray(jsonObject.getJsonArray(LOG_ARCHIVE_CONFIG));
                for (int i2 = 0; i2 < currentState.logArchiveConfig.length; ++i2) {
                    currentState.logArchiveConfig[i2] = ConfigurationManager.updateAliasWithDbUniqueName(dbUniqueName, currentState.logArchiveConfig[i2]);
                }
                continue;
            }
            if (!key.equalsIgnoreCase(LOG_ARCHIVE_DESTINATION_GROUPS) || (jsonArray = jsonObject.getJsonArray(LOG_ARCHIVE_DESTINATION_GROUPS)).isEmpty()) continue;
            JsonArray firstArray = jsonArray.getJsonArray(0);
            LogArchiveDestination[] destinations = new LogArchiveDestination[firstArray.size()];
            for (i = 0; i < firstArray.size(); ++i) {
                destinations[i] = LogArchiveDestination.createInstance(firstArray.getJsonObject(i));
                String serviceName = ConfigurationManager.updateAliasWithDbUniqueName(dbUniqueName, destinations[i].getService());
                destinations[i].setService(serviceName);
                destinations[i].setDbUniqueName(serviceName);
            }
            currentState.logArchiveDestinationGroups = destinations;
        }
        return currentState;
    }

    private static String[] toArray(JsonArray jsonArray) {
        String[] arr = new String[jsonArray.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = jsonArray.getString(i);
        }
        return arr;
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public Optional<String> getRmanCatalogConnection() {
        if (this.rmanCatalogConnection == null) {
            return Optional.empty();
        }
        return Optional.of(this.rmanCatalogConnection);
    }

    public Optional<String> getTnsnamesOra() {
        return Optional.ofNullable(this.tnsnamesOra);
    }

    public Optional<String> getVpcUser() {
        return Optional.ofNullable(this.vpcUser);
    }

    public Optional<String[]> getTnsAliases() {
        return Optional.ofNullable(this.tnsAliases);
    }

    public Optional<String[]> getLogArchiveConfig() {
        return Optional.ofNullable(this.logArchiveConfig);
    }

    public Optional<LogArchiveDestination[]> getLogArchiveDestinationGroups() {
        return Optional.ofNullable(this.logArchiveDestinationGroups);
    }
}

