/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.database;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.RCVContext;
import oracle.dbtools.extension.rcv.models.database.DatabaseConfig;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.utils.SshHelper;

public class FullDatabaseConfig
implements DatabaseConfig {
    private static final Pattern databaseNamePattern = Pattern.compile("Database name:\\s+(.*)");
    private static final Pattern oracleHomePattern = Pattern.compile("Oracle home:\\s+(.*)");
    private static final Pattern oracleUserPattern = Pattern.compile("Oracle user:\\s+(.*)");
    private static final Pattern SpFilePattern = Pattern.compile("Spfile:\\s+(.*)");
    private static final Pattern passwordFilePattern = Pattern.compile("Password file:\\s+(.*)");
    private static final Pattern rolePattern = Pattern.compile("Database role:\\s+(.*)");
    private static final Pattern databaseInstancesPattern = Pattern.compile("Database instances:\\s+(.*)");
    private static final Pattern singleDatabaseInstancePattern = Pattern.compile("Database instance:\\s+(.*)");
    private static final Pattern nodesPattern = Pattern.compile("Configured nodes:\\s+(.*)");
    private static final Pattern instanceStatusPattern = Pattern.compile("Instance (\\S+) is (?:not )?running on node (\\S+)");
    private static ConcurrentHashMap<String, FullDatabaseConfig> dbConfigMap = new ConcurrentHashMap();
    private String dbUniqueName;
    private String databaseName;
    private String oracleHome;
    private String oracleUser;
    private String spFile;
    private String passwordFile;
    private String[] databaseInstances;
    private String[] nodes;
    private List<String> remoteNodes = new ArrayList<String>();
    private List<SshHelper> sshConnections = new ArrayList<SshHelper>();
    private String role;
    private String oracleSid;

    private FullDatabaseConfig(Builder builder) {
        this.dbUniqueName = builder.dbUniqueName;
        this.databaseName = builder.databaseName;
        this.oracleHome = builder.oracleHome;
        this.oracleUser = builder.oracleUser;
        this.spFile = builder.spFile;
        this.passwordFile = builder.passwordFile;
        this.role = builder.role;
        this.nodes = Objects.requireNonNullElseGet(builder.nodes, () -> new String[]{RCVContext.getLocalHost()});
        this.databaseInstances = Objects.requireNonNullElseGet(builder.databaseInstances, () -> new String[0]);
    }

    @Override
    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String getOracleHome() {
        return this.oracleHome;
    }

    public String getOracleUser() {
        return this.oracleUser;
    }

    public String getSpFile() {
        return this.spFile;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public String[] getDatabaseInstances() {
        return this.databaseInstances;
    }

    public String[] getNodes() {
        return this.nodes;
    }

    public String getRole() {
        return this.role;
    }

    @Override
    public String getOracleSid() {
        if (this.oracleSid == null) {
            String shortHostName = RCVContext.getLocalHost();
            for (int i = 0; i < this.nodes.length; ++i) {
                if (!this.nodes[i].equalsIgnoreCase(shortHostName) || this.databaseInstances.length <= i) continue;
                this.oracleSid = this.databaseInstances[i];
                return this.oracleSid;
            }
            String fqdn = RCVContext.getLocalHost(true);
            for (int i = 0; i < this.nodes.length; ++i) {
                if (!this.nodes[i].equalsIgnoreCase(fqdn) || this.databaseInstances.length <= i) continue;
                this.oracleSid = this.databaseInstances[i];
                return this.oracleSid;
            }
        }
        return this.oracleSid;
    }

    public List<String> getRemoteNodes() {
        if (this.remoteNodes.isEmpty()) {
            String shortHostName = RCVContext.getLocalHost();
            String fqdn = RCVContext.getLocalHost(true);
            for (String node : this.nodes) {
                if (node.equalsIgnoreCase(shortHostName) || node.equalsIgnoreCase(fqdn)) continue;
                this.remoteNodes.add(node);
            }
        }
        return this.remoteNodes;
    }

    public List<SshHelper> getSshConnections() {
        if (this.sshConnections.isEmpty()) {
            this.getRemoteNodes();
            for (String remoteNode : this.remoteNodes) {
                this.sshConnections.add(RCVContext.getSshConnection(remoteNode, null));
            }
        }
        return this.sshConnections;
    }

    public static Optional<FullDatabaseConfig> getDatabaseConfig(String dbUniqueName) {
        return FullDatabaseConfig.getDatabaseConfig(RCVCommandBase.getOracleHome(), dbUniqueName);
    }

    public static Optional<FullDatabaseConfig> getDatabaseConfig(String oracleHome, String dbUniqueName) {
        if (dbConfigMap.containsKey(dbUniqueName)) {
            return Optional.of(dbConfigMap.get(dbUniqueName));
        }
        String srvctl = String.join((CharSequence)File.separator, oracleHome, "bin", "srvctl");
        if (!Files.exists(Path.of(srvctl, new String[0]), new LinkOption[0])) {
            return Optional.empty();
        }
        SystemCommand.ExecutionResult result = new SystemCommand().run(srvctl, "config", "db", "-db", dbUniqueName);
        if (result.getReturnCode() == 0) {
            String[] lines;
            Builder builder = new Builder().dbUniqueName(dbUniqueName);
            String output = result.getOutput();
            block0: for (String line : lines = output.split("\n")) {
                for (LineType type : LineType.values()) {
                    Matcher matcher = type.getPattern().matcher(line);
                    if (!matcher.matches()) continue;
                    type.getConsumer().accept(builder, matcher);
                    continue block0;
                }
            }
            if (builder.nodes == null || builder.databaseInstances == null) {
                SystemCommand.ExecutionResult statusResult = new SystemCommand().run(srvctl, "status", "database", "-db", dbUniqueName);
                if (result.getReturnCode() == 0) {
                    output = statusResult.getOutput();
                    lines = output.split("\n");
                    List matchers = Arrays.stream(lines).map(instanceStatusPattern::matcher).filter(Matcher::matches).collect(Collectors.toList());
                    builder.nodes = new String[matchers.size()];
                    builder.databaseInstances = new String[matchers.size()];
                    for (int i = 0; i < matchers.size(); ++i) {
                        Matcher matcher = (Matcher)matchers.get(i);
                        builder.databaseInstances[i] = matcher.group(1);
                        builder.nodes[i] = matcher.group(2);
                    }
                } else {
                    String error = String.format("Failed to run %s: %s", srvctl + " status database -db " + dbUniqueName, result.getOutput());
                    RCVCommandBase.getLogger().log(Level.FINE, error);
                }
            }
            FullDatabaseConfig config = builder.build();
            dbConfigMap.putIfAbsent(dbUniqueName, config);
            return Optional.of(config);
        }
        String error = String.format("Failed to run %s: %s", srvctl + " config db -db " + dbUniqueName, result.getOutput());
        RCVCommandBase.getLogger().log(Level.FINE, error);
        return Optional.empty();
    }

    private static class Builder {
        private String dbUniqueName;
        private String databaseName;
        private String oracleHome;
        private String oracleUser;
        private String spFile;
        private String passwordFile;
        private String[] databaseInstances;
        private String[] nodes;
        private String role;

        private Builder() {
        }

        public Builder dbUniqueName(String dbUniqueName) {
            this.dbUniqueName = dbUniqueName;
            return this;
        }

        public Builder databaseName(String dbName) {
            this.databaseName = dbName;
            return this;
        }

        public Builder oracleHome(String oracleHome) {
            this.oracleHome = oracleHome;
            return this;
        }

        public Builder oracleUser(String oracleUser) {
            this.oracleUser = oracleUser;
            return this;
        }

        public Builder spFile(String spFile) {
            this.spFile = spFile;
            return this;
        }

        public Builder passwordFile(String passwordFile) {
            this.passwordFile = passwordFile;
            return this;
        }

        public Builder databaseInstances(String[] instances) {
            this.databaseInstances = instances;
            return this;
        }

        public Builder nodes(String[] nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder role(String role) {
            this.role = role;
            return this;
        }

        public FullDatabaseConfig build() {
            return new FullDatabaseConfig(this);
        }
    }

    private static enum LineType {
        DB_NAME(databaseNamePattern, (builder, matcher) -> builder.databaseName(matcher.group(1))),
        ORACLE_HOME(oracleHomePattern, (builder, matcher) -> builder.oracleHome(matcher.group(1))),
        ORACLE_USER(oracleUserPattern, (builder, matcher) -> builder.oracleUser(matcher.group(1))),
        SP_FILE(SpFilePattern, (builder, matcher) -> builder.spFile(matcher.group(1))),
        PASSWORD_FILE(passwordFilePattern, (builder, matcher) -> builder.passwordFile(matcher.group(1))),
        ROLE(rolePattern, (builder, matcher) -> builder.role(matcher.group(1))),
        DB_INSTANCES(databaseInstancesPattern, (builder, matcher) -> builder.databaseInstances(matcher.group(1).trim().split(","))),
        SINGLE_DB_INSTANCE(singleDatabaseInstancePattern, (builder, matcher) -> builder.databaseInstances(matcher.group(1).trim().split(","))),
        NODES(nodesPattern, (builder, matcher) -> builder.nodes(matcher.group(1).trim().split(",")));

        private Pattern pattern;
        private BiConsumer<Builder, Matcher> consumer;

        private LineType(Pattern pattern, BiConsumer<Builder, Matcher> consumer) {
            this.pattern = pattern;
            this.consumer = consumer;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public BiConsumer<Builder, Matcher> getConsumer() {
            return this.consumer;
        }
    }
}

