/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.commandengine;

import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineRequest;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.task.TaskInfo;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.Result;

public class GetActionRequest
extends FleetEngineRequest {
    private int sessionId;
    private int actionId;
    private static final String GET_ACTION = "call dbms_ra_cmd_engine.get_action(?, ?, ?, ?, ?, ?)";

    private GetActionRequest(Builder builder) {
        super(builder);
        String dbUniqueName = super.getDbUniqueName();
        this.getLogger().log(Level.FINE, "DbUniqueName: " + dbUniqueName.toUpperCase());
        this.getLogger().log(Level.FINE, "sessionId     : " + builder.sessionId);
        this.getLogger().log(Level.FINE, "ActionId    : " + builder.actionId);
        try {
            this.sessionId = builder.sessionId;
            this.actionId = builder.actionId;
            CallableStatement cs = super.getCallableStatement();
            cs.setInt("SESSION_ID", builder.sessionId);
            cs.setInt("ACTION_ID", builder.actionId);
            cs.registerOutParameter("ACTION_TYPE_OUT", 4);
            cs.registerOutParameter("CONTENT_SCRIPT_OUT", 2005);
            cs.registerOutParameter("STATUS_CODE_OUT", 4);
            cs.registerOutParameter("STATUS_MESG_OUT", 12);
        }
        catch (SQLException e) {
            throw Result.fengDatabaseSqlException(RcvMessages.format("FENG_GET_TASK_ERROR_MSG", new Object[0]), e);
        }
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public int getActionId() {
        return this.actionId;
    }

    public FleetEngineResponse<TaskInfo> execute() throws SQLException {
        String dbUniqueName = super.getDbUniqueName();
        CallableStatement cs = super.getCallableStatement();
        cs.execute();
        int statusCode = cs.getInt("STATUS_CODE_OUT");
        String statusMessage = cs.getString("STATUS_MESG_OUT");
        String scriptsDirectory = FleetAgentContext.get(dbUniqueName).getScriptsDirectory();
        String timeStamp = Utils.getTimeStamp();
        String scriptName = String.format("task_%d", this.actionId);
        String scriptPath = String.join((CharSequence)File.separator, scriptsDirectory, scriptName);
        TaskInfo taskInfo = new TaskInfo(this.actionId, cs.getInt("ACTION_TYPE_OUT"), dbUniqueName, cs.getClob("CONTENT_SCRIPT_OUT"), scriptPath);
        this.getLogger().log(Level.FINE, "StatusCode: " + statusCode);
        this.getLogger().log(Level.FINE, "StatusMesg: " + statusMessage);
        this.getLogger().log(Level.FINE, "ActionType: " + taskInfo.getType());
        return new FleetEngineResponse<TaskInfo>(statusCode, statusMessage, taskInfo);
    }

    public static class Builder
    extends FleetEngineRequest.Builder<Builder> {
        private int sessionId;
        private int actionId;

        public Builder(Connection conn, String dbUniqueName, int sessionId, int actionId, Logger logger) {
            super(conn, dbUniqueName, GetActionRequest.GET_ACTION, logger);
            this.sessionId = sessionId;
            this.actionId = actionId;
        }

        @Override
        public GetActionRequest build() {
            return new GetActionRequest(this);
        }

        public Builder logger(Logger logger) {
            super.setLogger(logger);
            return this;
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

