/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.logging;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class WorkflowLogger {
    private Logger quietLogger;
    private Logger loudLogger;
    private String logFile;
    private static Level logLevel = Level.FINEST;
    private static Handler consoleHandler = new ConsoleHandler();
    private static ConsoleHandler actionHandler = new ConsoleHandler();

    private WorkflowLogger(String logFile) {
        this.logFile = logFile;
    }

    public static WorkflowLogger getWorkflowLogger(String logFile) {
        WorkflowLogger wfLogger = new WorkflowLogger(logFile);
        wfLogger.loudLogger = WorkflowLogger.getLoudLogger(logFile);
        wfLogger.quietLogger = WorkflowLogger.getQuietLogger(logFile);
        return wfLogger;
    }

    private static Logger getLoudLogger(String logFile) {
        Logger logger = Logger.getLogger(logFile + ".loud");
        logger.setLevel(logLevel);
        logger.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new CustomFormatter());
        logger.addHandler(consoleHandler);
        try {
            FileHandler fileHandler = new FileHandler(logFile, true);
            fileHandler.setFormatter(new SimpleFormatter());
            logger.addHandler(fileHandler);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, String.format("Failed to create file handler %s: %s", logFile, e.getMessage()));
        }
        return logger;
    }

    private static Logger getQuietLogger(String logFile) {
        Logger logger = Logger.getLogger(logFile + ".quiet");
        logger.setLevel(logLevel);
        logger.setUseParentHandlers(false);
        try {
            FileHandler fileHandler = new FileHandler(logFile, true);
            fileHandler.setFormatter(new SimpleFormatter());
            logger.addHandler(fileHandler);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, String.format("Failed to create file handler %s: %s", logFile, e.getMessage()));
        }
        return logger;
    }

    public Logger getQuietLogger() {
        return this.quietLogger;
    }

    public Logger getLoudLogger() {
        return this.loudLogger;
    }

    public String getLogFile() {
        return this.logFile;
    }

    static {
        actionHandler.setLevel(Level.WARNING);
        actionHandler.setFormatter(new SimpleFormatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage() + "\n";
            }
        });
    }

    private static class CustomFormatter
    extends SimpleFormatter {
        private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        private CustomFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            String timestamp = dateFormat.format(new Date(record.getMillis()));
            return timestamp + ": " + record.getMessage() + "\n";
        }
    }
}

