/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check.onboarding;

import java.sql.Connection;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;

public class DatabaseVersionCheck
extends Check {
    private Connection conn;
    private String minimumVersion;
    public static final String ID = "db_version";

    public DatabaseVersionCheck(Connection conn, String minimumVersion) {
        super(conn, "Database Version Check", ID);
        this.conn = conn;
        this.minimumVersion = minimumVersion;
    }

    @Override
    public CheckResult run() {
        String version = DatabaseUtils.getDatabaseVersion(this.conn);
        int res = DatabaseUtils.compareDatabaseVersion(version, this.minimumVersion);
        if (res >= 0) {
            String successMessage = "Database version is at least " + this.minimumVersion;
            return new CheckResult(CheckResult.Status.PASS, successMessage);
        }
        String failureMessage = RcvMessages.format("CHECKS_DB_VERSION_MIN", version, this.minimumVersion);
        return new CheckResult(CheckResult.Status.FAIL, failureMessage);
    }
}

