/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check.health;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.Objects;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.ConnectString;
import oracle.dbtools.extension.rcv.models.RMANScript;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.DatabaseConfig;
import oracle.dbtools.extension.rcv.models.systemcommands.RMANCommand;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.utils.ScriptFactory;

public class RMANEncryptionSettingCheck
extends Check {
    public static final String ID = "rman_encryption_check";
    private Connection conn;

    public RMANEncryptionSettingCheck(Connection conn) {
        super(conn, "RMAN Encryption check", ID);
        this.conn = conn;
    }

    @Override
    public CheckResult run() {
        RMANScript script;
        String scriptsDirectory = String.join((CharSequence)File.separator, Objects.requireNonNull(RCVCommandBase.getAgentBaseDirectory()), "scripts");
        try {
            script = ScriptFactory.generateShowEncryptionRMANScript(scriptsDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Database db = RCVCommandBase.getDatabase(this.conn);
        String dbUniqueName = RCVCommandBase.getDbUniqueName(this.conn);
        String oracleHome = DatabaseConfig.getOracleHome(dbUniqueName);
        String oracleSid = db.getDatabaseMetadataCache().getOracleSid();
        ConnectString target = new ConnectString.Builder().privilege("sysbackup").build();
        RMANCommand rmanCommand = new RMANCommand.Builder(target, null, script).oracleHome(oracleHome).oracleSid(oracleSid).logger(this.getLogger().getLogger()).build();
        SystemCommand.ExecutionResult rmanResult = rmanCommand.executeWithRetryAsSys();
        String output = rmanResult.getOutput();
        if (output != null) {
            this.getLogger().log(Level.FINE, output);
        }
        if (rmanResult.getReturnCode() == 0) {
            String[] lines;
            for (String line : lines = rmanResult.getOutput().split("\n")) {
                if (!line.trim().toUpperCase().startsWith("CONFIGURE ENCRYPTION FOR DATABASE OFF;")) continue;
                return new CheckResult(CheckResult.Status.FAIL, "RMAN encryption is disabled.", "Please login to the target database using RMAN and run 'configure encryption for database on' to enable encryption.");
            }
        } else {
            return new CheckResult(CheckResult.Status.FAIL, "Failed to check RMAN settings. Please see log for more details.");
        }
        return new CheckResult(CheckResult.Status.PASS, "RMAN encryption is enabled.");
    }
}

