/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.modeler.vscode.xml;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlToJson {
    private static JsonBuilderFactory jsonFactory = null;

    private static JsonBuilderFactory getJsonBuilderFactory() {
        if (jsonFactory == null) {
            jsonFactory = Json.createBuilderFactory(null);
        }
        return jsonFactory;
    }

    public static String transformXmlToJson(String storagePath, String fileName) throws ParserConfigurationException, IOException, SAXException {
        String res = "";
        DocumentBuilderFactory factory = MDTransformer.documentBuilderFactory();
        DocumentBuilder db = MDTransformer.documentBuilder();
        File file = new File(storagePath, fileName);
        if (file.exists()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                Document doc = db.parse(new InputSource(reader));
                res = XmlToJson.processDocument(doc);
            }
        }
        return res;
    }

    private static String processDocument(Document doc) {
        JsonBuilderFactory fact = XmlToJson.getJsonBuilderFactory();
        Element rootElement = doc.getDocumentElement();
        String tag = rootElement.getTagName();
        JsonObjectBuilder root = fact.createObjectBuilder();
        root.add("objectType", tag);
        XmlToJson.processElement(rootElement, root, fact);
        JsonObject obj = root.build();
        return obj.toString();
    }

    private static void processAttributes(Element el, JsonObjectBuilder objectBuilder, JsonBuilderFactory fact) {
        NamedNodeMap nmap = el.getAttributes();
        int c = nmap.getLength();
        if (c > 0) {
            for (int k = 0; k < c; ++k) {
                Node node = nmap.item(k);
                String name = node.getNodeName();
                String value = node.getNodeValue();
                objectBuilder.add(name, StringUtilities.decodeAttributeValue(value));
            }
        }
    }

    private static ElementType getElementType(Element el) {
        NamedNodeMap map = el.getAttributes();
        if (map.getLength() == 1 && map.getNamedItem("value") != null) {
            return ElementType.valueAttribute;
        }
        if (map.getLength() > 0) {
            return ElementType.complex;
        }
        NodeList nodes = el.getChildNodes();
        if (XmlToJson.containsElement(nodes)) {
            return ElementType.complex;
        }
        Node node = el.getFirstChild();
        if (node != null) {
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                return ElementType.text;
            }
            return ElementType.complex;
        }
        return ElementType.noValue;
    }

    private static boolean containsElement(NodeList nodes) {
        int size = nodes.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    private static String getElementText(Element el) {
        StringBuilder res = new StringBuilder();
        NodeList nodes = el.getChildNodes();
        int size = nodes.getLength();
        for (int i = 0; i < size; ++i) {
            String value;
            Node textNode = nodes.item(i);
            if (textNode == null || (value = textNode.getTextContent()) == null) continue;
            if (!(value.isEmpty() || "\n\t".equals(value) || "\n".equals(value) || textNode.getNodeType() == 4)) {
                value = StringUtilities.decodeAttributeValue(value);
            }
            res.append(value);
        }
        String value = res.toString();
        if (value.isBlank()) {
            return "";
        }
        return value;
    }

    private static String getValueAttributeText(Element el) {
        NamedNodeMap nmap = el.getAttributes();
        Node node = nmap.getNamedItem("value");
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private static void processElement(Element el, JsonObjectBuilder objectBuilder, JsonBuilderFactory fact) {
        XmlToJson.processAttributes(el, objectBuilder, fact);
        HashMap<String, List<Element>> elementsMap = new HashMap<String, List<Element>>();
        ArrayList<String> tagOrder = new ArrayList<String>();
        XmlToJson.buildHelperStructures(el, elementsMap, tagOrder);
        int numberAttributes = el.getAttributes().getLength();
        if (tagOrder.isEmpty()) {
            String name = numberAttributes == 0 ? el.getNodeName() : "elementText";
            Node textNode = el.getFirstChild();
            if (textNode != null) {
                String value = XmlToJson.getElementText(el);
                objectBuilder.add(name, value);
            }
        } else {
            for (String tagName : tagOrder) {
                List list = (List)elementsMap.get(tagName);
                if (list.size() == 1) {
                    String value;
                    Element elem = (Element)list.get(0);
                    Object test = XmlToJson.getElementType(elem);
                    if (ElementType.noValue == test) {
                        objectBuilder.add(tagName, JsonValue.NULL);
                        continue;
                    }
                    if (ElementType.valueAttribute == test) {
                        value = XmlToJson.getValueAttributeText(elem);
                        if (value == null) {
                            objectBuilder.add(tagName, JsonValue.NULL);
                            continue;
                        }
                        objectBuilder.add(tagName, value);
                        continue;
                    }
                    if (ElementType.text == test) {
                        value = XmlToJson.getElementText(elem);
                        objectBuilder.add(tagName, value);
                        continue;
                    }
                    JsonObjectBuilder oBuilder = fact.createObjectBuilder();
                    XmlToJson.processElement(elem, oBuilder, fact);
                    JsonObject jo = oBuilder.build();
                    objectBuilder.add(tagName, (JsonValue)jo);
                    continue;
                }
                JsonArrayBuilder arb = fact.createArrayBuilder();
                for (Element elem : list) {
                    JsonObjectBuilder oBuilder = fact.createObjectBuilder();
                    XmlToJson.processElement(elem, oBuilder, fact);
                    JsonObject jo = oBuilder.build();
                    arb.add((JsonValue)jo);
                }
                JsonArray jArr = arb.build();
                objectBuilder.add(tagName, (JsonValue)jArr);
            }
        }
    }

    private static void buildHelperStructures(Element el, Map<String, List<Element>> elementsMap, List<String> tagOrder) {
        NodeList nodes = el.getChildNodes();
        int c = nodes.getLength();
        if (c > 0) {
            for (int k = 0; k < c; ++k) {
                Node node = nodes.item(k);
                if (node.getNodeType() != 1) continue;
                String name = node.getNodeName();
                List<Element> list = elementsMap.get(name);
                if (list == null) {
                    list = new ArrayList<Element>();
                    elementsMap.put(name, list);
                }
                list.add((Element)node);
                if (tagOrder.contains(name)) continue;
                tagOrder.add(name);
            }
        }
    }

    public static void main(String[] args) throws ParserConfigurationException, IOException, SAXException {
        String res = XmlToJson.transformXmlToJson("D:/tmp5", "types.xml");
        System.out.println(res);
    }

    static enum ElementType {
        valueAttribute,
        text,
        noValue,
        complex;

    }
}

