/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mle_js;

import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.crest.imports.metadata.RequestManager;
import oracle.dbtools.crest.imports.metadata.mle_js.DBMExtractionHandlerMLE_JS;
import oracle.dbtools.crest.imports.metadata.mle_js.MOHEnvironment;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.crest.model.scheduling.SchedulerProgram;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.mle_js.ExpNode;
import oracle.dbtools.mle_js.MLEConstants;
import oracle.dbtools.mle_js.MLEModule;
import oracle.dbtools.mle_js.ModuleMetadata;
import oracle.dbtools.mle_js.RequestProcessing;

public class MLEJS_Util
implements MLEConstants {
    public static final String ENVIRONMENT = "environment";
    public static final String ENV_DEPENDENCIES = "env_dependencies";
    public static final String MODULE_DEPENDENCIES = "module_dependencies";
    public static final String MODULE_TYPE = "module";
    public static final String MODULE_OWN_EXPORTS = "module_own_exports";
    public static final String MODULE_EXPORTS = "module_exports";
    public static final String CODE_DEPENDENCIES = "code_dependencies";
    public static final String CODE_IMPORTS = "code_imports";
    public static final String IMPORTED_MODULES = "imported_modules";
    public static final String CALL_SPECIFICATION = "call_specification";
    public static final String MODULE_DEPENDENCIES_LIST = "module_dependencies_list";
    public static final String USER_METADATA = "user_metadata";
    public static final String ALL_METADATA = "all_metadata";
    public static String CT_HTML = "text/html";
    public static String CT_CSS = "text/css";
    public static String CT_JSON = "application/json";
    public static String CT_JSON_UTF8 = "application/json;charset=UTF-8";
    public static String CT_TEXT = "text/plain;charset=UTF-8";

    public static void main(String[] args) throws SQLException {
    }

    public static void logError(Logger log, String message, Throwable exception) {
        if (log != null) {
            log.log(Level.SEVERE, "MLE_JS : " + message, exception);
        }
    }

    public static void getObjectDetails(Connection conn, RequestManager.ContentWrapper cw, Logger log) {
        String type = cw.getParameter("type");
        if (!MLEJS_Util.isSupportedType(type)) {
            MLEJS_Util.setObjectTypeNotSupported(cw, type);
            return;
        }
        String schema = MLEJS_Util.getParameter(cw, "schema");
        String name = MLEJS_Util.getParameter(cw, "name");
        if (type != null && !type.isEmpty() && (schema != null && !schema.isEmpty() && name != null && !name.isEmpty() || CODE_IMPORTS.equals(type))) {
            try {
                cw.setContentType(CT_JSON_UTF8);
                boolean added = RequestProcessing.addObjectDetails(conn, cw, type, schema, name, log);
                if (!added) {
                    cw.setStatus(404);
                    cw.setContentType(CT_TEXT);
                    cw.writeBytes("wrong data provided : schema=" + schema + " name=" + name);
                }
            }
            catch (Exception e) {
                cw.logError(" Scheduling getObjectDetails ", e);
            }
        }
    }

    public static String getParameter(RequestManager.ContentWrapper cw, String pname) {
        String schema = cw.getParameter(pname);
        if (schema != null) {
            schema = schema.startsWith("\"") && schema.endsWith("\"") ? schema.substring(1, schema.length() - 1) : (schema.startsWith("\\\"") && schema.endsWith("\\\"") ? schema.substring(2, schema.length() - 2) : schema.toUpperCase());
        }
        return schema;
    }

    public static String getSchema(RequestManager.ContentWrapper cw) {
        String schema = cw.getParameter("schema");
        if (schema != null) {
            schema = schema.startsWith("\"") && schema.endsWith("\"") ? schema.substring(1, schema.length() - 1) : (schema.startsWith("\\\"") && schema.endsWith("\\\"") ? schema.substring(2, schema.length() - 2) : schema.toUpperCase());
        }
        return schema;
    }

    public static String blobToString(Blob blob) {
        try {
            StringBuffer result = new StringBuffer();
            if (blob != null) {
                int read = 0;
                InputStreamReader reader = null;
                char[] buffer = new char[4096];
                try {
                    reader = new InputStreamReader(blob.getBinaryStream(), "UTF-8");
                    while ((read = reader.read(buffer)) != -1) {
                        result.append(buffer, 0, read);
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException("Unable to read layout data.", ex);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Unable to read layout data.", ex);
                }
                finally {
                    try {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            return result.toString();
        }
        catch (Exception e) {
            oracle.dbtools.crest.util.logging.Logger.error(e);
            return "";
        }
    }

    public static boolean isSupportedType(String type) {
        return type != null && MODULE_TYPE.equalsIgnoreCase(type) || ENVIRONMENT.equalsIgnoreCase(type) || "call_spec".equalsIgnoreCase(type) || ENV_DEPENDENCIES.equalsIgnoreCase(type) || MODULE_DEPENDENCIES.equalsIgnoreCase(type) || CODE_DEPENDENCIES.equalsIgnoreCase(type) || CALL_SPECIFICATION.equalsIgnoreCase(type) || CODE_IMPORTS.equalsIgnoreCase(type) || MODULE_OWN_EXPORTS.equalsIgnoreCase(type) || MODULE_DEPENDENCIES_LIST.equalsIgnoreCase(type) || USER_METADATA.equalsIgnoreCase(type) || IMPORTED_MODULES.equalsIgnoreCase(type) || ALL_METADATA.equalsIgnoreCase(type) || MODULE_EXPORTS.equalsIgnoreCase(type);
    }

    static String getUTF_8_String(String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    static InputStream getInputStream(String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        return is;
    }

    static String getDbmsSqlDef(String code, String version, String schema, String name, boolean update) {
        Object mname = name;
        if (schema != null) {
            mname = schema + "." + name;
        }
        String res = "create " + (update ? "or replace " : "");
        res = res + " MLE MODULE " + (String)mname;
        res = res + "\n language javascript ";
        if (version != null) {
            res = res + "\n version '" + version + "'";
        }
        res = res + "\nAS\n" + code;
        return res;
    }

    public static String getCodeImports(Connection conn, ModuleMetadata meta, RequestManager.ContentWrapper cw, String type, Logger log) {
        String env_name = "";
        String env_owner = "";
        try {
            DBMExtractionHandlerMLE_JS handler = new DBMExtractionHandlerMLE_JS(conn);
            MOHEnvironment moh = new MOHEnvironment(handler);
            env_owner = MLEJS_Util.getParameter(cw, "env_owner");
            env_name = MLEJS_Util.getParameter(cw, "env_name");
            String res = moh.getResolvedImports(conn, meta, env_owner, env_name, cw);
            return res;
        }
        catch (Exception e) {
            cw.logError("CodeDependencies - env_owner - " + env_owner + ", env_name - " + env_name, e);
            return "";
        }
    }

    public static void addOpenObjectChar(Writer sb, boolean first) {
        try {
            if (!first) {
                sb.write(44);
            }
            sb.write("{");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void addCloseChar(Writer sb) {
        try {
            sb.write("}");
        }
        catch (IOException e) {
            oracle.dbtools.crest.util.logging.Logger.error(e);
        }
    }

    public static String getHash(String source) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedhash = digest.digest(source.getBytes(StandardCharsets.UTF_8));
            return MLEJS_Util.bytesToHex(encodedhash).toUpperCase(Locale.ENGLISH);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static String getProperty(JsonObject jdoc, String key) {
        JsonValue val = (JsonValue)jdoc.get((Object)key);
        if (!JsonValue.NULL.equals((Object)val)) {
            return MLEJS_Util.getDecodedString(val);
        }
        return null;
    }

    public static String getDecodedString(JsonValue val) {
        if (val != null && val instanceof JsonString) {
            String value = MLEJS_Util.getString(val);
            if (value != null && !value.isEmpty()) {
                value = StringUtilities.decodeAttributeValueJSON(value);
            }
            return value;
        }
        if (!(val instanceof JsonObject) && val != null) {
            return MLEJS_Util.getString(val);
        }
        return null;
    }

    public static String getString(JsonValue value) {
        String res = "";
        res = value.toString();
        if (res.equals("\"\"")) {
            res = "";
        } else if (res.startsWith("\"") && res.endsWith("\"")) {
            res = res.substring(1, res.length() - 1);
        }
        return res;
    }

    static PropertiesObject createObject(String type) {
        PropertiesObject obj = null;
        if (type.equals(MODULE_TYPE)) {
            return new MLEModule();
        }
        if (type.equals("scheduler_program")) {
            return new SchedulerProgram();
        }
        return obj;
    }

    public static void setObjectTypeNotSupported(RequestManager.ContentWrapper cw, String type) {
        try {
            cw.setContentType(CT_TEXT);
            cw.setStatus(501);
            cw.writeBytes("object type " + (type != null ? type : "") + " is not supported");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static TypeDescriptor getTypeDescriptorL(Connection conn, RequestManager.ContentWrapper cw, Logger log) {
        String name;
        TypeDescriptor td = new TypeDescriptor();
        String type = cw.getParameter("type");
        if (!MLEJS_Util.isSupportedType(type)) {
            td.err = "object type " + (type != null ? type : "") + " is not supported";
        }
        td.type = type;
        String schema = cw.getParameter("schema");
        if (schema != null) {
            schema = schema.startsWith("\"") && schema.endsWith("\"") ? schema.substring(1, schema.length() - 1) : (schema.startsWith("\\\"") && schema.endsWith("\\\"") ? schema.substring(2, schema.length() - 2) : schema.toUpperCase());
            td.schema = schema;
        }
        if ((name = cw.getParameter("name")) != null) {
            name = name.startsWith("\"") && name.endsWith("\"") ? name.substring(1, name.length() - 1) : (name.startsWith("\\\"") && name.endsWith("\\\"") ? name.substring(2, name.length() - 2) : name.toUpperCase());
            td.name = name;
        }
        return td;
    }

    public static String getName(String string) {
        int secondQuote;
        if ((string = string.trim()).startsWith("\"")) {
            int secondQuote2 = string.indexOf("\"", 1);
            if (secondQuote2 > -1) {
                int secQuote;
                String temp = string.substring(1, secondQuote2);
                if (temp.startsWith("'") && (secQuote = temp.indexOf("'", 1)) > -1) {
                    return temp.substring(1, secQuote);
                }
                return temp;
            }
        } else if (string.startsWith("'") && (secondQuote = string.indexOf("'", 1)) > -1) {
            return string.substring(1, secondQuote);
        }
        return string;
    }

    public static String processObject(Connection conn, RequestManager.ContentWrapper cw, String type, boolean update, Logger log) {
        if (MODULE_TYPE.equals(type)) {
            return RequestProcessing.processModule(conn, cw, type, update, log);
        }
        if (USER_METADATA.equals(type)) {
            return RequestProcessing.updateUserMetadata(conn, cw, log);
        }
        if (CODE_DEPENDENCIES.equals(type) ? RequestProcessing.addCodeDependencies(conn, cw, type, log) : (CODE_IMPORTS.equalsIgnoreCase(type) ? RequestProcessing.addCodeImports(conn, cw, type, log) : IMPORTED_MODULES.equalsIgnoreCase(type) && RequestProcessing.addImportedModulesDeclaration(conn, cw, type, log))) {
            return "--ok";
        }
        return "--error";
    }

    public static void addTypesForOwnFunctionsFromJSDoc(List<ExpNode> exports) {
        for (ExpNode node : exports) {
            if (node.type == null || !"function".equals(node.type) && !"var_function".equals(node.type)) continue;
            MLEJS_Util.addTypesFromJSDoc(node);
        }
    }

    public static void addTypesFromJSDoc(ExpNode node) {
        ArrayList<ExpNode.Param> paramsList = new ArrayList<ExpNode.Param>();
        String comment = node.comment;
        if (comment != null && !comment.isBlank() && comment.startsWith("/**")) {
            int startIdx = 3;
            int endIdx = comment.indexOf("*/");
            String subComment = comment.substring(startIdx, endIdx).trim();
            ArrayList lines = new ArrayList();
            subComment.lines().forEach(line -> lines.add(line + System.lineSeparator()));
            for (String row : lines) {
                int returnsIdx = row.indexOf("@param");
                if (returnsIdx > -1) {
                    String[] parts;
                    String subRow = row.substring(returnsIdx + 6).trim();
                    ArrayList<String> splitList = new ArrayList<String>();
                    for (String part : parts = subRow.split(" ")) {
                        String t = part.trim();
                        if (t.isEmpty()) continue;
                        splitList.add(t);
                    }
                    if (splitList.size() > 0) {
                        ExpNode.Param p = new ExpNode.Param();
                        String first = ((String)splitList.get(0)).trim();
                        if (first.startsWith("{")) {
                            p.type = first.substring(1, first.indexOf("}"));
                            p.name = splitList.size() > 1 && splitList.get(1) != null ? ((String)splitList.get(1)).trim() : "";
                        } else {
                            p.name = first;
                        }
                        if (p.type.endsWith("=")) {
                            p.type = p.type.substring(0, p.type.length() - 1);
                            p.optional = "true";
                        } else if (p.name.startsWith("[")) {
                            p.name = p.name.substring(1, p.name.length() - 1);
                            p.optional = "true";
                            if (p.name.indexOf("=") > -1) {
                                String[] aList = p.name.split("=");
                                p.name = aList[0].trim();
                                p.defaultValue = aList[1].trim();
                            }
                        }
                        paramsList.add(p);
                    }
                }
                int ind = row.indexOf("@returns");
                int k = 8;
                if (ind < 0) {
                    ind = row.indexOf("@return");
                    k = 7;
                }
                if (ind <= -1) continue;
                String rest = row.substring(ind + k).trim();
                ind = rest.indexOf("{");
                int end = rest.indexOf("}");
                if (ind <= -1 || end <= -1 || end <= ind) continue;
                node.return_type = rest.substring(ind + 1, end).trim();
            }
        }
        boolean hasParams = false;
        if (node.params != null) {
            block2: for (ExpNode.Param p : node.params) {
                for (ExpNode.Param cp : paramsList) {
                    if (!p.name.equals(cp.name)) continue;
                    p.type = cp.type;
                    p.optional = cp.optional;
                    p.defaultValue = cp.defaultValue;
                    if (p.type == null || p.type.isEmpty()) continue block2;
                    hasParams = true;
                    continue block2;
                }
            }
        }
        if (hasParams && (node.return_type == null || node.return_type.isEmpty())) {
            node.return_type = "void";
        }
    }

    public static class TypeDescriptor {
        public String type;
        public String schema;
        public String name;
        public String err;
    }

    public static class Argument
    extends PropertiesObject
    implements MLEConstants {
        @Override
        public void initPropsList() {
            this.propsList.add("ARGUMENT_NAME");
            this.propsList.add("POSITION");
            this.propsList.add("DATA_TYPE");
        }

        @Override
        public void initDataTypes() {
            this.dataTypes.put("ARGUMENT_NAME", "VARCHAR2");
            this.dataTypes.put("POSITION", "NUMBER");
            this.dataTypes.put("DATA_TYPE", "VARCHAR2");
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public boolean isMinimumDefined() {
            return false;
        }
    }
}

