/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.reference;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.reference.AbstractReference;
import oracle.dbtools.crest.model.reference.Creator;
import oracle.dbtools.crest.model.reference.ReferenceSet;
import oracle.dbtools.crest.model.reference.SingleReferenceIterator;

public class ModelIDObjectReference
extends AbstractReference {
    public static final Object[] PROTOTYPE_ARRAY = new ModelIDObjectReference[0];
    private Design design;
    private ReferenceSet referenceSet;
    private ReferenceState state = new UninitializedReferenceState();
    private ReferenceState forwardState = null;
    private boolean keepAlive = false;

    protected ModelIDObjectReference(int refId, Design design, ReferenceSet referenceSet) {
        super(refId);
        this.referenceSet = referenceSet;
        this.design = design;
    }

    public Design getDesign() {
        return this.design;
    }

    protected RelationalDesign getPhysicalDesign() {
        return this.getDesign().getRelationalDesign();
    }

    public void setObject(ModelIDObject object) {
        this.getState().setObject(object);
    }

    @Override
    public DesignObject getObject() {
        DesignObject object;
        if (!this.getState().resolved() && this.getState().resolvable()) {
            this.getState().resolve();
        }
        if ((object = (DesignObject)this.getState().getObject()) != null && object.getDesignPart() != null) {
            this.setDesignPartId(object.getDesignPartId());
        }
        return object;
    }

    public void setObjectId(String id) {
        this.getState().setObjectId(id);
    }

    @Override
    public String getObjectId() {
        return this.getState().getObjectId();
    }

    public void setCreator(Creator creator) {
        this.getState().setCreator(creator);
    }

    public Creator getCreator() {
        return this.getState().getCreator();
    }

    public void loadOrCreateObject() {
        this.getState().resolve();
    }

    public boolean isResolved() {
        return this.getState().resolved();
    }

    public boolean isResolvable() {
        return this.getState().resolvable();
    }

    public void setDelegate(ModelIDObjectReference reference) {
        this.getState().setDelegate(reference);
    }

    private void setState(ReferenceState state) {
        this.state = state;
    }

    private ReferenceState getState() {
        return this.state;
    }

    public void setKeepAlive(boolean value) {
        this.keepAlive = value;
    }

    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public boolean isModelIDObjectReference() {
        return true;
    }

    @Override
    public ModelIDObjectReference asModelIDObjectReference() {
        return this;
    }

    protected void remapReference(String oldId) {
        if (this.referenceSet != null) {
            this.referenceSet.remapReference(this, oldId);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.appendToString(buffer);
        return buffer.toString();
    }

    protected void appendToString(StringBuffer buffer) {
        buffer.append("[REF ").append(this.getIdString());
        this.appendStringProps("\n     ", buffer);
        buffer.append("\n    ");
        this.getState().appendToString(buffer);
        buffer.append(']');
    }

    public void setNullified(boolean value) {
        if (value) {
            this.setProperty("target.nullified", VALUE_TRUE);
            this.forwardState = null;
            this.setObject(null);
            this.setState(new DisabledState());
        } else {
            this.setProperty("target.nullified", VALUE_FALSE);
            if (this.forwardState != null) {
                this.setState(this.forwardState);
            } else {
                this.setState(new UninitializedReferenceState());
            }
        }
    }

    public boolean isNullified() {
        return this.hasProperty("target.nullified", VALUE_TRUE);
    }

    @Override
    public Iterator getSingleTargetReferences() {
        return new SingleReferenceIterator(this);
    }

    private class UninitializedReferenceState
    extends ReferenceState {
        private UninitializedReferenceState() {
        }

        @Override
        protected boolean resolvable() {
            return false;
        }

        @Override
        protected void appendToString(StringBuffer buffer) {
            buffer.append(" unresolved");
        }
    }

    private abstract class ReferenceState {
        private ReferenceState() {
        }

        protected boolean resolved() {
            return false;
        }

        protected void resolve() {
        }

        protected boolean resolvable() {
            return true;
        }

        protected void setObject(ModelIDObject object) {
            if (object != null) {
                String oldId = ModelIDObjectReference.this.getState().getObjectId();
                ConcreteObjectReferenceState newState = new ConcreteObjectReferenceState();
                ((ReferenceState)newState).setObject(object);
                ModelIDObjectReference.this.setState(newState);
                ModelIDObjectReference.this.remapReference(oldId);
            } else {
                ModelIDObjectReference.this.setState(new UninitializedReferenceState());
            }
        }

        protected ModelIDObject getObject() {
            return null;
        }

        protected void setObjectId(String id) {
            if (id != null && !id.equals(ModelIDObjectReference.this.getState().getObjectId())) {
                String oldId = ModelIDObjectReference.this.getState().getObjectId();
                ConcreteIDReferenceState newState = new ConcreteIDReferenceState();
                ((ReferenceState)newState).setObjectId(id);
                ModelIDObjectReference.this.setState(newState);
                ModelIDObjectReference.this.remapReference(oldId);
            } else {
                ModelIDObjectReference.this.setState(new UninitializedReferenceState());
            }
        }

        protected String getObjectId() {
            return null;
        }

        protected void setCreator(Creator creator) {
            ForwardReferenceState newState = new ForwardReferenceState();
            ((ReferenceState)newState).setCreator(creator);
            ModelIDObjectReference.this.setState(newState);
            ModelIDObjectReference.this.forwardState = newState;
        }

        protected Creator getCreator() {
            return null;
        }

        protected void setDelegate(ModelIDObjectReference reference) {
            if (reference != null) {
                DelegateState delegateState = new DelegateState();
                ((ReferenceState)delegateState).setDelegate(reference);
                ModelIDObjectReference.this.setState(delegateState);
            }
        }

        protected abstract void appendToString(StringBuffer var1);
    }

    private class DisabledState
    extends ReferenceState {
        String message = "Reference is disabled";

        private DisabledState() {
        }

        @Override
        protected boolean resolved() {
            return false;
        }

        @Override
        protected void resolve() {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected boolean resolvable() {
            return false;
        }

        @Override
        protected void setObject(ModelIDObject object) {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected ModelIDObject getObject() {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected void setObjectId(String id) {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected String getObjectId() {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected void setCreator(Creator creator) {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected Creator getCreator() {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected void setDelegate(ModelIDObjectReference reference) {
            throw new IllegalStateException(this.message);
        }

        @Override
        protected void appendToString(StringBuffer buffer) {
            buffer.append("Disabled reference");
        }
    }

    private class DelegateState
    extends ReferenceState {
        private ModelIDObjectReference delegate = null;

        DelegateState() {
        }

        @Override
        protected boolean resolved() {
            return this.delegate.getState().resolved();
        }

        @Override
        protected void resolve() {
            this.delegate.getState().resolve();
        }

        @Override
        protected boolean resolvable() {
            return this.delegate != null && this.delegate.getState().resolvable();
        }

        @Override
        protected void setObject(ModelIDObject object) {
            this.delegate.getState().setObject(object);
        }

        @Override
        protected ModelIDObject getObject() {
            return this.delegate.getState().getObject();
        }

        @Override
        protected void setObjectId(String id) {
            this.delegate.getState().setObjectId(id);
        }

        @Override
        protected String getObjectId() {
            return this.delegate.getState().getObjectId();
        }

        @Override
        protected void setCreator(Creator creator) {
            this.delegate.getState().setCreator(creator);
        }

        @Override
        protected Creator getCreator() {
            return this.delegate.getCreator();
        }

        @Override
        protected void setDelegate(ModelIDObjectReference reference) {
            if (reference != null) {
                if (ModelIDObjectReference.this == reference) {
                    throw new IllegalArgumentException("A Reference can not delegate to itself.");
                }
                this.delegate = reference;
            } else {
                ModelIDObjectReference.this.setState(new UninitializedReferenceState());
            }
        }

        @Override
        protected void appendToString(StringBuffer buffer) {
            this.delegate.appendToString(buffer);
        }
    }

    private class ConcreteObjectReferenceState
    extends ReferenceState
    implements SetListener {
        private ModelIDObject modelIdObject;

        private ConcreteObjectReferenceState() {
        }

        @Override
        protected boolean resolved() {
            return true;
        }

        @Override
        protected void resolve() {
            DesignObject object = ModelIDObjectReference.this.getDesign().getDesignObject(this.getObjectId());
            if (object != null) {
                this.setObject(object);
            }
        }

        @Override
        protected void setObject(ModelIDObject object) {
            DesignObject designObject = null;
            if (this.modelIdObject instanceof DesignObject) {
                designObject = (DesignObject)this.modelIdObject;
            }
            if (designObject != null) {
                designObject.getDesignObjectSet().removeSetListener(this);
            }
            this.modelIdObject = object;
            if (this.modelIdObject != null) {
                if (this.modelIdObject instanceof DesignObject) {
                    designObject = (DesignObject)this.modelIdObject;
                }
                if (designObject != null) {
                    designObject.getDesignObjectSet().addSetListener(this);
                    this.copyInfoFromProperties();
                }
            } else {
                this.restoreForwardReferenceState();
            }
        }

        protected void restoreForwardReferenceState() {
            if (ModelIDObjectReference.this.forwardState != null) {
                ModelIDObjectReference.this.setState(ModelIDObjectReference.this.forwardState);
            } else {
                ModelIDObjectReference.this.setState(new UninitializedReferenceState());
            }
        }

        protected void copyInfoFromProperties() {
            if (ModelIDObjectReference.this.hasProperty("object.name")) {
                this.modelIdObject.setName(ModelIDObjectReference.this.getProperty("object.name"));
            }
            if (ModelIDObjectReference.this.hasProperty("object.comment.fromsource")) {
                this.modelIdObject.addReplaceLabeledComment("Source", ModelIDObjectReference.this.getProperty("object.comment.fromsource"));
            }
            if (ModelIDObjectReference.this.hasProperty("object.comment.engineering")) {
                this.modelIdObject.addReplaceLabeledComment("Engineering", ModelIDObjectReference.this.getProperty("object.comment.engineering"));
            }
            if (ModelIDObjectReference.this.hasProperty("object.generatorid")) {
                this.modelIdObject.setGeneratorID(ModelIDObjectReference.this.getProperty("object.generatorid"));
            }
        }

        @Override
        protected ModelIDObject getObject() {
            return this.modelIdObject;
        }

        @Override
        protected String getObjectId() {
            return this.modelIdObject.getObjectID();
        }

        @Override
        protected void appendToString(StringBuffer buffer) {
            buffer.append(" object: ").append(this.modelIdObject.getObjectID());
        }

        @Override
        public void changed(DesignObjectSet set, SetEvent event) {
            if (event.isRemoved() && event.getAffected() == this.modelIdObject) {
                DesignObject designObject = (DesignObject)this.modelIdObject;
                designObject.getDesignObjectSet().removeSetListener(this);
                designObject = null;
                this.restoreForwardReferenceState();
            }
        }
    }

    private class ConcreteIDReferenceState
    extends ReferenceState {
        private String objectId;

        private ConcreteIDReferenceState() {
        }

        @Override
        protected void setObjectId(String id) {
            this.objectId = id;
        }

        @Override
        protected String getObjectId() {
            return this.objectId;
        }

        @Override
        protected void resolve() {
            DesignObject object = ModelIDObjectReference.this.getDesign().getDesignObject(this.getObjectId());
            if (object != null) {
                this.setObject(object);
            }
        }

        @Override
        protected void appendToString(StringBuffer buffer) {
            buffer.append(" id: ").append(this.objectId);
        }
    }

    private class ForwardReferenceState
    extends ReferenceState {
        private Creator creator;

        private ForwardReferenceState() {
        }

        @Override
        protected void setCreator(Creator creator) {
            this.creator = creator;
        }

        @Override
        protected Creator getCreator() {
            return this.creator;
        }

        @Override
        protected boolean resolvable() {
            return this.creator != null && this.creator.canCreateNow();
        }

        @Override
        protected void resolve() {
            ModelIDObject object = (ModelIDObject)this.creator.create();
            this.setObject(object);
        }

        @Override
        protected void appendToString(StringBuffer buffer) {
            buffer.append(" fwd: ").append(this.creator);
        }
    }
}

