/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v11g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableProxyOraclev11g
extends TableProxyOraclev10g {
    public static final String BASIC = "BASIC";
    public static final String ADVANCED = "ADVANCED";
    public static final String OLTP = "OLTP";
    public static final String QUERY_LOW = "QUERY LOW";
    public static final String QUERY_HIGH = "QUERY HIGH";
    public static final String ARCHIVE_LOW = "ARCHIVE LOW";
    public static final String ARCHIVE_HIGH = "ARCHIVE HIGH";
    private static final String[] COMPRESSION_TYPE_CHOICES_11g = new String[]{"", "BASIC", "OLTP", "QUERY LOW", "QUERY HIGH", "ARCHIVE LOW", "ARCHIVE HIGH"};
    private static final String[] COMPRESSION_TYPE_CHOICES_12c = new String[]{"", "BASIC", "ADVANCED", "QUERY LOW", "QUERY HIGH", "ARCHIVE LOW", "ARCHIVE HIGH"};
    public static final String BINARY_XML = "BINARY XML";
    private static final String[] STORE_AS_CHOICES = new String[]{"BINARY XML", "CLOB", "OBJECT RELATIONAL"};
    public static final String SECUREFILE = "SECUREFILE";
    public static final String BASICFILE = "BASICFILE";
    private static final String[] LOB_STORAGE_CHOICES = new String[]{"", "SECUREFILE", "BASICFILE"};
    public static final String FILESYSTEM_LIKE_LOGGING = "FILESYSTEM_LIKE_LOGGING";
    private static final String[] XMLTYPE_LOGGING_CHOICES = new String[]{"", "YES", "NO", "FILESYSTEM_LIKE_LOGGING"};
    private static Set compressionTypeSet = null;
    private static Set storeAsSet = null;
    private static Set lobStorageTypeSet = null;
    private String compressionType = "";
    private String lobStorageType = "";
    private String allowAnySchema = "";
    private String allowNonSchema = "";

    public TableProxyOraclev11g(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        this.storeAs = BINARY_XML;
    }

    public TableProxyOraclev11g(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        this.storeAs = BINARY_XML;
    }

    public String getCompressionType() {
        if (this.compressionType.equals(OLTP) && this.getStorageDesign() instanceof StorageDesignOraclev12c) {
            return ADVANCED;
        }
        return this.compressionType;
    }

    public void setCompressionType(String compressionType) {
        if (!this.compressionType.equals(compressionType)) {
            if (ADVANCED.equals(compressionType)) {
                compressionType = OLTP;
            }
            if (this.checkCompressionType(compressionType)) {
                this.compressionType = compressionType;
                this.fireDataFieldChange();
            }
        }
    }

    private boolean checkCompressionType(String value) {
        if (compressionTypeSet == null) {
            compressionTypeSet = new HashSet();
            compressionTypeSet.addAll(Arrays.asList(TableProxyOraclev11g.getCompressionTypeValues()));
        }
        return compressionTypeSet.contains(value);
    }

    public static String[] getCompressionTypeValues() {
        return COMPRESSION_TYPE_CHOICES_11g;
    }

    public static String[] getCompressionTypeValues12c() {
        return COMPRESSION_TYPE_CHOICES_12c;
    }

    public static String[] getStoreAsValues11g() {
        return STORE_AS_CHOICES;
    }

    @Override
    protected boolean checkStoreAs(String value) {
        if (storeAsSet == null) {
            storeAsSet = new HashSet();
            storeAsSet.addAll(Arrays.asList(TableProxyOraclev11g.getStoreAsValues11g()));
        }
        return storeAsSet.contains(value);
    }

    public String getLobStorageType() {
        return this.lobStorageType;
    }

    public void setLobStorageType(String lobStorageType) {
        if (!this.lobStorageType.equals(lobStorageType) && this.checkLobStorageType(lobStorageType)) {
            this.lobStorageType = lobStorageType;
            this.fireDataFieldChange();
        }
    }

    private boolean checkLobStorageType(String value) {
        if (lobStorageTypeSet == null) {
            lobStorageTypeSet = new HashSet();
            lobStorageTypeSet.addAll(Arrays.asList(TableProxyOraclev11g.getLobStorageTypeValues()));
        }
        return lobStorageTypeSet.contains(value);
    }

    public static String[] getLobStorageTypeValues() {
        return LOB_STORAGE_CHOICES;
    }

    public String getAllowAnySchema() {
        return this.allowAnySchema;
    }

    public void setAllowAnySchema(String value) {
        if (!this.allowAnySchema.equals(value) && (ConstantsOracle.checkYesNo(value) || "".equals(value))) {
            this.allowAnySchema = value;
            this.fireDataFieldChange();
        }
    }

    public String getAllowNonSchema() {
        return this.allowNonSchema;
    }

    public void setAllowNonSchema(String value) {
        if (!this.allowNonSchema.equals(value) && (ConstantsOracle.checkYesNo(value) || "".equals(value))) {
            this.allowNonSchema = value;
            this.fireDataFieldChange();
        }
    }

    public static String[] getXmlTypeLoggingChoices11g() {
        return XMLTYPE_LOGGING_CHOICES;
    }

    @Override
    public void setXmlTypeLogging(String value) {
        super.setXmlTypeLogging(value);
        if (!this.xmlTypeLogging.equals(value) && FILESYSTEM_LIKE_LOGGING.equals(value)) {
            this.xmlTypeLogging = FILESYSTEM_LIKE_LOGGING;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof PartitionOraclev11g) {
            PartitionOraclev11g part = (PartitionOraclev11g)event.getAffected();
            if (part.getPartOfStorageTable() == this) {
                part.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(part);
                if (part.getPosition() == 0) {
                    part.removeObjectListener(this);
                    part.setPosition(this.listStorageTemplates.size());
                    part.addObjectListener(this);
                }
                return;
            }
            if (part.getSubPartitionOf() != null) {
                if (part.getPartitionList() == this.partitionList && this.partitionList != null && part.getPosition() == 0) {
                    int numberOfSubparts = 0;
                    AbstractStorageObjectOracle owningPartition = part.getSubPartitionOf();
                    if (owningPartition instanceof PartitionOraclev11g) {
                        PartitionOraclev11g owningRangePartition = (PartitionOraclev11g)owningPartition;
                        owningRangePartition.getRangeSubpartitions().add(part);
                        numberOfSubparts = owningRangePartition.getRangeSubpartitions().size();
                    } else if (owningPartition instanceof ListPartitionOraclev11g) {
                        ListPartitionOraclev11g owningListPartition = (ListPartitionOraclev11g)owningPartition;
                        owningListPartition.getRangeSubpartitions().add(part);
                        numberOfSubparts = owningListPartition.getRangeSubpartitions().size();
                    }
                    if (numberOfSubparts > 0) {
                        part.removeObjectListener(this);
                        part.setPosition(numberOfSubparts);
                        part.addObjectListener(this);
                    }
                }
                return;
            }
        }
        super.changed(object, event);
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        PartitionOraclev11g part;
        if (event.isType(0) && event.getAffected() instanceof PartitionOraclev11g && (part = (PartitionOraclev11g)event.getAffected()).getPartOfStorageTable() == this) {
            this.listStorageTemplates.remove(part);
            for (int i = 0; i < this.listStorageTemplates.size(); ++i) {
                ModelObject obj = this.listStorageTemplates.getElement(i);
                if (!(obj instanceof PartitionOracle)) continue;
                ((PartitionOracle)obj).setPosition(i + 1);
            }
            part.removeObjectListener(this);
            return;
        }
        super.changed(set, event);
    }

    @Override
    protected void addPartFromDesign(StorageObjectSet set) {
        for (PartitionOraclev11g rangePart : set) {
            if (rangePart.getPartitionList() == this.partitionList && this.partitionList != null && rangePart.getPartOfStorageTable() == null && rangePart.getSubPartitionOf() == null) {
                rangePart.addObjectListener(this);
                rangePart.setParent(this.partitions);
                this.partitions.add(rangePart);
                continue;
            }
            this.partitions.remove(rangePart);
        }
    }

    @Override
    protected void addRangePartFromDesignToTemplates(StorageObjectSet set) {
        for (PartitionOraclev11g rangePart : set) {
            if (rangePart.getPartOfStorageTable() == this) {
                rangePart.addObjectListener(this);
                rangePart.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(rangePart);
                continue;
            }
            this.listStorageTemplates.remove(rangePart);
        }
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = super.getPropertyWrapperList();
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.CompressionType"), this, "getCompressionType", "setCompressionType", String.class));
        }
        return this.propertyWrapperList;
    }
}

