/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;

public class ExternalTableOracle
extends AbstractStorageObjectOracle
implements OwnedObjectOracle {
    protected UserOracle owner;
    protected String accessDriverType = "ORACLE_LOADER";
    protected DirectoryOracle defaultDir;
    public static final String OPAQUE_FORMAT_SPEC = "Opaque Format Spec";
    public static final String CLOB_SUBQUERY = "CLOB Subquery";
    protected String accessParametersType = "Opaque Format Spec";
    private static final String[] accessParametersChoices = new String[]{"Opaque Format Spec", "CLOB Subquery", "NONE"};
    private static Set accessParametersSet = null;
    protected String opaqueFormatSpec = "";
    protected String clobSubquery = "";
    protected String location = "";
    protected String parallel = "NOPARALLEL";
    protected int parallelNum;
    protected String rejectLimit = "";
    protected StorageObjectCollection cols;
    public static final String TYPE_NAME = "ExtTbl";
    public static final String OLD_TYPE_NAME = "ExternalTable";

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return OLD_TYPE_NAME;
    }

    public static String[] getAccessParametersChoices() {
        return accessParametersChoices;
    }

    protected boolean checkAccessParameters(String value) {
        if (accessParametersSet == null) {
            accessParametersSet = new HashSet();
            accessParametersSet.addAll(Arrays.asList(ExternalTableOracle.getAccessParametersChoices()));
        }
        return accessParametersSet.contains(value);
    }

    public String getAccessDriverType() {
        return this.accessDriverType;
    }

    public void setAccessDriverType(String accessDriverType) {
        this.accessDriverType = accessDriverType;
        this.fireDataFieldChange();
    }

    public String getAccessParametersType() {
        return this.accessParametersType;
    }

    public void setAccessParametersType(String accessParametersType) {
        if (this.checkAccessParameters(accessParametersType)) {
            this.accessParametersType = accessParametersType;
            this.fireDataFieldChange();
        }
    }

    public DirectoryOracle getDefaultDir() {
        return this.defaultDir;
    }

    public void setDefaultDir(DirectoryOracle defaultDir) {
        this.defaultDir = defaultDir;
        this.fireDataFieldChange();
    }

    public UserOracle getOwner() {
        return this.owner;
    }

    public void setOwner(UserOracle owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null && !"".equals(this.getOwner().getLongName())) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getOwner() != null) {
            name = this.getOwner().getLongName() + "." + (String)name;
        }
        return !objectSet.containsLongName(this, (String)name);
    }

    public String getClobSubquery() {
        return this.clobSubquery;
    }

    public void setClobSubquery(String clobSubquery) {
        this.clobSubquery = clobSubquery;
        this.fireDataFieldChange();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
        this.fireDataFieldChange();
    }

    public String getOpaqueFormatSpec() {
        return this.opaqueFormatSpec;
    }

    public void setOpaqueFormatSpec(String opaqueFormatSpec) {
        this.opaqueFormatSpec = opaqueFormatSpec;
        this.fireDataFieldChange();
    }

    public String getParallel() {
        return this.parallel;
    }

    public void setParallel(String parallel) {
        if (ConstantsOracle.checkParallel(parallel)) {
            this.parallel = parallel;
            this.fireDataFieldChange();
        }
    }

    public int getParallelNum() {
        return this.parallelNum;
    }

    public void setParallelNum(int parallelNum) {
        this.parallelNum = parallelNum;
        this.fireDataFieldChange();
    }

    public String getRejectLimit() {
        return this.rejectLimit;
    }

    public void setRejectLimit(String rejectLimit) {
        if (rejectLimit != null) {
            if ((rejectLimit = rejectLimit.trim()).equals("")) {
                this.rejectLimit = "";
            } else if (rejectLimit.equalsIgnoreCase("UNLIMITED")) {
                this.rejectLimit = "UNLIMITED";
            } else {
                try {
                    Integer.parseInt(rejectLimit);
                    this.rejectLimit = rejectLimit;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.fireDataFieldChange();
        }
    }

    @Override
    public void clearNoneMergableStructure() {
        if (this.cols != null) {
            this.cols.removeAll();
        }
    }

    @Override
    public void setUser(UserOracle user) {
        this.setOwner(user);
    }

    @Override
    public UserOracle getUser() {
        return this.getOwner();
    }

    public StorageObjectCollection getColumns() {
        return this.cols;
    }
}

