/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.ProxyDesignObjectSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;

public class StructuredTypeProxySet
extends ProxyDesignObjectSet {
    public StructuredTypeProxySet(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected DesignObjectSet getPhysicalDesignObjectSet() {
        return this.getDesign().getDataTypesDesign().getStructuredTypeSet();
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject object) {
        return new StructuredTypeProxy((StructuredType)object, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String id, String longName) {
        return new StructuredTypeProxy(design, id, longName, this.getStorageDesign());
    }

    @Override
    public StructuredTypeProxy getByName(String name) {
        Iterator it = this.getElements().iterator();
        StructuredTypeProxy proxy = null;
        while (it.hasNext()) {
            proxy = (StructuredTypeProxy)it.next();
            if (!name.equalsIgnoreCase(proxy.getName())) continue;
            return proxy;
        }
        return null;
    }

    public StructuredTypeProxy getBySchemaAndName(String schema, String name) {
        Iterator it = this.getElements().iterator();
        StructuredTypeProxy proxy = null;
        while (it.hasNext()) {
            proxy = (StructuredTypeProxy)it.next();
            StorageObject sto = proxy.getSchemaOrUser();
            if (sto == null || !sto.getName().equalsIgnoreCase(schema) || !name.equalsIgnoreCase(proxy.getName())) continue;
            return proxy;
        }
        return null;
    }
}

