/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.TypeSubstitutionSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.ArcSet;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeSet;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.AttributeViewSet;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.EntityViewSet;
import oracle.dbtools.crest.model.design.logical.FKAttributeManager;
import oracle.dbtools.crest.model.design.logical.GlobalCandidateKeySet;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.InheritanceRelationSet;
import oracle.dbtools.crest.model.design.logical.LogTypeSubstitutionSet;
import oracle.dbtools.crest.model.design.logical.LogicalDesignEstimates;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.logical.RelationSet;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.logical.TVInheritanceRelation;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.logging.Logger;

public class LogicalDesign
extends DesignPart
implements ModelObjectSetListener {
    public static final String OBJECT_TYPE_NAME = "LogicalDesign";
    public static final String ENTITY_SET_NAME = Messages.getString("LogicalDesign.Entities");
    public static final String ATTRIBUTE_SET_NAME = Messages.getString("LogicalDesign.Attributes");
    public static final String RELATION_SET_NAME = Messages.getString("LogicalDesign.Relations");
    public static final String INHERITANCE_RELATION_SET_NAME = Messages.getString("LogicalDesign.Inheritances");
    public static final String ARC_SET_NAME = Messages.getString("LogicalDesign.Arcs");
    public static final String NOTE_SET_NAME = Messages.getString("LogicalDesign.Notes");
    public static final String IMAGE_SET_NAME = Messages.getString("LogicalDesign.Images");
    public static final String MEASUREMENT_SET_NAME = Messages.getString("LogicalDesign.Measurement");
    public static final String ATTRIBUTE_VIEW_SET_NAME = Messages.getString("LogicalDesign.AttributeViews");
    public static final String VIEW_SET_NAME = Messages.getString("LogicalDesign.Views");
    public static final String DIAGRAM_SET_NAME = "Diagrams";
    private EntitySet entitySet;
    private AttributeSet attributeSet;
    private RelationSet relationSet;
    private RelationSet inheritanceRelationSet;
    private ArcSet arcSet;
    private LogicalDatatypeSet logicalTypeSet;
    private NoteSet noteSet;
    private TypeSubstitutionSet typeSubstitutionSet;
    private AttributeViewSet attributeViewSet;
    private EntityViewSet viewSet;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;
    public static int MANY_TO_MANY = 0;
    public static int ONE_TO_MANY = 1;
    public static int ONE_TO_MANY_IDENTIFYING = 2;
    public static int ONE_TO_ONE = 3;
    public static int ONE_TO_ONE_IDENTIFYING = 4;
    private boolean subviewToNewDesign = false;
    private LogicalDesignEstimates logicalDesignEstimates = new LogicalDesignEstimates();
    private static final Logger LOGGER = new Logger(LogicalDesign.class);
    private String storagePath = null;

    @Override
    public String getName() {
        return "Logical";
    }

    @Override
    public String toString() {
        return Messages.getString("Design.LogicalModel");
    }

    public LogicalDatatypeSet getLogicalTypeSet() {
        if (this.logicalTypeSet == null) {
            this.logicalTypeSet = new LogicalDatatypeSet(this);
            this.logicalTypeSet.addSetListener(this);
            this.logicalTypeSet.createUnknownType();
        }
        return this.logicalTypeSet;
    }

    public EntitySet getEntitySet() {
        if (this.entitySet == null) {
            this.entitySet = new EntitySet(this);
            this.entitySet.setDesign(this.getDesign());
            this.entitySet.setName(ENTITY_SET_NAME);
            this.entitySet.setParent(this);
            this.entitySet.addSetListener(this);
            this.entitySet.getGlobalCandidateKeySet().setDesign(this.getDesign());
            this.entitySet.getGlobalCandidateKeySet().setParent(this);
        }
        return this.entitySet;
    }

    public AttributeSet getAttributeSet() {
        if (this.attributeSet == null) {
            this.attributeSet = new AttributeSet(this);
            this.attributeSet.setDesign(this.getDesign());
            this.attributeSet.setName(ATTRIBUTE_SET_NAME);
            this.attributeSet.setParent(this);
            this.attributeSet.addSetListener(this);
        }
        return this.attributeSet;
    }

    public RelationSet getRelationSet() {
        if (this.relationSet == null) {
            this.relationSet = new RelationSet(this);
            this.relationSet.setDesign(this.getDesign());
            this.relationSet.setName(RELATION_SET_NAME);
            this.relationSet.setParent(this);
            this.relationSet.addSetListener(this);
        }
        return this.relationSet;
    }

    public RelationSet getInheritanceRelationSet() {
        if (this.inheritanceRelationSet == null) {
            this.inheritanceRelationSet = new InheritanceRelationSet(this);
            this.inheritanceRelationSet.setDesign(this.getDesign());
            this.inheritanceRelationSet.setParent(this);
            this.inheritanceRelationSet.setName(INHERITANCE_RELATION_SET_NAME);
            this.inheritanceRelationSet.addSetListener(this);
        }
        return this.inheritanceRelationSet;
    }

    public GlobalCandidateKeySet getGlobalCandidateKeySet() {
        return this.getEntitySet().getGlobalCandidateKeySet();
    }

    public ArcSet getArcSet() {
        if (this.arcSet == null) {
            this.arcSet = new ArcSet(this);
            this.arcSet.setDesign(this.getDesign());
            this.arcSet.setName(ARC_SET_NAME);
            this.arcSet.setParent(this);
            this.arcSet.addSetListener(this);
        }
        return this.arcSet;
    }

    public NoteSet getNoteSet() {
        if (this.noteSet == null) {
            this.noteSet = new NoteSet(this);
            this.noteSet.setDesign(this.getDesign());
            this.noteSet.setName(NOTE_SET_NAME);
            this.noteSet.setParent(this);
            this.noteSet.addSetListener(this);
        }
        return this.noteSet;
    }

    public AttributeViewSet getAttributeViewSet() {
        if (this.attributeViewSet == null) {
            this.attributeViewSet = new AttributeViewSet(this);
            this.attributeViewSet.setDesign(this.getDesign());
            this.attributeViewSet.setName(ATTRIBUTE_VIEW_SET_NAME);
            this.attributeViewSet.setParent(this);
            this.attributeViewSet.addSetListener(this);
        }
        return this.attributeViewSet;
    }

    public EntityViewSet getEntityViewSet() {
        if (this.viewSet == null) {
            this.viewSet = new EntityViewSet(this);
            this.viewSet.setDesign(this.getDesign());
            this.viewSet.setParent(this);
            this.viewSet.addSetListener(this);
            this.viewSet.setName(VIEW_SET_NAME);
        }
        return this.viewSet;
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
    }

    public Entity createEntity() {
        return this.getEntitySet().createEntity(null);
    }

    public EntityView createEntityView() {
        return this.getEntityViewSet().createEntityView(null);
    }

    public Entity createEntity(String name) {
        Entity entity = this.getEntitySet().createEntity(null);
        entity.setName(name);
        return entity;
    }

    public EntityView createEntityView(String name) {
        EntityView view = this.getEntityViewSet().createEntityView(null);
        view.setName(name);
        return view;
    }

    public Arc createArc() {
        return this.getArcSet().createArc(null);
    }

    public Arc createArc(String name) {
        Arc arc = this.getArcSet().createArc(null);
        arc.setName(name);
        return arc;
    }

    public Arc recreateArc(String id) {
        return this.getArcSet().createArc(id);
    }

    public Entity recreateEntity(String id) {
        return this.getEntitySet().createEntity(id);
    }

    public EntityView recreateEntityView(String id) {
        return this.getEntityViewSet().createEntityView(id);
    }

    public Relation createRelation() {
        Relation relation = this.getRelationSet().createRelation(null);
        relation.setOptionalSource(this.getDesign().getSettings().isSourceOptional());
        relation.setOptionalTarget(this.getDesign().getSettings().isTargetOptional());
        return relation;
    }

    public Relation createRelation(int relationType) {
        Relation relation = this.getRelationSet().createRelation(null);
        relation.setOptionalSource(this.getDesign().getSettings().isSourceOptional());
        relation.setOptionalTarget(this.getDesign().getSettings().isTargetOptional());
        if (relationType == MANY_TO_MANY) {
            relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[0]);
            relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[0]);
        } else if (relationType == ONE_TO_MANY) {
            relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
            relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[0]);
        } else if (relationType == ONE_TO_MANY_IDENTIFYING) {
            relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
            relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[0]);
            relation.setIdentifying(true);
        } else if (relationType == ONE_TO_ONE) {
            relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
            relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[1]);
        } else if (relationType == ONE_TO_ONE_IDENTIFYING) {
            relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
            relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[1]);
            relation.setIdentifying(true);
        }
        return relation;
    }

    public InheritanceRelation createInheritanceRelation() {
        InheritanceRelation relation = (InheritanceRelation)this.getInheritanceRelationSet().createRelation(null);
        relation.setOptionalSource(this.getDesign().getSettings().isSourceOptional());
        relation.setOptionalTarget(this.getDesign().getSettings().isTargetOptional());
        return relation;
    }

    public InheritanceRelation createNewInheritanceRelation() {
        InheritanceRelation relation = ((InheritanceRelationSet)this.getInheritanceRelationSet()).createInheritanceRelation();
        return relation;
    }

    public Relation createRelation(String name) {
        Relation relation = this.getRelationSet().createRelation(null);
        relation.setName(name);
        relation.setOptionalSource(this.getDesign().getSettings().isSourceOptional());
        relation.setOptionalTarget(this.getDesign().getSettings().isTargetOptional());
        return relation;
    }

    @Override
    public Note createNote() {
        Note note = this.getNoteSet().createNote(null);
        return note;
    }

    public Note recreateNote(String id) {
        return this.getNoteSet().createNote(id);
    }

    public Relation recreateRelation(String id) {
        return this.getRelationSet().createRelation(id);
    }

    public InheritanceRelation recreateInheritanceRelation(String id) {
        return (InheritanceRelation)this.getInheritanceRelationSet().createRelation(id);
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList collection = new ArrayList();
        this.getEntitySet().addAllElementsTo(collection);
        this.getEntityViewSet().addAllElementsTo(collection);
        this.getRelationSet().addAllElementsTo(collection);
        this.getInheritanceRelationSet().addAllElementsTo(collection);
        this.getArcSet().addAllElementsTo(collection);
        this.getNoteSet().addAllElementsTo(collection);
        return collection;
    }

    public void clearAll() {
        this.getTypeSubstitutionSet().removeAll();
        this.getEntityViewSet().removeAll();
        this.getAttributeSet().removeAll();
        this.getRelationSet().removeAll();
        this.getInheritanceRelationSet().removeAll();
        this.getEntitySet().removeAll();
        this.getAttributeViewSet().removeAll();
        this.getArcSet().removeAll();
        this.getNoteSet().removeAll();
        this.setComment("");
        this.setNotes("");
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
        this.setCheckedOut(false);
        this.setCheckedOutByMe(false);
        this.setCheckedOutBy("");
    }

    @Override
    public void sortCollections() {
        this.getAttributeSet().sort();
        this.getRelationSet().sort();
        this.getInheritanceRelationSet().sort();
        this.getEntitySet().sort();
        this.getAttributeViewSet().sort();
        this.getEntityViewSet().sort();
        this.getGlobalCandidateKeySet().sortByLongName();
        this.getLogicalDesignSubviews().sort();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public Object getParent() {
        return this.getDesign();
    }

    @Override
    protected DesignPartView createDesignPartSubView(String name) {
        DPVLogicalSubView dpv = new DPVLogicalSubView(this);
        name = this.getNameVersion(this.subViews, name);
        dpv.setName(name);
        DesignPartViewPlaceHolder dpvPH = new DesignPartViewPlaceHolder((DesignPart)this, dpv);
        dpvPH.setParent(this.subViews);
        this.subViews.add(dpvPH);
        return dpv;
    }

    public SubViewObjectSet getLogicalDesignSubviews() {
        return this.subViews;
    }

    @Override
    public DesignPartView getMainView() {
        if (this.mainView == null) {
            this.mainView = new DPVLogical(this);
            this.mainView.setDPVId(this.getIDGenerator().createNewID());
        }
        return this.mainView;
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "LogDes";
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> list = new ArrayList<DesignObjectSet>();
        list.add(this.getEntitySet());
        list.add(this.getEntityViewSet());
        list.add(this.getRelationSet());
        list.add(this.getInheritanceRelationSet());
        list.add(this.getArcSet());
        return list;
    }

    public boolean isEmpty() {
        if (this.getEntitySet().size() != 0) {
            return false;
        }
        if (this.getEntityViewSet().size() != 0) {
            return false;
        }
        if (this.getAttributeSet().size() != 0) {
            return false;
        }
        if (this.getAttributeViewSet().size() != 0) {
            return false;
        }
        if (this.getRelationSet().size() != 0) {
            return false;
        }
        if (this.getInheritanceRelationSet().size() != 0) {
            return false;
        }
        return this.getNoteSet().size() == 0;
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
    }

    public TypeSubstitutionSet getTypeSubstitutionSet() {
        if (this.typeSubstitutionSet == null) {
            this.typeSubstitutionSet = new LogTypeSubstitutionSet(this);
            this.typeSubstitutionSet.setDesign(this.getDesign());
            this.typeSubstitutionSet.setName(Messages.getString("LogicalDesign.TypeSubstitutions"));
            this.typeSubstitutionSet.setParent(this);
            this.typeSubstitutionSet.addSetListener(this);
        }
        return this.typeSubstitutionSet;
    }

    public TypeSubstitution createTypeSubstitution() {
        return this.getTypeSubstitutionSet().createTypeSubstitution(null);
    }

    public TypeSubstitution createTypeSubstitution(String id) {
        return this.getTypeSubstitutionSet().createTypeSubstitution(id);
    }

    public void rearrangeEntities() {
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.count = 0;
        EntitySet entitySet = this.getEntitySet();
        if (entitySet.size() > 0) {
            Iterator it = entitySet.iterator();
            float square = (float)Math.sqrt(entitySet.size());
            long maxTablePerRow = (int)square;
            if (Math.sqrt(square * square) != (double)square) {
                ++maxTablePerRow;
            }
            ++maxTablePerRow;
            while (it.hasNext()) {
                Entity entity = (Entity)it.next();
                TopView topView = entity.getTopView();
                if (topView == null) continue;
                ++this.count;
                Dimension dim = this.getEntitySize(entity);
                this.width = dim.width;
                this.height = Math.max(dim.height, this.height);
                topView.setBounds(new Rectangle(new Point(this.left, this.top), dim));
                this.left = this.left + this.width + 50;
                if ((long)this.count != maxTablePerRow) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 150;
                this.height = 25;
            }
        }
    }

    private Dimension getEntitySize(Entity entity) {
        int w = 35;
        int h = 25;
        int colCount = 0;
        StructuredType st = null;
        if (entity.isBST() && entity.getTypeSubstitution() != null) {
            st = entity.getBasedOnStructuredType();
            if (st != null) {
                colCount = st.getElements().length;
            }
        } else {
            colCount = entity.getElements().length;
        }
        h += colCount * 14;
        if (entity.getKeys().length > 0 && !this.allKeysAreFK(entity.getKeys())) {
            h += 4;
            for (int i = 0; i < entity.getKeys().length; ++i) {
                if (entity.getKeys()[i].isFK()) continue;
                h += 14;
            }
        }
        int colLength = entity.getName().length() * 6;
        int dtLength = 1;
        for (int i = 0; i < colCount; ++i) {
            int dtl;
            int cl;
            DesignObject element;
            if (st != null) {
                element = st.getElements()[i];
                cl = element.getName().length() * 7;
                dtl = ((TypeElement)element).getDataType().length() * 7;
                colLength = Math.max(cl, colLength);
                dtLength = Math.max(dtl, dtLength);
                continue;
            }
            element = (ContainedObjectWithDomain)entity.getElement(i);
            cl = ((ContainedObject)element).getName().length() * 7;
            dtl = ((ContainedObjectWithDomain)element).getDataType().toString().length() * 7 + 20;
            colLength = Math.max(cl, colLength);
            dtLength = Math.max(dtl, dtLength);
        }
        if (colLength == 1) {
            colLength = entity.getName().length() * 7;
        }
        return new Dimension(w + colLength + dtLength, h);
    }

    private boolean allKeysAreFK(KeyObject[] keys) {
        boolean result = true;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].isFK()) continue;
            result = false;
            break;
        }
        return result;
    }

    public void rearrangeViews() {
        if (this.left > 20) {
            this.left = 20;
            this.top = this.top + this.height + 50;
        }
        this.width = 35;
        this.height = 25;
        EntityViewSet entityViewSet = this.getEntityViewSet();
        if (entityViewSet.size() > 0) {
            Iterator it = entityViewSet.iterator();
            float square = (float)Math.sqrt(entityViewSet.size());
            long maxTablePerRow = (int)square;
            if (Math.sqrt(square * square) != (double)square) {
                ++maxTablePerRow;
            }
            while (it.hasNext()) {
                EntityView view = (EntityView)it.next();
                TopView topView = view.getTopView();
                if (topView == null) continue;
                ++this.count;
                Dimension dim = this.getEntityViewSize(view);
                this.width = dim.width;
                this.height = Math.max(dim.height, this.height);
                topView.setBounds(new Rectangle(new Point(this.left, this.top), dim));
                this.left = this.left + this.width + 50;
                if ((long)this.count != maxTablePerRow) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 150;
            }
        }
    }

    private Dimension getEntityViewSize(EntityView view) {
        int w = 25;
        int h = 25;
        int colCount = 0;
        StructuredType st = null;
        if (view.isBST() && view.getTypeSubstitution() != null) {
            st = view.getBasedOnStructuredType();
            if (st != null) {
                colCount = st.getElements().length;
            }
        } else {
            colCount = view.getElements().length;
        }
        h += colCount * 14;
        int colLength = view.getName().length() * 6;
        int dtLength = 1;
        for (int i = 0; i < colCount; ++i) {
            if (st != null) {
                TypeElement element = st.getElements()[i];
                int cl = element.getName().length() * 7;
                int dtl = element.getDataType().length() * 7;
                colLength = Math.max(cl, colLength);
                dtLength = Math.max(dtl, dtLength);
                continue;
            }
            if (view.getElements()[i] instanceof AttributeView) {
                AttributeView element = (AttributeView)view.getElements()[i];
                String name = element.getAlias();
                if ("".equalsIgnoreCase(name)) {
                    name = element.getName();
                }
                int cl = name.length() * 7;
                int dtl = element.getDataTypeString().length() * 7 + 10;
                colLength = Math.max(cl, colLength);
                dtLength = Math.max(dtl, dtLength);
                continue;
            }
            int cl = view.getElements()[i].getName().length() * 7;
            colLength = Math.max(cl, colLength);
        }
        if (colLength > 250) {
            colLength = 250;
        }
        return new Dimension(w + colLength + dtLength, h);
    }

    public boolean canCreateDPSubview() {
        return true;
    }

    public void updateRelationViews() {
        Iterator it = this.getRelationSet().iterator();
        while (it.hasNext()) {
            Relation relation = (Relation)it.next();
            for (TVRelation tv : relation.getAllTVRelations()) {
                tv.resetEdgeParams(false);
            }
        }
    }

    public void updateRelationViews(DesignPartView dpv) {
        Iterator it = this.getRelationSet().iterator();
        while (it.hasNext()) {
            Relation relation = (Relation)it.next();
            TVRelation tv = (TVRelation)relation.getViewFor(dpv);
            if (tv == null) continue;
            tv.resetEdgeParams(false);
        }
    }

    public void updateInheritances(boolean boxInBox) {
        Iterator it = this.getInheritanceRelationSet().iterator();
        while (it.hasNext()) {
            InheritanceRelation relation = (InheritanceRelation)it.next();
            for (TVInheritanceRelation tv : relation.getAllTVRelations()) {
                if (boxInBox) {
                    tv.removeConnection();
                    tv.updateParents();
                    continue;
                }
                tv.addConnection();
            }
        }
    }

    public boolean canCreateArc(Object[] selectedObjects) {
        Entity entity;
        List relations;
        List entities = this.getSelectedEntities(selectedObjects);
        if (entities.size() == 1 && (relations = this.getSelectedRelations(selectedObjects, entity = (Entity)entities.get(0))).size() > 1) {
            for (Relation relation : relations) {
                if (!entity.inArc(relation)) continue;
                return false;
            }
            Relation rel = (Relation)relations.get(0);
            int ep = rel.getEndPointFor(entity);
            Boolean opt = rel.getOptional(ep);
            for (Relation relation : relations) {
                Boolean op = relation.getOptional(ep = relation.getEndPointFor(entity));
                if (opt.equals(op)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canRemoveFromArc(Object[] selectedObjects) {
        List arcs = this.getSelectedArcs(selectedObjects);
        if (arcs.size() == 1) {
            Arc arc = (Arc)arcs.get(0);
            List relations = this.getSelectedRelations(selectedObjects, arc.getEntity());
            for (Relation relation : relations) {
                if (!arc.containsRelation(relation)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canAddToArc(Object[] selectedObjects) {
        List arcs = this.getSelectedArcs(selectedObjects);
        if (arcs.size() == 1) {
            Arc arc = (Arc)arcs.get(0);
            List relations = this.getSelectedRelations(selectedObjects, arc.getEntity());
            for (Relation relation : relations) {
                if (arc.getEntity().inArc(relation)) continue;
                return true;
            }
        }
        return false;
    }

    private List getSelectedEntities(Object[] selectedObjects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < selectedObjects.length; ++i) {
            Object object = selectedObjects[i];
            if (!(object instanceof Entity)) continue;
            list.add(object);
        }
        return list;
    }

    private List getSelectedRelations(Object[] selectedObjects, Entity entity) {
        ArrayList<Relation> list = new ArrayList<Relation>();
        for (int i = 0; i < selectedObjects.length; ++i) {
            Relation relation;
            Object object = selectedObjects[i];
            if (!(object instanceof Relation) || (relation = (Relation)object).getSourceEntity() != entity && relation.getTargetEntity() != entity) continue;
            list.add(relation);
        }
        return list;
    }

    private List getSelectedArcs(Object[] selectedObjects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < selectedObjects.length; ++i) {
            Object object = selectedObjects[i];
            if (!(object instanceof Arc)) continue;
            list.add(object);
        }
        return list;
    }

    public Arc createArc(Object[] selectedObjects) {
        List entities = this.getSelectedEntities(selectedObjects);
        if (entities.size() == 1) {
            Entity entity = (Entity)entities.get(0);
            List relations = this.getSelectedRelations(selectedObjects, entity);
            Arc arc = this.createArc();
            entity.addArc(arc);
            for (Relation relation : relations) {
                arc.addRelation(relation);
            }
            arc.addToAllDPVs();
            return arc;
        }
        return null;
    }

    public void addToArc(Object[] selectedObjects) {
        List arcs = this.getSelectedArcs(selectedObjects);
        if (arcs.size() == 1) {
            Arc arc = (Arc)arcs.get(0);
            List relations = this.getSelectedRelations(selectedObjects, arc.getEntity());
            for (Relation relation : relations) {
                if (arc.getEntity().inArc(relation)) continue;
                arc.addRelation(relation);
            }
            arc.setDirty(true);
        }
    }

    public void removeFromArc(Object[] selectedObjects) {
        List arcs = this.getSelectedArcs(selectedObjects);
        if (arcs.size() == 1) {
            Arc arc = (Arc)arcs.get(0);
            List relations = this.getSelectedRelations(selectedObjects, arc.getEntity());
            for (Relation relation : relations) {
                if (!arc.containsRelation(relation)) continue;
                arc.removeRelation(relation);
            }
            arc.setDirty(true);
            if (arc.getRelations().size() <= 1) {
                arc.remove();
            }
        }
    }

    public void synchronizeFKAttributesName() {
        boolean keep = this.getDesign().getSettings().isKeepFKNamesSynchronized();
        if (keep) {
            for (CandidateKey key : this.getGlobalCandidateKeySet()) {
                ContainedObject[] attrs = key.getElements();
                for (int i = 0; i < attrs.length; ++i) {
                    Attribute attr = (Attribute)attrs[i];
                    if (attr.isFKAttribute()) continue;
                    attr.propagateNameToFKAttributes(attr.getName());
                }
            }
        }
    }

    public boolean isSubviewToNewDesign() {
        return this.subviewToNewDesign;
    }

    public void setSubviewToNewDesign(boolean subviewToNewDesign) {
        this.subviewToNewDesign = subviewToNewDesign;
    }

    protected List createTypeOrder() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Entity");
        list.add("Relation");
        list.add("Hierarchy relation");
        list.add("EntityView");
        list.add("Arc");
        list.add("Note");
        list.add("MainView");
        list.add("SubView");
        return list;
    }

    @Override
    public String getStoragePath() throws IOException {
        String designPath;
        if (this.storagePath == null && (designPath = this.getDesign().getStoragePath()) != null && !designPath.isEmpty()) {
            this.storagePath = new File(designPath, "logical").getCanonicalPath();
        }
        return this.storagePath;
    }

    @Override
    public String getStorageName() throws IOException {
        String designPath;
        if (this.storageName == null && (designPath = this.getDesign().getStoragePath()) != null && !designPath.isEmpty()) {
            this.storageName = new File(designPath, "logical" + File.separatorChar + this.getName() + ".xml").getCanonicalPath();
        }
        return this.storageName;
    }

    @Override
    public boolean setName(String name) {
        return true;
    }

    @Override
    public synchronized StorableObject createObject(String objectType, String objectID, String name) {
        DesignObject object = null;
        if ("Entity".equalsIgnoreCase(objectType)) {
            object = this.getEntitySet().createEntity(objectID);
        } else if ("EntityView".equalsIgnoreCase(objectType) || "View".equalsIgnoreCase(objectType)) {
            object = this.getEntityViewSet().createEntityView(objectID);
        } else if ("Relation".equalsIgnoreCase(objectType)) {
            object = this.recreateRelation(objectID);
        } else if ("Hierarchy relation".equalsIgnoreCase(objectType)) {
            object = this.recreateInheritanceRelation(objectID);
        } else if ("Arc".equalsIgnoreCase(objectType)) {
            object = this.getArcSet().createArc(objectID);
        } else if ("Note".equalsIgnoreCase(objectType)) {
            object = this.getNoteSet().createNote(objectID);
        }
        if (object != null && name != null && name.length() > 0) {
            object.setName(name);
        }
        return object;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("entity", "Entity");
            this.f2tMap.put("relation", "Relation");
            this.f2tMap.put("inheritance", "Hierarchy relation");
            this.f2tMap.put("view", "View");
            this.f2tMap.put("arc", "Arc");
            this.f2tMap.put("note", "Note");
        }
        return this.f2tMap;
    }

    public void updateParentChildEntities() {
        ArrayList<InheritanceHelper> list = new ArrayList<InheritanceHelper>();
        Iterator it = this.getInheritanceRelationSet().iterator();
        while (it.hasNext()) {
            InheritanceRelation relation = (InheritanceRelation)it.next();
            InheritanceHelper ih = new InheritanceHelper();
            ih.inh = relation;
            ih.source = relation.getSourceEntity();
            ih.target = relation.getTargetEntity();
            list.add(ih);
        }
        for (InheritanceHelper ih : list) {
            if (ih.processed) continue;
            if (ih.source != null && ih.target != null) {
                this.updateForParent(ih.source, list);
                if (ih.target.getHierarchicalParent() != ih.source) {
                    try {
                        ih.target.setHierarchicalParent(ih.source, ih.inh);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in reseting parent entities - inheritance " + ih.inh.getName(), e);
                    }
                }
            } else {
                ih.todelete = true;
            }
            ih.processed = true;
        }
        for (InheritanceHelper ih : list) {
            if (!ih.todelete) continue;
            ih.inh.remove();
        }
    }

    private void updateForParent(Entity entity, List definitions) {
        for (int i = 0; i < definitions.size(); ++i) {
            InheritanceHelper ih = (InheritanceHelper)definitions.get(i);
            if (ih.processed || ih.target != entity || ih.source == null) continue;
            if (ih.source != null && ih.target != null) {
                this.updateForParent(ih.source, definitions);
                if (ih.target.getHierarchicalParent() != ih.source) {
                    try {
                        ih.target.setHierarchicalParent(ih.source, ih.inh);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in reseting parent entities - inheritance " + ih.inh.getName(), e);
                    }
                }
            } else {
                ih.todelete = true;
            }
            ih.processed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAfterLoad() throws IOException {
        if (!this.getDesign().isOldRepositoryType()) {
            this.updateParentChildEntities();
            for (CandidateKey key : this.getGlobalCandidateKeySet()) {
                key.updateContainedObjects();
                key.updateElementsCollection();
            }
            boolean temp = FKAttributeManager.CAN_SYNCHRONIZE;
            try {
                FKAttributeManager.CAN_SYNCHRONIZE = true;
                Iterator it = this.getRelationSet().iterator();
                while (it.hasNext()) {
                    Relation rel = (Relation)it.next();
                    rel.getFKAttributeManager().reSync();
                }
            }
            catch (Exception rel) {
            }
            finally {
                FKAttributeManager.CAN_SYNCHRONIZE = temp;
            }
            for (CandidateKey key : this.getGlobalCandidateKeySet()) {
                key.updateContainedObjects();
                key.updateElementsCollection();
            }
        }
        this.setViewListeners();
        super.doAfterLoad();
    }

    private void setViewListeners() {
        Iterator it = this.getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView view = (EntityView)it.next();
            if (!view.isParsed()) continue;
            for (SQLNameHelper helper : view.getSQLNames()) {
                DesignObject desObj = this.getDesign().getDesignObject(helper.getID());
                if (desObj == null) continue;
                desObj.addObjectListener(view);
            }
        }
    }

    protected List getObjectWichAllowClassificationTypes() {
        ArrayList list = new ArrayList();
        this.getEntitySet().addAllElementsTo(list);
        return list;
    }

    public LogicalDesignEstimates getLogicalDesignEstimates() {
        return this.logicalDesignEstimates;
    }

    @Override
    public List getSearchableSets() {
        return null;
    }

    class InheritanceHelper {
        InheritanceRelation inh;
        Entity source;
        Entity target;
        boolean processed = false;
        boolean todelete = false;

        InheritanceHelper() {
        }
    }

    public class AttributePlaceHolder
    extends DesignObjectPlaceHolder {
        public AttributePlaceHolder(DesignObject object) {
            super(object);
        }

        @Override
        public String toString() {
            if (this.getDesignObject() instanceof Attribute && !((Attribute)this.getDesignObject()).isFKAttribute()) {
                return this.getDesignObject().getLongName();
            }
            return super.toString();
        }
    }
}

