/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateRenameTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBIndexOraclev11g;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;

public class CSSBCreateRenameTableOraclev11g
extends CSSBCreateRenameTableOraclev10g {
    private CSSBIndexOraclev11g cssbIndex = null;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        super.doAppend(oldbuffer, object, prettyPrint);
    }

    @Override
    protected boolean isVirtualColumn(CompareObjectSelection columnSelection) {
        return CSSBCreateRenameTableOraclev11g.checkIsVirtualColumn(columnSelection);
    }

    public static boolean checkIsVirtualColumn(CompareObjectSelection columnSelection) {
        if (Boolean.valueOf(columnSelection.getChoosedPropertyValue(PropertiesComparator.COMPUTED)).booleanValue()) {
            return CSSBCreateRenameTableOraclev11g.getColumnExpression(columnSelection).length() > 0;
        }
        return false;
    }

    private static String getColumnExpression(CompareObjectSelection columnSelection) {
        ColumnComparator comp = (ColumnComparator)columnSelection.getPropertiesComparator();
        ColumnProxyOraclev11g columnProxy = columnSelection.isSelected() ? (ColumnProxyOraclev11g)comp.getSourceColumnProxy() : (ColumnProxyOraclev11g)comp.getTargetColumnProxy();
        String columnExpression = columnProxy != null && columnProxy.isExpressionChanged() ? columnProxy.getColumnExpression() : columnSelection.getChoosedPropertyValue(PropertiesComparator.FORMULA_DESC);
        return columnExpression.trim();
    }

    @Override
    protected void appendDatatype(StringBuffer buffer, String datatype, CompareObjectSelection columnSelection, boolean prettyPrint) {
        if (datatype.equalsIgnoreCase("unknown") && Boolean.valueOf(columnSelection.getChoosedPropertyValue(PropertiesComparator.COMPUTED)).booleanValue()) {
            return;
        }
        super.appendDatatype(buffer, datatype, columnSelection, prettyPrint);
    }

    @Override
    protected void appendColumnOptions(StringBuffer buffer, Column column, ColumnProxyOraclev10g columnProxy, boolean prettyPrint, CompareObjectSelection obj, boolean merge) {
        if (this.isVirtualColumn(obj)) {
            this.appendVirtualColumnDefinition(buffer, obj);
            this.appendInvisible(buffer, columnProxy);
        } else {
            this.appendInvisible(buffer, columnProxy);
            this.appendWithDefaultDefinition(buffer, columnProxy, obj, merge);
        }
        this.appendEncrypt(buffer, (ColumnProxyOraclev11g)columnProxy, prettyPrint);
        String mandatory = obj.getChoosedPropertyValue(PropertiesComparator.MANDATORY);
        boolean nn = Boolean.valueOf(mandatory);
        if (nn) {
            ColumnComparator comp = (ColumnComparator)obj.getPropertiesComparator();
            ColumnProxy targetColumnProxy = comp.getTargetColumnProxy();
            if (!column.getNullsAllowed()) {
                this.appendNotNullDefinition(buffer, columnProxy, prettyPrint);
            } else if (targetColumnProxy != null) {
                this.appendNotNullDefinition(buffer, (ColumnProxyOraclev10g)targetColumnProxy, prettyPrint);
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTableOraclev11g.appendString(buffer, ' ');
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "NULL");
            }
        }
    }

    private void appendVirtualColumnDefinition(StringBuffer buffer, CompareObjectSelection columnSelection) {
        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "AS");
        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, CSSBCreateRenameTableOraclev11g.getColumnExpression(columnSelection));
        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "VIRTUAL");
    }

    @Override
    protected void appendRefPartitionFK(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        FKIndexAssociation fk;
        FKProxyOracle fkproxy;
        PartitionListOracle partitionList = tableProxy.getPartitionList();
        if (partitionList != null && partitionList.getPartitionType().equals("REFERENCE") && (fkproxy = ((PartitionListOraclev11g)partitionList).getRefConstraint()) != null && ((fk = fkproxy.getIndex().getFKAssociation()).getRemoteTable() != null || !fk.getReferredTableLongName().isEmpty())) {
            this.appendComma(buffer);
            CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            if (!fkproxy.getName().startsWith("SYS_")) {
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy));
            }
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "FOREIGN KEY");
            CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 0);
            String columnList = fkproxy.getColumns(this.storageDesign);
            if (columnList.length() > 0) {
                CSSBCreateRenameTableOraclev11g.appendString(buffer, columnList);
            }
            CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
            this.appendReferences(buffer, fkproxy);
            this.appendOnDelete(buffer, fkproxy, prettyPrint);
            this.appendConstraintState(buffer, fkproxy);
        }
    }

    private void appendReferences(StringBuffer buffer, FKProxyOracle fk) {
        CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, true, 1);
        FKContainer refTable = fk.getFKTable();
        if (refTable != null) {
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "REFERENCES");
            ModelIDObject refTableObject = this.storageDesign.getTableProxySet().getProxy(refTable.getObjectID());
            if (refTableObject == null) {
                refTableObject = refTable;
            }
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(refTableObject));
            boolean refStructType = false;
            if (refTable.isBST()) {
                ColumnProxy[] columnProxies = fk.getColumnProxies();
                for (int i = 0; i < columnProxies.length; ++i) {
                    Column column = columnProxies[i].getColumn();
                    if (!column.isReference() || column.getUse() != 3) continue;
                    refStructType = true;
                }
            }
            if (!refStructType) {
                CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, true, 1);
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, true, 0);
                CSSBCreateRenameTableOraclev11g.appendString(buffer, fk.getReferenceColumns(this.storageDesign));
                CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, true, 1);
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
            }
        } else {
            FKIndexAssociation fkIndexAssociation = fk.getIndex().getFKAssociation();
            String referredTableLongName = fkIndexAssociation.getReferredTableLongName();
            String referredColumnNames = fkIndexAssociation.getReferredColumnNames();
            if (!referredTableLongName.isEmpty() && !referredColumnNames.isEmpty()) {
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "REFERENCES");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, referredTableLongName);
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, referredColumnNames);
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendOnDelete(StringBuffer buffer, FKProxyOracle fk, boolean prettyPrint) {
        FKIndexAssociation fkass = ((Index)fk.getObject()).getFKAssociation();
        String onDelete = fkass.getDeleteRule();
        if (onDelete.equalsIgnoreCase("SET DEFAULT")) {
            onDelete = fkass.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        if (!onDelete.equalsIgnoreCase("RESTRICT") && !onDelete.equalsIgnoreCase("NO ACTION")) {
            CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, true, 1);
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "ON");
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "DELETE");
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, onDelete);
        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            // empty if block
        }
    }

    private void appendConstraintState(StringBuffer buffer, FKProxyOracle fk) {
        if (this.storageDesign.isOpen()) {
            CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, true, 1);
            if ("NO".equalsIgnoreCase(fk.getDeferrable())) {
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "NOT");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "DEFERRABLE");
            } else {
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(fk.getInitially())) {
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "DEFERRED");
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "IMMEDIATE");
                }
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("YES".equalsIgnoreCase(fk.getEnable())) {
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("YES".equalsIgnoreCase(fk.getValidate())) {
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"YES".equalsIgnoreCase(fk.getEnable())) {
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(fk.getValidate())) {
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(fk.getValidate())) {
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
            if (fk.getExceptionsTable() != null) {
                CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, true, 1);
                buffer.append("EXCEPTIONS INTO ").append(this.storageDesign.getFormatedLongNameDDL(fk.getExceptionsTable()));
            }
        }
    }

    @Override
    public void appendPartitionList(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        PartitionListOraclev11g partitionList = (PartitionListOraclev11g)tableProxy.getPartitionList();
        if (partitionList != null) {
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignOraclev11g)tableProxy.getStorageDesign();
            }
            String partitionType = partitionList.getPartitionType();
            String subpartitionType = partitionList.getSubpartitionType();
            CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            if ("RANGE".equalsIgnoreCase(partitionType)) {
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "RANGE");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
                String intervalExpression = partitionList.getIntervalExpression().trim();
                if (intervalExpression.length() > 0) {
                    CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "INTERVAL");
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, intervalExpression);
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
                    if (partitionList.getIntervalTablespaces().length() > 0) {
                        CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIntervalTablespaces()));
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                }
                this.appendSubPartitionDefinition(buffer, tableProxy, partitionList, prettyPrint);
                boolean composite = !subpartitionType.equalsIgnoreCase("");
                this.appendPartitions(buffer, partitionList, true, composite, prettyPrint);
            } else if (partitionType.startsWith("HASH")) {
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "HASH");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendSubPartitionDefinition(buffer, tableProxy, partitionList, prettyPrint);
                if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType)) {
                    CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "PARTITIONS");
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, partitionList.getHashPQuantity());
                    if (!"".equals(partitionList.getHashPTableSpaces())) {
                        CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getHashPTableSpaces()));
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                    if (!"".equals(partitionList.getIOTOverflowHashPTS())) {
                        CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "OVERFLOW");
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIOTOverflowHashPTS()));
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                } else {
                    this.appendHashPartitions(buffer, tableProxy, prettyPrint);
                }
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "LIST");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendSubPartitionDefinition(buffer, tableProxy, partitionList, prettyPrint);
                this.appendListPartitions(buffer, tableProxy, partitionList, prettyPrint);
            } else if ("REFERENCE".equalsIgnoreCase(partitionType)) {
                FKIndexAssociation fk;
                FKProxyOracle refConstraint = partitionList.getRefConstraint();
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "REFERENCE");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
                boolean validFK = false;
                if (!(refConstraint == null || (fk = refConstraint.getIndex().getFKAssociation()).getRemoteTable() == null && fk.getReferredTableLongName().isEmpty())) {
                    validFK = true;
                }
                if (validFK) {
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(refConstraint));
                }
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendPartitions(buffer, partitionList, false, false, prettyPrint);
            } else if ("SYSTEM".equalsIgnoreCase(partitionType)) {
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "SYSTEM");
                int systemPartitions = partitionList.getSystemPartitions();
                if (systemPartitions > 1) {
                    CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "PARTITIONS");
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, systemPartitions);
                } else {
                    this.appendPartitions(buffer, partitionList, false, false, prettyPrint);
                }
            }
        }
    }

    private void appendSubPartitionDefinition(StringBuffer buffer, TableProxyOraclev10g tableProxy, PartitionListOraclev11g partitionList, boolean prettyPrint) {
        String subpartitionType = partitionList.getSubpartitionType();
        if (subpartitionType.equalsIgnoreCase("HASH")) {
            CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "BY");
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "HASH");
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
            if (partitionList.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
                if (partitionList.getSubPartitionsQuantity() > 1 || !"".equals(partitionList.getSubPartitionsTableSpaces())) {
                    CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, partitionList.getSubPartitionsQuantity());
                    if (!"".equals(partitionList.getSubPartitionsTableSpaces())) {
                        CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getSubPartitionsTableSpaces()));
                        CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "1");
                }
            } else {
                this.appendHashSubPartitionTemplates(buffer, tableProxy, prettyPrint);
            }
        } else if (subpartitionType.equalsIgnoreCase("LIST")) {
            CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "BY");
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "LIST");
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
            this.appendListSubPartitionTemplates(buffer, tableProxy, prettyPrint);
        } else if (subpartitionType.equalsIgnoreCase("RANGE")) {
            CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "BY");
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "RANGE");
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
            this.appendRangeSubPartitionTemplates(buffer, tableProxy, prettyPrint);
        }
    }

    private void appendRangeSubPartitionTemplates(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        StorageObjectCollection templates = tableProxy.getListStorageTemplates();
        if (templates.size() > 0) {
            CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "TEMPLATE");
            CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < templates.size(); ++i) {
                PartitionOraclev11g temp = (PartitionOraclev11g)templates.getElement(i);
                if (i > 0) {
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!temp.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(temp));
                }
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "VALUES LESS THAN");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, temp.getValueList());
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, temp, prettyPrint);
            }
            CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
        }
    }

    @Override
    protected void appendSubPartitions(StringBuffer buffer, AbstractStorageObjectOracle partition, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        if (partitionList.getSubpartitionType().equalsIgnoreCase("HASH")) {
            StorageObjectCollection subpartitions = null;
            int subPartitionsQuantity = 0;
            String subPartitionsTableSpaceIDs = "";
            if (partition instanceof PartitionOraclev11g) {
                PartitionOraclev11g rangePartition = (PartitionOraclev11g)partition;
                subpartitions = rangePartition.getPartitions();
                subPartitionsQuantity = rangePartition.getSubPartitionsQuantity();
                subPartitionsTableSpaceIDs = rangePartition.getSubPartitionsTableSpaces();
            } else if (partition instanceof ListPartitionOraclev11g) {
                ListPartitionOraclev11g listPartition = (ListPartitionOraclev11g)partition;
                subpartitions = listPartition.getHashSubpartitions();
                subPartitionsQuantity = listPartition.getSubPartitionsQuantity();
                subPartitionsTableSpaceIDs = listPartition.getSubPartitionsTableSpaces();
            }
            if (!this.appendHashSubPartitions(buffer, subpartitions, partitionList, prettyPrint) && subPartitionsQuantity > 0) {
                CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, subPartitionsQuantity);
                if (!"".equalsIgnoreCase(subPartitionsTableSpaceIDs)) {
                    CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(subPartitionsTableSpaceIDs));
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
                }
            }
        } else if (partitionList.getSubpartitionType().equalsIgnoreCase("LIST")) {
            if (partition instanceof PartitionOraclev11g) {
                this.appendListSubPartitions(buffer, ((PartitionOraclev11g)partition).getListPartitions(), prettyPrint);
            } else if (partition instanceof ListPartitionOraclev11g) {
                this.appendListSubPartitions(buffer, ((ListPartitionOraclev11g)partition).getListSubpartitions(), prettyPrint);
            }
        } else if (partitionList.getSubpartitionType().equalsIgnoreCase("RANGE")) {
            if (partition instanceof PartitionOraclev11g) {
                this.appendRangeSubPartitions(buffer, ((PartitionOraclev11g)partition).getRangeSubpartitions(), prettyPrint);
            } else if (partition instanceof ListPartitionOraclev11g) {
                this.appendRangeSubPartitions(buffer, ((ListPartitionOraclev11g)partition).getRangeSubpartitions(), prettyPrint);
            }
        }
    }

    private void appendRangeSubPartitions(StringBuffer buffer, StorageObjectCollection subpartitions, boolean prettyPrint) {
        if (subpartitions.size() > 0) {
            Object[] subpartitionsList = subpartitions.toArray();
            Arrays.sort(subpartitionsList, new PositionComparator());
            ArrayList<Object> sortedList = new ArrayList<Object>();
            for (int i = 0; i < subpartitionsList.length; ++i) {
                sortedList.add(subpartitionsList[i]);
            }
            Iterator rangeSubpartitions = sortedList.iterator();
            boolean firstPart = true;
            CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
            while (rangeSubpartitions.hasNext()) {
                PartitionOraclev11g rangeSubpartition = (PartitionOraclev11g)rangeSubpartitions.next();
                if (!firstPart) {
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ',');
                } else {
                    firstPart = false;
                }
                CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!rangeSubpartition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(rangeSubpartition));
                }
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, "VALUES LESS THAN");
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, rangeSubpartition.getValueList());
                CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, rangeSubpartition, prettyPrint);
            }
            CSSBCreateRenameTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTableOraclev11g.appendStringWithSpace(buffer, ')');
        }
    }

    @Override
    protected CSSBIndexOraclev11g getCSSBIndex() {
        if (this.cssbIndex == null) {
            this.cssbIndex = new CSSBIndexOraclev11g();
            this.cssbIndex.setStorageDesign((StorageDesignOraclev11g)this.storageDesign);
        }
        return this.cssbIndex;
    }

    static class PositionComparator
    implements Comparator {
        PositionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionOracle)one).getPosition() > ((PartitionOracle)two).getPosition()) {
                return 1;
            }
            if (((PartitionOracle)one).getPosition() < ((PartitionOracle)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

