/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;

public class CWDIndexComparator
extends PropertiesComparator {
    private Index sourceIndex;
    private Index targetIndex;
    private Map objectsMap;
    private CompareCWDDesigns selectionObject;

    public CWDIndexComparator(Index index, Index key, Map objectsMap) {
        super(index, key);
        this.sourceIndex = index;
        this.targetIndex = key;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        PropertyHolder ph = new PropertyHolder(INDEX_STATUS);
        ph.setLeftValue(this.sourceIndex != null ? this.sourceIndex.getIndexState() : "");
        ph.setRightValue(this.targetIndex != null ? this.targetIndex.getIndexState() : "");
        if (this.isExcludedFromComparison(INDEX_STATUS)) {
            ph.setExcluded(true);
        } else if (this.targetIndex != null && this.sourceIndex != null && !this.targetIndex.getIndexState().equals(this.sourceIndex.getIndexState())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(COLUMNS);
        ph.setLeftValue(this.sourceIndex != null ? this.getElementsToString(this.sourceIndex) : "");
        ph.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
        if (this.isExcludedFromComparison(COLUMNS)) {
            ph.setExcluded(true);
        } else if (this.targetIndex != null && this.sourceIndex != null && !MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap, false)) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setEditable(false);
        }
        this.propertiesList.add(ph);
    }

    private String getElementsToString(Index keyObject) {
        StringBuffer sb = new StringBuffer();
        Iterator it = keyObject.getElementsCollection().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Column co = (Column)it.next();
            if (keyObject.isPK() || keyObject.isUnique()) {
                if (first) {
                    sb.append(co.getName());
                    first = false;
                    continue;
                }
                sb.append("; ").append(co.getName());
                continue;
            }
            if (first) {
                sb.append(co.getName()).append(" ").append(keyObject.getColumnSortOrder(co));
                first = false;
                continue;
            }
            sb.append("; ").append(co.getName()).append(" ").append(keyObject.getColumnSortOrder(co));
        }
        return sb.toString();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromIndexToKey();
    }

    private void copyPropertiesFromIndexToKey() {
        if (this.targetIndex != null && this.sourceIndex != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(INDEX_STATUS)) {
                    this.targetIndex.setIndexState(this.sourceIndex.getIndexState());
                    continue;
                }
                if (!ph.getName().equals(COLUMNS)) continue;
                MergingModels.synchronizeColumnsFromIndexToKey(this.sourceIndex, this.targetIndex);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceIndex != null ? this.sourceIndex.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.targetIndex != null ? this.targetIndex.getLongName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceIndex == null) {
            return true;
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceIndex == null && this.targetIndex != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    public void presetColumnsOrder() {
        EngPropertyHolder ph = this.getPropertyHolderByName(COLUMNS);
        if (ph != null) {
            if (this.getLeftSelectionObject() != null) {
                ph.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
                if (this.sourceIndex != null) {
                    CompareCWDDesigns[] nodes = this.getColumnNodes(this.sourceIndex, this.getTableNode());
                    ph.setLeftValue(this.getElementsToString(this.sourceIndex, nodes));
                } else {
                    ph.setLeftValue("");
                }
                if (this.targetIndex != null && this.sourceIndex != null) {
                    if (!MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap, false)) {
                        ph.setModified(true);
                        ph.setSelected(true);
                    } else {
                        ph.setModified(false);
                        ph.setSelected(false);
                    }
                    ph.setEditable(false);
                }
            } else {
                ph.setLeftValue(this.sourceIndex != null ? this.getElementsToString(this.sourceIndex) : "");
                ph.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
                if (this.targetIndex != null && this.sourceIndex != null && !MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap, false)) {
                    ph.setModified(true);
                    ph.setSelected(true);
                    ph.setEditable(false);
                }
            }
        }
    }

    private CompareCWDDesigns[] getColumnNodes(Index index, CompareCWDDesigns tableNode) {
        ArrayList<CompareCWDDesigns> templist = new ArrayList<CompareCWDDesigns>();
        CompareCWDDesigns columns = (CompareCWDDesigns)tableNode.getChild(0);
        int nod_number = columns.getNumberOfChildren();
        for (int i = 0; i < nod_number; ++i) {
            CompareCWDDesigns cnode = (CompareCWDDesigns)columns.getChild(i);
            if (cnode.getStatus() == 3 || (!cnode.isSelected() || cnode.getStatus() != 2) && cnode.getStatus() == 2) continue;
            templist.add(cnode);
        }
        ArrayList<CompareCWDDesigns> list = new ArrayList<CompareCWDDesigns>();
        ContainedObject[] cos = index.getElements();
        for (int i = 0; i < cos.length; ++i) {
            CompareCWDDesigns node = this.getNode(templist, cos[i]);
            if (node == null) continue;
            list.add(node);
        }
        return list.toArray(new CompareCWDDesigns[0]);
    }

    private CompareCWDDesigns getNode(List list, ModelIDObject tofind) {
        for (CompareCWDDesigns node : list) {
            if (node.getObject() != tofind) continue;
            return node;
        }
        return null;
    }

    private String getElementsToString(Index keyObject, CompareCWDDesigns[] nodes) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < nodes.length; ++i) {
            ContainedObject co = (ContainedObject)nodes[i].getObject();
            if (keyObject.isPK() || keyObject.isUnique()) {
                if (first) {
                    sb.append(co.getName());
                    first = false;
                    continue;
                }
                sb.append("; ").append(co.getName());
                continue;
            }
            if (first) {
                sb.append(co.getName()).append(" ").append(keyObject.getColumnSortOrder(co));
                first = false;
                continue;
            }
            sb.append("; ").append(co.getName()).append(" ").append(keyObject.getColumnSortOrder(co));
        }
        return sb.toString();
    }

    private CompareCWDDesigns getTableNode() {
        if (this.getLeftSelectionObject() != null) {
            return (CompareCWDDesigns)((CompareCWDDesigns)this.getLeftSelectionObject().getParent()).getParent();
        }
        return null;
    }

    public CompareCWDDesigns getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareCWDDesigns selectionObject) {
        this.selectionObject = selectionObject;
    }
}

