/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.oracle.StorageTemplateComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TableComparatorOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class TableComparator
extends PropertiesComparator {
    private final Table sourceTable;
    private final Table targetTable;
    private TableProxy sourceTableProxy;
    private TableProxy targetTableProxy;
    private boolean snapshotDropped = false;

    public TableComparator(Table table, Table entity, TableProxy sourceTableProxy, TableProxy targetTableProxy) {
        this(table, entity, sourceTableProxy, targetTableProxy, false);
    }

    public TableComparator(Table table, Table entity, TableProxy sourceTableProxy, TableProxy targetTableProxy, boolean swapTarget) {
        super(table, entity);
        this.sourceTable = table;
        this.targetTable = entity;
        this.sourceTableProxy = sourceTableProxy;
        this.targetTableProxy = targetTableProxy;
        this.initPropertiesList();
        this.initDynamicProperties();
        this.initStoragePropertiesList();
        this.initPropertiesFilterList();
        this.initStoragePropertiesFilterList();
        this.initPhysicalPropertiesComparator();
        this.updateStoragePropertiesExcludeFlag();
    }

    private void initPhysicalPropertiesComparator() {
        TableProxy tableProxy;
        TableComparatorOracle physicalComparator = null;
        TableProxy tableProxy2 = tableProxy = this.sourceTableProxy != null ? this.sourceTableProxy : this.targetTableProxy;
        if (tableProxy instanceof TableProxyOracle) {
            physicalComparator = new TableComparatorOracle((TableProxyOracle)this.sourceTableProxy, (TableProxyOracle)this.targetTableProxy);
        }
        this.setPhysicalPropertiesComparator(physicalComparator);
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromTableToTable();
    }

    @Override
    protected void initPropertiesList() {
        PropertyHolder ph;
        this.initNameProperty();
        if (this.sourceTableProxy != null || this.targetTableProxy != null) {
            this.initSchemaProperty();
        }
        this.initCommentsAndNotes();
        if (!DDL_ONLY) {
            ph = new PropertyHolder(ABBREVIATION);
            ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getAbbreviation() : "");
            ph.setRightValue(this.targetTable != null ? this.targetTable.getAbbreviation() : "");
            if (this.isExcludedFromComparison(ABBREVIATION)) {
                ph.setExcluded(true);
            } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getAbbreviation().equals(this.targetTable.getAbbreviation())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(TEMP_TABLE_SCOPE);
            ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getScope() : "");
            ph.setRightValue(this.targetTable != null ? this.targetTable.getScope() : "");
            if (this.isExcludedFromComparison(TEMP_TABLE_SCOPE)) {
                ph.setExcluded(true);
            } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getScope().equals(this.targetTable.getScope())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(TABLE_TYPE);
            ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getDesign().getDesignLevelSettings().getClassificationTypeNameByID(this.sourceTable.getTypeID()) : "");
            ph.setRightValue(this.targetTable != null ? this.targetTable.getDesign().getDesignLevelSettings().getClassificationTypeNameByID(this.targetTable.getTypeID()) : "");
            if (this.isExcludedFromComparison(TABLE_TYPE)) {
                ph.setExcluded(true);
            } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getTypeID().equals(this.targetTable.getTypeID())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        ph = new PropertyHolder(STRUCTURED_TYPE);
        String sname = null;
        if (this.sourceTable != null && this.sourceTable.getBasedOnStructuredType() != null) {
            sname = this.sourceTable.getBasedOnStructuredType().getName();
            ph.setLeftValue(sname);
        } else {
            ph.setLeftValue("");
        }
        String tname = null;
        if (this.targetTable != null && this.targetTable.getBasedOnStructuredType() != null) {
            tname = this.targetTable.getBasedOnStructuredType().getName();
            ph.setRightValue(tname);
        } else {
            ph.setRightValue("");
        }
        if (this.isExcludedFromComparison(STRUCTURED_TYPE)) {
            ph.setExcluded(true);
        } else if (sname != null && tname != null) {
            if (!sname.equalsIgnoreCase(tname)) {
                ph.setModified(true);
                ph.setSelected(true);
            }
        } else if (sname != tname) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(ALLOW_TYPE_SUBSTITUTION);
        ph.setLeftValue(this.sourceTable != null ? String.valueOf(this.sourceTable.isAllowTypeSubstitution()) : "");
        ph.setRightValue(this.targetTable != null ? String.valueOf(this.targetTable.isAllowTypeSubstitution()) : "");
        if (this.isExcludedFromComparison(ALLOW_TYPE_SUBSTITUTION)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && this.sourceTable.isAllowTypeSubstitution() != this.targetTable.isAllowTypeSubstitution()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SPATIAL_TABLE);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.sourceTable != null ? String.valueOf(this.sourceTable.isSpatialTable()) : "");
        ph.setRightValue(this.targetTable != null ? String.valueOf(this.targetTable.isSpatialTable()) : "");
        if (this.isExcludedFromComparison(SPATIAL_TABLE)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && this.sourceTable.isSpatialTable() != this.targetTable.isSpatialTable()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        if (!DDL_ONLY) {
            ph = new PropertyHolder(MIN_VOLUMES);
            ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getMinVolumes() : "");
            ph.setRightValue(this.targetTable != null ? this.targetTable.getMinVolumes() : "");
            if (this.isExcludedFromComparison(MIN_VOLUMES)) {
                ph.setExcluded(true);
            } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getMinVolumes().equals(this.targetTable.getMinVolumes())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(EXPECTED_VOLUMES);
            ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getExpectedVolumes() : "");
            ph.setRightValue(this.targetTable != null ? this.targetTable.getExpectedVolumes() : "");
            if (this.isExcludedFromComparison(EXPECTED_VOLUMES)) {
                ph.setExcluded(true);
            } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getExpectedVolumes().equals(this.targetTable.getExpectedVolumes())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(MAX_VOLUMES);
            ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getMaxVolumes() : "");
            ph.setRightValue(this.targetTable != null ? this.targetTable.getMaxVolumes() : "");
            if (this.isExcludedFromComparison(MAX_VOLUMES)) {
                ph.setExcluded(true);
            } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getMaxVolumes().equals(this.targetTable.getMaxVolumes())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(GROWTH_PERCENT);
            ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getGrowthPercent() : "");
            ph.setRightValue(this.targetTable != null ? this.targetTable.getGrowthPercent() : "");
            if (this.isExcludedFromComparison(GROWTH_PERCENT)) {
                ph.setExcluded(true);
            } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getGrowthPercent().equals(this.targetTable.getGrowthPercent())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(GROWTH_TYPE);
            ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getGrowthType() : "");
            ph.setRightValue(this.targetTable != null ? this.targetTable.getGrowthType() : "");
            if (this.isExcludedFromComparison(GROWTH_TYPE)) {
                ph.setExcluded(true);
            } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getGrowthType().equals(this.targetTable.getGrowthType())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(NORMAL_FORM);
            ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getNormalForm() : "");
            ph.setRightValue(this.targetTable != null ? this.targetTable.getNormalForm() : "");
            if (this.isExcludedFromComparison(NORMAL_FORM)) {
                ph.setExcluded(true);
            } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getNormalForm().equals(this.targetTable.getNormalForm())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(ADEQUATELY_NORMALIZED);
            ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getAdequatelyNormalized() : "");
            ph.setRightValue(this.targetTable != null ? this.targetTable.getAdequatelyNormalized() : "");
            if (this.isExcludedFromComparison(ADEQUATELY_NORMALIZED)) {
                ph.setExcluded(true);
            } else if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getAdequatelyNormalized().equals(this.targetTable.getAdequatelyNormalized())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        ph = new PropertyHolder(COLUMNS_ORDER);
        ph.setLeftValue(this.sourceTable != null ? this.getElementsToString(this.sourceTable) : "");
        ph.setRightValue(this.targetTable != null ? this.getElementsToString(this.targetTable) : "");
        if (this.isExcludedFromComparison(COLUMNS_ORDER)) {
            ph.setExcluded(true);
        } else {
            if (!this.equalColumnsOrderNew(this.sourceTable, this.targetTable)) {
                ph.setSelected(true);
                ph.setModified(true);
            }
            if (!this.useColumnsOrder) {
                ph.setSelected(false);
            }
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(ON_PREBUILT_TABLE);
        ph.setLeftValue(this.sourceTable != null ? String.valueOf(this.sourceTable.isOnPrebuiltTable()) : "");
        ph.setRightValue(this.targetTable != null ? String.valueOf(this.targetTable.isOnPrebuiltTable()) : "");
        if (this.isExcludedFromComparison(ON_PREBUILT_TABLE)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(MATERIALIZED_QUERY_TABLE);
        ph.setLeftValue(this.sourceTable != null ? String.valueOf(this.sourceTable.isMaterializedQueryTable()) : "");
        ph.setRightValue(this.targetTable != null ? String.valueOf(this.targetTable.isMaterializedQueryTable()) : "");
        if (this.isExcludedFromComparison(MATERIALIZED_QUERY_TABLE)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(MATERIALIZED_QUERY);
        ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getUserDefinedSQL() : "");
        ph.setRightValue(this.targetTable != null ? this.targetTable.getUserDefinedSQL() : "");
        if (this.isExcludedFromComparison(MATERIALIZED_QUERY)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && ph.getLeftValue() != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(ROW_ARCHIVAL);
        ph.setLeftValue(this.sourceTable != null ? String.valueOf(this.sourceTable.isRowArchival()) : "");
        ph.setRightValue(this.targetTable != null ? String.valueOf(this.targetTable.isRowArchival()) : "");
        if (this.isExcludedFromComparison(ROW_ARCHIVAL)) {
            ph.setExcluded(true);
        } else if (this.sourceTable != null && this.targetTable != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        if (!DDL_ONLY) {
            ph = new PropertyHolder(INCLUDE_SCRIPTS);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.sourceTable != null ? String.valueOf(this.sourceTable.getShouldGenerateScript()) : "");
            ph.setRightValue(this.targetTable != null ? String.valueOf(this.targetTable.getShouldGenerateScript()) : "");
            if (this.isExcludedFromComparison(INCLUDE_SCRIPTS)) {
                ph.setExcluded(true);
            } else if (this.sourceTable != null && this.targetTable != null && this.sourceTable.getShouldGenerateScript() != this.targetTable.getShouldGenerateScript()) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(BEFORE_DROP_SCRIPT);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getBeforeDrop() : "");
            ph.setRightValue(this.targetTable != null ? this.targetTable.getBeforeDrop() : "");
            if (this.isExcludedFromComparison(BEFORE_DROP_SCRIPT)) {
                ph.setExcluded(true);
            } else if (this.sourceTable != null && this.targetTable != null && !this.isEqualClearLine(this.sourceTable.getBeforeDrop(), this.targetTable.getBeforeDrop())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(BEFORE_CREATE_SCRIPT);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getBeforeCreate() : "");
            ph.setRightValue(this.targetTable != null ? this.targetTable.getBeforeCreate() : "");
            if (this.isExcludedFromComparison(BEFORE_CREATE_SCRIPT)) {
                ph.setExcluded(true);
            } else if (this.sourceTable != null && this.targetTable != null && !this.isEqualClearLine(this.sourceTable.getBeforeCreate(), this.targetTable.getBeforeCreate())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(AFTER_CREATE_SCRIPT);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getAfterCreate() : "");
            ph.setRightValue(this.targetTable != null ? this.targetTable.getAfterCreate() : "");
            if (this.isExcludedFromComparison(AFTER_CREATE_SCRIPT)) {
                ph.setExcluded(true);
            } else if (this.sourceTable != null && this.targetTable != null && !this.isEqualClearLine(this.sourceTable.getAfterCreate(), this.targetTable.getAfterCreate())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(END_OF_SCRIPT);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.sourceTable != null ? this.sourceTable.getEndOfScript() : "");
            ph.setRightValue(this.targetTable != null ? this.targetTable.getEndOfScript() : "");
            if (this.isExcludedFromComparison(END_OF_SCRIPT)) {
                ph.setExcluded(true);
            } else if (this.sourceTable != null && this.targetTable != null && !this.isEqualClearLine(this.sourceTable.getEndOfScript(), this.targetTable.getEndOfScript())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
    }

    protected void initStoragePropertiesList() {
        SegmentOracle sourceSegment = null;
        SegmentOracle targetSegment = null;
        TableSpaceOracle sourceTableSpace = null;
        TableSpaceOracle targetTableSpace = null;
        Method templateSetter = null;
        Method tableSpaceSetter = null;
        boolean needTemplateComparator = false;
        if (this.sourceTableProxy instanceof TableProxyOracle) {
            sourceSegment = ((TableProxyOracle)this.sourceTableProxy).getSegment();
            sourceTableSpace = ((TableProxyOracle)this.sourceTableProxy).getTableSpace();
            try {
                templateSetter = TableProxyOracle.class.getMethod("setSegment", SegmentOracle.class);
                tableSpaceSetter = TableProxyOracle.class.getMethod("setTableSpace", TableSpaceOracle.class);
            }
            catch (Exception e) {
                Logger.error(e);
            }
            needTemplateComparator = true;
        }
        if (this.targetTableProxy instanceof TableProxyOracle) {
            targetSegment = ((TableProxyOracle)this.targetTableProxy).getSegment();
            targetTableSpace = ((TableProxyOracle)this.targetTableProxy).getTableSpace();
            needTemplateComparator = true;
        }
        if (needTemplateComparator) {
            this.templateComparator = new StorageTemplateComparator(this.sourceTableProxy, this.targetTableProxy, sourceSegment, targetSegment, sourceTableSpace, targetTableSpace, templateSetter, tableSpaceSetter);
            this.templateComparator.filterStoragePropertiesList(this.getStoragePropertiesFilterList());
        }
    }

    private void copyPropertiesFromTableToTable() {
        if (this.sourceTable != null && this.targetTable != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(TEMP_TABLE_SCOPE)) {
                    this.targetTable.setScope(this.sourceTable.getScope());
                    continue;
                }
                if (ph.getName().equals(ABBREVIATION)) {
                    this.targetTable.setAbbreviation(this.sourceTable.getAbbreviation());
                    continue;
                }
                if (ph.getName().equals(TABLE_TYPE)) {
                    this.targetTable.setTypeID(this.sourceTable.getTypeID());
                    continue;
                }
                if (ph.getName().equals(STRUCTURED_TYPE)) {
                    this.targetTable.setBasedOnStructuredType(this.sourceTable.getBasedOnStructuredType());
                    continue;
                }
                if (ph.getName().equals(SPATIAL_TABLE)) {
                    this.targetTable.setSpatialTable(this.sourceTable.isSpatialTable());
                    continue;
                }
                if (ph.getName().equals(MIN_VOLUMES)) {
                    this.targetTable.setMinVolumes(this.sourceTable.getMinVolumes());
                    continue;
                }
                if (ph.getName().equals(EXPECTED_VOLUMES)) {
                    this.targetTable.setExpectedVolumes(this.sourceTable.getExpectedVolumes());
                    continue;
                }
                if (ph.getName().equals(MAX_VOLUMES)) {
                    this.targetTable.setMaxVolumes(this.sourceTable.getMaxVolumes());
                    continue;
                }
                if (ph.getName().equals(GROWTH_PERCENT)) {
                    this.targetTable.setGrowthPercent(this.sourceTable.getGrowthPercent());
                    continue;
                }
                if (ph.getName().equals(GROWTH_TYPE)) {
                    this.targetTable.setGrowthType(this.sourceTable.getGrowthType());
                    continue;
                }
                if (ph.getName().equals(NORMAL_FORM)) {
                    this.targetTable.setNormalForm(this.sourceTable.getNormalForm());
                    continue;
                }
                if (ph.getName().equals(ADEQUATELY_NORMALIZED)) {
                    this.targetTable.setAdequatelyNormalized(this.sourceTable.getAdequatelyNormalized());
                    continue;
                }
                if (ph.getName().equals(SCHEMA)) {
                    if (this.sourceTableProxy != null && this.targetTableProxy != null && this.sourceTableProxy.getUserSchema() != null) {
                        this.targetTableProxy.setUserSchema(this.sourceTableProxy.getUserSchema().getName());
                    }
                    if (this.sourceTable == null || this.targetTable == null) continue;
                    this.setSchemaObject(this.sourceTable, this.targetTable);
                    continue;
                }
                if (ph.getName().equals(ON_PREBUILT_TABLE)) {
                    this.targetTable.setOnPrebuiltTable(this.sourceTable.isOnPrebuiltTable());
                    continue;
                }
                if (ph.getName().equals(MATERIALIZED_QUERY_TABLE)) {
                    this.targetTable.setMaterializedQueryTable(this.sourceTable.isMaterializedQueryTable());
                    continue;
                }
                if (ph.getName().equals(ROW_ARCHIVAL)) {
                    this.targetTable.setRowArchival(this.sourceTable.isRowArchival());
                    continue;
                }
                if (ph.getName().equals(MATERIALIZED_QUERY)) {
                    this.targetTable.setUserDefinedSQL(this.sourceTable.getUserDefinedSQL());
                    this.targetTable.setIncludeSchemaNameInQuery(this.sourceTable.includeSchemaNameInQuery());
                    this.targetTable.setSyntaxProvider(this.sourceTable.getSyntaxProvider());
                    this.targetTable.setIncorrectSQL(this.sourceTable.isIncorrectSQL());
                    this.targetTable.setParsed(false);
                    continue;
                }
                if (ph.getName().equals(INCLUDE_SCRIPTS)) {
                    this.targetTable.setShouldGenerateScript(this.sourceTable.getShouldGenerateScript());
                    continue;
                }
                if (ph.getName().equals(BEFORE_DROP_SCRIPT)) {
                    this.targetTable.setBeforeDrop(this.sourceTable.getBeforeDrop());
                    continue;
                }
                if (ph.getName().equals(BEFORE_CREATE_SCRIPT)) {
                    this.targetTable.setBeforeCreate(this.sourceTable.getBeforeCreate());
                    continue;
                }
                if (ph.getName().equals(AFTER_CREATE_SCRIPT)) {
                    this.targetTable.setAfterCreate(this.sourceTable.getAfterCreate());
                    continue;
                }
                if (ph.getName().equals(END_OF_SCRIPT)) {
                    this.targetTable.setEndOfScript(this.sourceTable.getEndOfScript());
                    continue;
                }
                if (!ph.getName().equals(ALLOW_TYPE_SUBSTITUTION)) continue;
                this.targetTable.setAllowTypeSubstitution(this.sourceTable.isAllowTypeSubstitution());
            }
        }
    }

    private void setSchemaObject(Table source, Table target) {
        SchemaObject s_sch = source.getSchemaObject();
        if (s_sch != null) {
            SchemaObject t_sch = (SchemaObject)((RelationalDesign)target.getDesignPart()).getSchemaObjectSet().getObjectByID(s_sch.getObjectID());
            if (t_sch == null) {
                t_sch = (SchemaObject)((RelationalDesign)target.getDesignPart()).getSchemaObjectSet().getByName(s_sch.getName());
            }
            if (t_sch != null) {
                target.setSchemaObject(t_sch);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceTable != null ? MessageFormat.format(Messages.getString("TableComparator.SourceTableL"), this.sourceTable.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.targetTable != null ? MessageFormat.format(Messages.getString("TableComparator.TargetTable"), this.targetTable.getName()) : "";
    }

    private String getElementsToString(Table table) {
        StringBuffer sb = new StringBuffer();
        Iterator<ContainedObject> it = Arrays.asList(table.getElements()).iterator();
        boolean first = true;
        while (it.hasNext()) {
            ContainedObject co = it.next();
            if (first) {
                sb.append(co.getName());
                first = false;
                continue;
            }
            sb.append("\n").append(co.getName());
        }
        return sb.toString();
    }

    private boolean equalColumnOrder(Table sourseTable, Table targetTable) {
        if (this.sourceTable == null || targetTable == null) {
            return true;
        }
        ContainedObject[] sourseColumns = sourseTable.getElements();
        ContainedObject[] targetColumns = targetTable.getElements();
        for (int i = 0; i < sourseColumns.length; ++i) {
            if (i > targetColumns.length - 1) {
                return true;
            }
            Column sCol = (Column)sourseColumns[i];
            Column tCol = (Column)targetColumns[i];
            if (tCol.getImportedId() != null && sCol.getObjectID().equals(tCol.getImportedId()) || tCol.getName().equals(sCol.getName()) || tCol.getDataType().toString().equals(sCol.getDataType().toString()) && sCol.getContainer().getElementByName(tCol.getName()) == null) continue;
            return false;
        }
        return true;
    }

    private boolean equalColumnsOrderNew(Table sourseTable, Table targetTable) {
        if (this.getLeftSelectionObject() != null) {
            List list = this.getDeletedColumnNodes(this.getLeftSelectionObject());
            CompareObjectSelection[] cnodes = this.getColumnNodes(this.getLeftSelectionObject());
            for (int i = 0; i < cnodes.length; ++i) {
                int rind;
                int delta;
                Column rcolumn;
                CompareObjectSelection colnode = cnodes[i];
                if (colnode.getStatus() == 2 && this.isBeforeUnchangedColumn(i, cnodes)) {
                    return false;
                }
                if (colnode.getStatus() != 0 && colnode.getStatus() != 1 || (rcolumn = (Column)colnode.getCorrespondentNode().getObject()) == null || i == rcolumn.getIndex() || (delta = (rind = rcolumn.getIndex()) - i) > 0 && delta == this.getNumberOfDeleted(i, rind, list)) continue;
                return false;
            }
            return true;
        }
        return this.equalColumnOrder(sourseTable, targetTable);
    }

    private int getNumberOfDeleted(int start, int before, List deleted) {
        int res = 0;
        for (CompareObjectSelection colnode : deleted) {
            int rind;
            Column rcolumn = (Column)colnode.getCorrespondentNode().getObject();
            if (rcolumn == null || (rind = rcolumn.getIndex()) >= before) continue;
            ++res;
        }
        return res;
    }

    private CompareObjectSelection[] getColumnNodes(CompareObjectSelection tableNode) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        CompareObjectSelection columns = (CompareObjectSelection)tableNode.getChild(0);
        int nod_number = columns.getNumberOfChildren();
        for (int i = 0; i < nod_number; ++i) {
            CompareObjectSelection cnode = (CompareObjectSelection)columns.getChild(i);
            if (cnode.getStatus() == 3 || (!cnode.isSelected() || cnode.getStatus() != 2) && cnode.getStatus() == 2) continue;
            list.add(cnode);
        }
        return list.toArray(new CompareObjectSelection[0]);
    }

    private List getDeletedColumnNodes(CompareObjectSelection tableNode) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        CompareObjectSelection columns = (CompareObjectSelection)tableNode.getChild(0);
        int nod_number = columns.getNumberOfChildren();
        for (int i = 0; i < nod_number; ++i) {
            CompareObjectSelection cnode = (CompareObjectSelection)columns.getChild(i);
            if (cnode.getStatus() != 3) continue;
            list.add(cnode);
        }
        return list;
    }

    private boolean isBeforeUnchangedColumn(int index, CompareObjectSelection[] columns) {
        for (int i = index + 1; i < columns.length; ++i) {
            if (columns[i].getStatus() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceTable != null && this.targetTable != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected() || (!ph.getName().equals(SCHEMA) || this.settings != null && !this.settings.isIncludeSchemaInDDL()) && !ph.getName().equals(STRUCTURED_TYPE) && !ph.getName().equals(SPATIAL_TABLE) && (!ph.getName().equals(COLUMNS_ORDER) || this.equalColumnsOrderNew(this.sourceTable, this.targetTable))) continue;
                return true;
            }
            return this.hasCreateProperties();
        }
        return false;
    }

    @Override
    protected boolean hasToBeRenameOnly() {
        if (!this.hasToBeRename() && this.sourceTable != null && this.targetTable != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.getName().equals(NAME)) continue;
                return ph.isSelected();
            }
        }
        return false;
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceTable == null && this.targetTable != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    protected void initSchemaProperty() {
        PropertyHolder ph = new PropertyHolder(SCHEMA);
        String lschema = "";
        if (this.sourceTableProxy != null) {
            lschema = this.sourceTableProxy.getSchemaImplementationName();
        }
        if ("".equals(lschema) && this.sourceTable != null && this.sourceTable.getSchemaObject() != null) {
            lschema = this.sourceTable.getSchemaObject().getName();
        }
        String rschema = "";
        if (this.targetTableProxy != null) {
            rschema = this.targetTableProxy.getSchemaImplementationName();
        }
        if ("".equals(rschema) && this.targetTable != null && this.targetTable.getSchemaObject() != null) {
            rschema = this.targetTable.getSchemaObject().getName();
        }
        lschema = this.getSqlServerSchemaName(this.sourceTableProxy, lschema);
        rschema = this.getSqlServerSchemaName(this.targetTableProxy, rschema);
        ph.setLeftValue(lschema);
        ph.setRightValue(rschema);
        if (this.isExcludedFromComparison(SCHEMA)) {
            ph.setExcluded(true);
        } else if (this.caseSensitive) {
            if (!ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                if (this.useSchema) {
                    ph.setSelected(true);
                } else {
                    ph.setFiltered(true);
                }
            }
        } else if (!ph.getLeftValue().equalsIgnoreCase(ph.getRightValue())) {
            ph.setModified(true);
            if (this.useSchema) {
                ph.setSelected(true);
            } else {
                ph.setFiltered(true);
            }
        }
        this.propertiesList.add(ph);
    }

    public Table getSourceTable() {
        return this.sourceTable;
    }

    public TableProxy getSourceTableProxy() {
        return this.sourceTableProxy;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public TableProxy getTargetTableProxy() {
        return this.targetTableProxy;
    }

    private String getSqlServerSchemaName(TableProxy proxy, String schema) {
        return schema;
    }

    public void presetColumnsOrder() {
        EngPropertyHolder ph = this.getPropertyHolderByName(COLUMNS_ORDER);
        if (ph != null) {
            if (this.getLeftSelectionObject() != null) {
                ph.setRightValue(this.targetTable != null ? this.getElementsToString(this.targetTable) : "");
                CompareObjectSelection[] nodes = this.getColumnNodes(this.getLeftSelectionObject());
                ph.setLeftValue(this.sourceTable != null ? this.getElementsToString(nodes) : "");
                if (!this.equalColumnsOrderNew(this.sourceTable, this.targetTable)) {
                    ph.setSelected(true);
                    ph.setModified(true);
                } else {
                    ph.setSelected(false);
                    ph.setModified(false);
                }
            } else {
                ph.setLeftValue(this.sourceTable != null ? this.getElementsToString(this.sourceTable) : "");
                ph.setRightValue(this.targetTable != null ? this.getElementsToString(this.targetTable) : "");
                if (!this.equalColumnsOrderNew(this.sourceTable, this.targetTable)) {
                    ph.setSelected(true);
                    ph.setModified(true);
                }
            }
            if (!this.useColumnsOrder) {
                ph.setSelected(false);
            }
        }
    }

    private String getElementsToString(CompareObjectSelection[] nodes) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < nodes.length; ++i) {
            ContainedObject co = (ContainedObject)nodes[i].getObject();
            if (first) {
                sb.append(co.getName());
                first = false;
                continue;
            }
            sb.append("; ").append(co.getName());
        }
        return sb.toString();
    }

    public void setSnapshotDropped(boolean snapshotDropped) {
        this.snapshotDropped = snapshotDropped;
    }

    public boolean isSnapshotDropped() {
        return this.snapshotDropped;
    }
}

