/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.AbstractDataType;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeNames;
import oracle.dbtools.crest.model.datatype.MDUserDefined_NoParams;
import oracle.dbtools.crest.model.datatype.MDUserDefined_PS;
import oracle.dbtools.crest.model.datatype.MDUserDefined_Sized;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;

public abstract class MDDataTypeFactory
implements MDDataTypeNames {
    protected static MDDataTypeFactory instance = null;
    protected static Map instances = new TreeMap();
    protected Map flyweights = null;
    protected Map heavyweights = null;
    public RDBMSType dbtype = null;

    protected MDDataTypeFactory() {
    }

    public MDDataType createType(String name) {
        if (this.getFlyWeights().containsKey(name)) {
            try {
                return (MDDataType)this.getFlyWeights().get(name);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (this.getHeavyWeights().containsKey(name)) {
            try {
                return (MDDataType)((Class)this.getHeavyWeights().get(name)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (!LogicalDatatypeSet.UNKNOWN.equalsIgnoreCase(name)) {
            NativeDBType nt;
            RDBMSType type = this.dbtype;
            if (type == null) {
                type = StorageDesignOraclev12c.RDBMS_TYPE;
            }
            if ((nt = StandardDatatypeNames.getNativeDBType(type, name)) != null && nt.isHasPrecision()) {
                MDUserDefined_PS dt = new MDUserDefined_PS(name);
                if (!nt.isHasScale()) {
                    dt.setHasScale(false);
                }
                return dt;
            }
            if (nt != null && nt.isHasSize()) {
                return new MDUserDefined_Sized(name);
            }
            if (nt != null) {
                return new MDUserDefined_NoParams(name);
            }
        }
        return null;
    }

    public MDDataType createStringEncodedType(String coded) {
        String[] parts = MDDataTypeFactory.tokenize(coded);
        return this.createStringEncodedType(parts);
    }

    public MDDataType createStringEncodedType(String[] parts) {
        switch (parts.length) {
            case 1: {
                return this.createType(parts[0]);
            }
            case 2: {
                String[] parts_n;
                String numeric = parts[1];
                if (numeric.indexOf(32) > 0 && (parts_n = numeric.split(" ")).length == 2 && (parts_n[1].equalsIgnoreCase("BYTE") || parts_n[1].equalsIgnoreCase("CHAR"))) {
                    return this.createType(parts[0], numeric);
                }
                if ("size".equals(numeric)) {
                    return this.createType(parts[0], "0");
                }
                return this.createType(parts[0], parts[1]);
            }
            case 3: {
                return this.createType(parts[0], parts[1], parts[2]);
            }
        }
        throw new RuntimeException(Messages.getString("MDDataTypeFactory.Expected1to3Parts"));
    }

    public static int parseSafely(String numeric) {
        try {
            int size = AbstractDataType.parseSize(numeric.trim());
            if (size != -1) {
                return size;
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int parse(String numeric) {
        try {
            return Integer.parseInt(numeric.trim());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static String[] tokenize(String coded) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(coded, ",;", false);
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken().trim());
        }
        return list.toArray(new String[0]);
    }

    protected synchronized Map getFlyWeights() {
        if (this.flyweights == null) {
            this.flyweights = new TreeMap();
            this.initFlyWeights();
        }
        return this.flyweights;
    }

    protected synchronized Map getHeavyWeights() {
        if (this.heavyweights == null) {
            this.heavyweights = new TreeMap();
            this.initHeavyWeights();
        }
        return this.heavyweights;
    }

    public static int stringToInt(String string) {
        int pr = 0;
        try {
            pr = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return pr;
    }

    public MDDataType createUDNativeType(String name, String size) {
        if (!LogicalDatatypeSet.UNKNOWN.equalsIgnoreCase(name)) {
            NativeDBType nt;
            RDBMSType type = this.dbtype;
            if (type == null) {
                type = StorageDesignOraclev12c.RDBMS_TYPE;
            }
            if ((nt = StandardDatatypeNames.getNativeDBType(type, name)) != null && nt.isHasSize()) {
                MDUserDefined_Sized dt = new MDUserDefined_Sized(name);
                dt.setSize(size);
                return dt;
            }
            if (nt != null && nt.isHasPrecision()) {
                MDUserDefined_PS dt = new MDUserDefined_PS(name);
                dt.setPrecision(MDDataTypeFactory.parseSafely(size));
                return dt;
            }
            if (nt != null) {
                return new MDUserDefined_NoParams(name);
            }
        }
        return null;
    }

    public MDDataType createUDNativeType(String name, int precision, int scale) {
        if (!LogicalDatatypeSet.UNKNOWN.equalsIgnoreCase(name)) {
            NativeDBType nt;
            RDBMSType type = this.dbtype;
            if (type == null) {
                type = StorageDesignOraclev12c.RDBMS_TYPE;
            }
            if ((nt = StandardDatatypeNames.getNativeDBType(type, name)) != null && nt.isHasPrecision()) {
                MDUserDefined_PS dt = new MDUserDefined_PS(name);
                dt.setPrecision(precision);
                dt.setScale(scale);
                return dt;
            }
            if (nt != null) {
                return new MDUserDefined_NoParams(name);
            }
        }
        return null;
    }

    public MDDataType createType(String name, String precision, String scale) {
        int prec = this.getMaxPrecision(name);
        try {
            prec = Integer.valueOf(precision);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int sc = 0;
        try {
            sc = Integer.valueOf(scale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createType(name, prec, sc);
    }

    protected abstract void initFlyWeights();

    protected abstract void initHeavyWeights();

    public abstract MDDataType createType(String var1, String var2);

    public abstract MDDataType createType(String var1, int var2, int var3);

    public RDBMSType getRDBMSType() {
        return this.dbtype;
    }

    public void setRDBMSType(RDBMSType dbtype) {
        this.dbtype = dbtype;
    }

    public int getMaxPrecision(String type) {
        String tupper = type.toUpperCase();
        if (type.startsWith("NUM")) {
            return 38;
        }
        if (tupper.startsWith("TIMES") || tupper.startsWith("INTERVAL")) {
            return 9;
        }
        if (type.equals("FLOAT")) {
            return 126;
        }
        return 38;
    }
}

