/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import oracle.dbtools.crest.model.MDUser;
import oracle.dbtools.crest.model.MDUserFactory;
import oracle.dbtools.crest.util.logging.Logger;

public class ObjectChange {
    public static final SimpleDateFormat DATEONLY_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat DATE_FORMATTER_TZ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz");
    private MDUser user = MDUserFactory.getInstance().getCurrentUser();
    private long timeStamp = System.currentTimeMillis();
    private String timeString;
    private static final Logger LOGGER = new Logger(ObjectChange.class);

    public void setTime(long timeStamp) {
        this.timeStamp = timeStamp;
        this.timeString = null;
    }

    public void setTimeNow() {
        this.timeStamp = System.currentTimeMillis();
    }

    public long getTime() {
        if (this.timeString != null) {
            this.timeStamp = ObjectChange.stringToTime(this.timeString);
        }
        return this.timeStamp;
    }

    public String getTimeString() {
        if (this.timeString == null) {
            this.timeString = ObjectChange.timeToString(this.getTime(), "UTC");
        }
        return this.timeString;
    }

    public String getTimeString(String zone) {
        if (this.timeString != null && "UTC".equals(zone)) {
            return this.timeString;
        }
        return ObjectChange.timeToString(this.getTime(), zone);
    }

    public boolean setTimeString(String value) {
        this.timeString = value;
        return true;
    }

    public void setUser(MDUser user) {
        this.user = user;
    }

    public MDUser getUser() {
        return this.user;
    }

    public static String timeToString(long value) {
        return ObjectChange.timeToString(value, null);
    }

    public static String timeToString(long value, String zone) {
        if (zone != null) {
            DATE_FORMATTER_TZ.setTimeZone(TimeZone.getTimeZone(zone));
        } else {
            DATE_FORMATTER_TZ.setTimeZone(TimeZone.getDefault());
        }
        return DATE_FORMATTER_TZ.format(new Date(value));
    }

    public static long stringToTime(String value) {
        return ObjectChange.stringToTime(value, null);
    }

    public static long stringToTime(String value, String zone) {
        if (zone != null) {
            DATE_FORMATTER_TZ.setTimeZone(TimeZone.getTimeZone(zone));
        } else {
            DATE_FORMATTER_TZ.setTimeZone(TimeZone.getDefault());
        }
        try {
            return DATE_FORMATTER_TZ.parse(value).getTime();
        }
        catch (ParseException x) {
            try {
                if (zone != null) {
                    DATE_FORMATTER.setTimeZone(TimeZone.getTimeZone(zone));
                } else {
                    DATE_FORMATTER.setTimeZone(TimeZone.getDefault());
                }
                return DATE_FORMATTER.parse(value).getTime();
            }
            catch (ParseException e) {
                LOGGER.error("", e);
                return 0L;
            }
        }
    }
}

