/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.StringTokenizer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.util.logging.Logger;

public class MaskTemplate
extends ModelIDObject {
    private int dataType;
    private String day;
    private int functionType;
    private String hour;
    private String inputFormat;
    private String maskChar;
    private int maskFrom;
    private int maskTo;
    private String matchParameter;
    private String minute;
    private String month;
    private int occurrence;
    private String outputFormat;
    private String pattern;
    private int position;
    private String replaceString;
    private String second;
    private String year;
    private static final String EMPTY_VALUE = "";
    public static final int FUNCTION_TYPE_PARTIAL = 0;
    public static final int FUNCTION_TYPE_REGEXP = 1;
    public static final int DATATYPE_CHARACTER = 0;
    public static final int DATATYPE_NUMERIC = 1;
    public static final int DATATYPE_DATE = 2;
    public static final String MT_NOT_DEFINED = "";
    public static final String MT_NO = "NO";
    public static final String MT_NONE = "NONE";
    public static final String MT_FULL = "FULL";
    public static final String MT_PARTIAL = "PARTIAL";
    public static final String MT_RANDOM = "RANDOM";
    public static final String MT_REGEXP = "REGEXP";
    public static final String MT_TEST = "TEST";
    public static final String[] MASKING_TYPES = new String[]{"", "FULL", "NO", "PARTIAL", "RANDOM", "REGEXP", "TEST"};
    private String functionParameters = null;
    private static final Logger LOGGER = new Logger(MaskTemplate.class);
    static final String SEP = ",";

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public String getDay() {
        return this.day;
    }

    public void setDay(String day) {
        this.day = day;
    }

    public int getFunctionType() {
        return this.functionType;
    }

    public void setFunctionType(int functionType) {
        this.functionType = functionType;
    }

    public String getHour() {
        return this.hour;
    }

    public void setHour(String hour) {
        this.hour = hour;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public String getMaskChar() {
        return this.maskChar;
    }

    public void setMaskChar(String maskChar) {
        this.maskChar = maskChar;
    }

    public int getMaskFrom() {
        return this.maskFrom;
    }

    public void setMaskFrom(int maskFrom) {
        this.maskFrom = maskFrom;
    }

    public int getMaskTo() {
        return this.maskTo;
    }

    public void setMaskTo(int maskTo) {
        this.maskTo = maskTo;
    }

    public String getMatchParameter() {
        return this.matchParameter;
    }

    public void setMatchParameter(String matchParameter) {
        this.matchParameter = matchParameter;
    }

    public String getMinute() {
        return this.minute;
    }

    public void setMinute(String minute) {
        this.minute = minute;
    }

    public String getMonth() {
        return this.month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public int getOccurrence() {
        return this.occurrence;
    }

    public void setOccurrence(int occurrence) {
        this.occurrence = occurrence;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getReplaceString() {
        return this.replaceString;
    }

    public void setReplaceString(String replaceString) {
        this.replaceString = replaceString;
    }

    public String getSecond() {
        return this.second;
    }

    public void setSecond(String second) {
        this.second = second;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    @Override
    public String getObjectTypeName() {
        return "MaskTemplate";
    }

    @Override
    public String getIDPrefix() {
        return "MSKTMPL";
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    public boolean isEqual(MaskTemplate maskTemplate) {
        if (maskTemplate.getFunctionType() != this.getFunctionType()) {
            return false;
        }
        if (maskTemplate.getDataType() != this.getDataType()) {
            return false;
        }
        if (!maskTemplate.getInputFormat().equals(this.getInputFormat())) {
            return false;
        }
        if (!maskTemplate.getOutputFormat().equals(this.getOutputFormat())) {
            return false;
        }
        if (!maskTemplate.getMaskChar().equals(this.getMaskChar())) {
            return false;
        }
        if (maskTemplate.getMaskFrom() != this.getMaskFrom()) {
            return false;
        }
        if (maskTemplate.getMaskTo() != this.getMaskTo()) {
            return false;
        }
        if (!maskTemplate.getMonth().equals(this.getMonth())) {
            return false;
        }
        if (!maskTemplate.getDay().equals(this.getDay())) {
            return false;
        }
        if (!maskTemplate.getYear().equals(this.getYear())) {
            return false;
        }
        if (!maskTemplate.getHour().equals(this.getHour())) {
            return false;
        }
        if (!maskTemplate.getMinute().equals(this.getMinute())) {
            return false;
        }
        if (!maskTemplate.getSecond().equals(this.getSecond())) {
            return false;
        }
        if (!maskTemplate.getPattern().equals(this.getPattern())) {
            return false;
        }
        if (!maskTemplate.getReplaceString().equals(this.getReplaceString())) {
            return false;
        }
        if (maskTemplate.getPosition() != this.getPosition()) {
            return false;
        }
        if (maskTemplate.getOccurrence() != this.getOccurrence()) {
            return false;
        }
        return maskTemplate.getMatchParameter().equals(this.getMatchParameter());
    }

    public String getFunctionParameters() {
        if (this.functionType == 0) {
            if (this.functionParameters != null) {
                return this.functionParameters;
            }
            switch (this.dataType) {
                case 0: {
                    return this.inputFormat + SEP + this.outputFormat + SEP + this.maskChar + SEP + this.maskFrom + SEP + this.maskTo;
                }
                case 1: {
                    return this.maskChar + SEP + this.maskFrom + SEP + this.maskTo;
                }
                case 2: {
                    return this.month + this.day + this.year + this.hour + this.minute + this.second;
                }
            }
        }
        return "";
    }

    public void parseFunctionParameters(String parameters) {
        this.functionParameters = parameters == null ? "" : parameters;
        if (!"".equalsIgnoreCase(this.functionParameters)) {
            try {
                if (this.dataType == 0) {
                    StringTokenizer st = new StringTokenizer(this.functionParameters, SEP);
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken().trim();
                        if (i == 0 && "STR".equalsIgnoreCase(token)) continue;
                        if (++i == 1) {
                            this.inputFormat = token;
                            continue;
                        }
                        if (i == 2) {
                            this.outputFormat = token;
                            continue;
                        }
                        if (i == 3) {
                            this.maskChar = token;
                            continue;
                        }
                        if (i == 4) {
                            this.maskFrom = Integer.parseInt(token);
                            continue;
                        }
                        if (i != 5) continue;
                        this.maskTo = Integer.parseInt(token);
                    }
                    this.functionParameters = null;
                } else if (this.dataType == 1) {
                    StringTokenizer st = new StringTokenizer(this.functionParameters, SEP);
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if (++i == 1) {
                            this.maskChar = token;
                            continue;
                        }
                        if (i == 2) {
                            this.maskFrom = Integer.parseInt(token);
                            continue;
                        }
                        if (i != 3) continue;
                        this.maskTo = Integer.parseInt(token);
                    }
                    this.functionParameters = null;
                } else if (this.dataType == 2) {
                    String upper = this.functionParameters.trim().toUpperCase();
                    int posD = upper.indexOf("D");
                    int posY = upper.indexOf("Y");
                    int posH = upper.indexOf("H");
                    int posM = upper.lastIndexOf("M");
                    int posS = upper.indexOf("S");
                    if (posD > 0 && posY > 0 && posH > 0 && posM > 0 && posS > 0) {
                        String p_month = upper.substring(0, posD);
                        String p_day = upper.substring(posD, posY);
                        String p_year = upper.substring(posY, posH);
                        String p_hour = upper.substring(posH, posM);
                        String p_minute = upper.substring(posM, posS);
                        String p_secund = upper.substring(posS);
                        this.month = p_month;
                        this.day = p_day;
                        this.year = p_year;
                        this.hour = p_hour;
                        this.minute = p_minute;
                        this.second = p_secund;
                        this.functionParameters = null;
                    } else {
                        LOGGER.error("MaskTemplate: Wrong datetime function parameters: " + this.functionParameters);
                    }
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("MaskTemplate: Unable to parse function parameters", e);
            }
        }
    }
}

