/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public class MOHDirectoryOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "DIRECTORY";
    private static final Logger LOGGER = new Logger(MOHDirectoryOracle.class);
    protected boolean dbaUser;

    public MOHDirectoryOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHDirectoryOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List extract(Connection sqlConnection, List schemas) throws SQLException {
        ResultSet rs;
        Statement statement;
        ArrayList<DBObject> list;
        block6: {
            TimeLog.log("Extract Directory begin");
            list = new ArrayList<DBObject>();
            statement = sqlConnection.createStatement();
            rs = null;
            try {
                String filterCondition = this.getFilterConditionOracle("directory_name");
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("directory_name").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? "dba_directories" : "all_directories").append(' ');
                if (filterCondition != null) {
                    buffer.append("WHERE").append(' ').append(filterCondition).append(' ');
                }
                buffer.append("ORDER BY").append(' ');
                buffer.append("directory_name");
                rs = statement.executeQuery(buffer.toString());
                if (rs == null) break block6;
                while (rs.next()) {
                    String userName = rs.getString("directory_name");
                    DBObject dboUser = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), userName, OBJECT_TYPE);
                    list.add(dboUser);
                }
                rs.close();
            }
            catch (Exception e) {
                try {
                    LOGGER.error("MOHDirectoryOracle.extract():", e);
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    throw throwable;
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        TimeLog.log("Extract Directory begin");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBObject> getDirectories(Connection sqlConnection) throws SQLException {
        ResultSet rs;
        Statement statement;
        ArrayList<DBObject> list;
        block7: {
            list = new ArrayList<DBObject>();
            statement = sqlConnection.createStatement();
            rs = null;
            try {
                String filterCondition = this.getFilterConditionOracle("directory_name");
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("directory_name").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? "dba_directories" : "all_directories").append(' ');
                if (filterCondition != null) {
                    buffer.append("WHERE").append(' ').append(filterCondition).append(' ');
                }
                buffer.append("ORDER BY").append(' ');
                buffer.append("directory_name");
                String sql = buffer.toString();
                int limit = this.getDbmeHandler().getLimit();
                if (limit > 0) {
                    sql = this.getDbmeHandler().getPaginatedQuery(sql);
                }
                if ((rs = statement.executeQuery(sql)) == null) break block7;
                while (rs.next()) {
                    String tsName = rs.getString(1);
                    DBObject dboTs = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tsName, OBJECT_TYPE);
                    list.add(dboTs);
                }
                rs.close();
            }
            catch (Exception e) {
                try {
                    LOGGER.error("MOHDirectoryOracle.getDirectories():", e);
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    throw throwable;
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws SQLException {
        PreparedStatement statement = null;
        try {
            for (int i = 0; i < selectedObjects.size(); ++i) {
                DBObject dbo = (DBObject)selectedObjects.get(i);
                if (OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) {
                    ResultSet rs = null;
                    try {
                        if (statement == null) {
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("SELECT").append(' ');
                            buffer.append("directory_name").append(',');
                            buffer.append("directory_path").append(' ');
                            buffer.append("FROM").append(' ');
                            buffer.append(this.dbaUser ? "dba_directories" : "all_directories").append(' ');
                            buffer.append("WHERE").append(' ');
                            buffer.append("directory_name").append('=').append('?');
                            statement = sqlConnection.prepareStatement(buffer.toString());
                        }
                        statement.setString(1, dbo.getName());
                        rs = statement.executeQuery();
                        if (rs != null) {
                            StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
                            while (rs.next()) {
                                String name = rs.getString("directory_name");
                                String path = rs.getString("directory_path");
                                DirectoryOracle directory = (DirectoryOracle)storage.getDirectorySet().getByName(name);
                                if (directory == null) {
                                    directory = storage.getDirectorySet().createDirectory();
                                    directory.setName(name);
                                }
                                if (!name.equals(name.toUpperCase())) {
                                    directory.setNameHasQuotes(true);
                                }
                                directory.setDirPath(path);
                                this.stampModelObject(directory, dbo);
                            }
                            rs.close();
                        }
                        Closeables.close((Object)rs);
                    }
                    catch (Exception e) {
                        LOGGER.error("MOHDirectoryOracle.generate():", e);
                    }
                    finally {
                        Closeables.close(rs);
                    }
                }
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                importLog.incrementImportedStatements();
                this.addToHandledObjects(dbo);
            }
        }
        finally {
            Closeables.close(statement);
        }
    }
}

