/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling.compare;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.ddl.scheduling.SSBSchedulerProgram;
import oracle.dbtools.crest.exports.ddl.scheduling.SSBSchedulerWindowGroup;
import oracle.dbtools.crest.exports.ddl.scheduling.compare.CSSBScheduler;
import oracle.dbtools.crest.model.scheduling.SchedulerArgument;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerProgram;
import oracle.dbtools.crest.model.scheduling.SchedulerWindowGroup;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerObjectCompare;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerProgramCompare;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerWindowGroupCompare;

public class CSSBSchedulerWindowGroup
extends CSSBScheduler {
    Map<String, String> excludeNullsMap = new HashMap<String, String>();

    public CSSBSchedulerWindowGroup() {
        this.excludeNullsMap.put("OWNER", "OWNER");
        this.excludeNullsMap.put("WINDOW_GROUP_NAME", "WINDOW_GROUP_NAME");
        this.excludeNullsMap.put("NUMBER_OF_WINDOWS", "NUMBER_OF_WINDOWS");
        this.excludeNullsMap.put("NEXT_START_DATE", "NEXT_START_DATE");
        this.excludeNullsMap.put("ENABLED", "ENABLED");
    }

    @Override
    public Map<String, String> getExcludeMap() {
        if (this.excludeMap == null) {
            this.excludeMap = new HashMap();
        }
        this.excludeMap.put("OWNER", "OWNER");
        this.excludeMap.put("WINDOW_GROUP_NAME", "WINDOW_GROUP_NAME");
        this.excludeMap.put("NUMBER_OF_WINDOWS", "NUMBER_OF_WINDOWS");
        this.excludeMap.put("NEXT_START_DATE", "NEXT_START_DATE");
        this.excludeMap.put("ENABLED", "ENABLED");
        return this.excludeMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        SchedulerWindowGroupCompare comp;
        if (object instanceof SchedulerWindowGroupCompare && (comp = (SchedulerWindowGroupCompare)object).isModified()) {
            Map<String, String> excludeMap = this.getExcludeMap();
            StringBuffer buffer = new StringBuffer();
            CSSBSchedulerWindowGroup.appendStringWithSpace(buffer, "BEGIN");
            boolean disabled = false;
            CSSBSchedulerWindowGroup.appendAtrtributes(buffer, comp, prettyPrint, excludeMap);
            CSSBSchedulerWindowGroup.removedMembers(buffer, comp.getTarget(), comp.getToRemove(), prettyPrint);
            SSBSchedulerWindowGroup.addMembers(buffer, comp.getTarget(), comp.getToAdd(), prettyPrint);
            CSSBSchedulerWindowGroup.appendEnable(buffer, comp, disabled, prettyPrint);
            CSSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 0);
            CSSBSchedulerWindowGroup.appendString(buffer, "END");
            CSSBSchedulerWindowGroup.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, "");
        }
    }

    public static void removedMembers(StringBuffer buffer, SchedulerObject obj, List<String> names, boolean prettyPrint) {
        if (names.size() > 0) {
            int added = 0;
            for (String name : names) {
                if (added % 15 == 0) {
                    if (added > 0) {
                        CSSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 1);
                        CSSBSchedulerWindowGroup.appendStringWithSpace(buffer, ");");
                    }
                    CSSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSchedulerWindowGroup.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.REMOVE_GROUP_MEMBER(");
                    CSSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSchedulerWindowGroup.appendString(buffer, "group_name => '" + obj.getNameFormatted() + "',");
                    CSSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSchedulerWindowGroup.appendString(buffer, "member => '" + SchedulerObject.getFormatedSimpleName(name) + "'");
                } else {
                    CSSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSchedulerWindowGroup.appendString(buffer, "||'," + SchedulerObject.getFormatedSimpleName(name) + "'");
                }
                ++added;
            }
            CSSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 1);
            CSSBSchedulerWindowGroup.appendStringWithSpace(buffer, ");");
        }
    }

    public static void setNumberOfArgumentsToZero(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String val = comp.getTarget().getProperty("NUMBER_OF_ARGUMENTS");
        if (val == null) {
            CSSBSchedulerWindowGroup.appendSetAttribute(buffer, comp.getObjectFormattedName(), "NUMBER_OF_ARGUMENTS", "0", "NUMBER", prettyPrint);
        }
    }

    public static void setNumberOfArguments(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String val = comp.getProperty("NUMBER_OF_ARGUMENTS");
        if (val != null && !val.isEmpty()) {
            CSSBSchedulerWindowGroup.appendSetAttribute(buffer, comp.getObjectFormattedName(), "NUMBER_OF_ARGUMENTS", val, "NUMBER", prettyPrint);
        } else if (comp.containsNullProp("NUMBER_OF_ARGUMENTS")) {
            CSSBSchedulerWindowGroup.appendNullAtrtribute(buffer, comp, "NUMBER_OF_ARGUMENTS", prettyPrint);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchedulerObjectCompare && ((SchedulerObjectCompare)object).getSource() instanceof SchedulerWindowGroup;
    }

    public void appendArguments(StringBuffer buffer, SchedulerProgramCompare comp, SchedulerProgram prog, boolean prettyPrint, Map<String, String> excludeMap) {
        for (SchedulerArgument arg : comp.getArgsToRemove()) {
            CSSBSchedulerWindowGroup.dropdProgramArgument(buffer, comp, arg, prettyPrint);
        }
        for (SchedulerArgument arg : comp.getArgsToAdd()) {
            if (arg.isMetadataArgument()) {
                SSBSchedulerProgram.appendMetadataArgument(buffer, prog, arg, prettyPrint);
                continue;
            }
            SSBSchedulerProgram.appendProgramArgument(buffer, prog, arg, prettyPrint);
        }
    }

    public static void dropdProgramArgument(StringBuffer buffer, SchedulerProgramCompare comp, SchedulerArgument arg, boolean prettyPrint) {
        CSSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 1);
        CSSBSchedulerWindowGroup.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.DROP_PROGRAM_ARGUMENT(");
        SSBSchedulerProgram.appendStringAttribute(buffer, "program_name".toLowerCase(), comp.getObjectFormattedName(), prettyPrint);
        CSSBSchedulerWindowGroup.appendString(buffer, ',');
        SSBSchedulerProgram.appendNonStringAttribute(buffer, "ARGUMENT_POSITION".toLowerCase(), arg.getProperty("ARGUMENT_POSITION"), prettyPrint);
        CSSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 1);
        CSSBSchedulerWindowGroup.appendStringWithSpace(buffer, ");");
    }
}

