/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.scheduling.SQLStatementBuilderScheduler;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerWindowGroup;

public class SSBSchedulerWindowGroup
extends SQLStatementBuilderScheduler {
    @Override
    public Map<String, String> getExcludeMap() {
        if (this.excludeMap == null) {
            this.excludeMap = new TreeMap();
        }
        this.excludeMap.put("OWNER", "OWNER");
        this.excludeMap.put("WINDOW_GROUP_NAME", "WINDOW_GROUP_NAME");
        this.excludeMap.put("NUMBER_OF_WINDOWS", "NUMBER_OF_WINDOWS");
        this.excludeMap.put("NEXT_START_DATE", "NEXT_START_DATE");
        this.excludeMap.put("ENABLED", "ENABLED");
        return this.excludeMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        if (object instanceof SchedulerWindowGroup) {
            SchedulerWindowGroup wgroup = (SchedulerWindowGroup)object;
            if (wgroup.isMinimumDefined()) {
                Map<String, String> excludeMap = this.getExcludeMap();
                StringBuffer buffer = new StringBuffer();
                SSBSchedulerWindowGroup.appendStringWithSpace(buffer, "BEGIN");
                SSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 1);
                SSBSchedulerWindowGroup.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.CREATE_GROUP(");
                SSBSchedulerWindowGroup.appendObjectName(buffer, wgroup, prettyPrint);
                SSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 2);
                SSBSchedulerWindowGroup.appendString(buffer, "group_type => 'WINDOW'");
                SSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 1);
                SSBSchedulerWindowGroup.appendStringWithSpace(buffer, ");");
                SSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerWindowGroup.addMembers(buffer, wgroup, wgroup.getSortedWindows(), prettyPrint);
                SSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 0);
                this.appendAtrtributes(buffer, wgroup, prettyPrint, excludeMap);
                SSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerWindowGroup.appendEnable(buffer, wgroup, prettyPrint);
                SSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerWindowGroup.appendString(buffer, "END");
                SSBSchedulerWindowGroup.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, "");
            } else {
                SSBSchedulerWindowGroup.appendStringWithSpace(oldbuffer, "invalid program definitiion for " + String.valueOf(wgroup.getName() + "\n program type and program action should be defined"));
            }
        }
    }

    public static void appendObjectName(StringBuffer buffer, SchedulerObject obj, boolean prettyPrint) {
        SSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 2);
        SSBSchedulerWindowGroup.appendString(buffer, "group_name => '" + obj.getNameFormatted() + "',");
    }

    public static void appendEnable(StringBuffer buffer, SchedulerObject job, boolean prettyPrint) {
        String res = job.getProperty("ENABLED");
        if (res != null && !res.isEmpty() && "TRUE".equalsIgnoreCase(res)) {
            String name = job.getNameFormatted();
            SSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerWindowGroup.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.enable(name => '" + name + "');");
        }
    }

    public static void addMembers(StringBuffer buffer, SchedulerObject obj, List<String> names, boolean prettyPrint) {
        if (names.size() > 0) {
            int added = 0;
            for (String name : names) {
                if (added % 15 == 0) {
                    if (added > 0) {
                        SSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 1);
                        SSBSchedulerWindowGroup.appendStringWithSpace(buffer, ");");
                    }
                    SSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 1);
                    SSBSchedulerWindowGroup.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.ADD_GROUP_MEMBER(");
                    SSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 2);
                    SSBSchedulerWindowGroup.appendString(buffer, "group_name => '" + obj.getNameFormatted() + "',");
                    SSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 2);
                    SSBSchedulerWindowGroup.appendString(buffer, "member => '" + SchedulerObject.getFormatedSimpleName(name) + "'");
                } else {
                    SSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 2);
                    SSBSchedulerWindowGroup.appendString(buffer, "||'," + SchedulerObject.getFormatedSimpleName(name) + "'");
                }
                ++added;
            }
            SSBSchedulerWindowGroup.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerWindowGroup.appendStringWithSpace(buffer, ");");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchedulerWindowGroup;
    }
}

