/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.scheduling.SQLStatementBuilderScheduler;
import oracle.dbtools.crest.model.scheduling.SchedulerFileWatcher;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public class SSBSchedulerFileWatcher
extends SQLStatementBuilderScheduler {
    @Override
    public Map<String, String> getExcludeMap() {
        if (this.excludeMap == null) {
            this.excludeMap = new TreeMap();
        }
        this.excludeMap.put("OWNER", "OWNER");
        this.excludeMap.put("FILE_WATCHER_NAME", "FILE_WATCHER_NAME");
        this.excludeMap.put("DIRECTORY_PATH", "DIRECTORY_PATH");
        this.excludeMap.put("FILE_NAME", "FILE_NAME");
        this.excludeMap.put("CREDENTIAL_OWNER", "CREDENTIAL_OWNER");
        this.excludeMap.put("CREDENTIAL_NAME", "CREDENTIAL_NAME");
        this.excludeMap.put("DESTINATION", "DESTINATION");
        this.excludeMap.put("DESTINATION_OWNER", "DESTINATION_OWNER");
        this.excludeMap.put("ENABLED", "ENABLED");
        return this.excludeMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        if (object instanceof SchedulerFileWatcher) {
            SchedulerFileWatcher sched = (SchedulerFileWatcher)object;
            if (sched.isMinimumDefined()) {
                Map<String, String> excludeMap = this.getExcludeMap();
                StringBuffer buffer = new StringBuffer();
                SSBSchedulerFileWatcher.appendStringWithSpace(buffer, "BEGIN");
                SSBSchedulerFileWatcher.appendNewLine(buffer, prettyPrint, 1);
                SSBSchedulerFileWatcher.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.CREATE_FILE_WATCHER(");
                SSBSchedulerFileWatcher.appendObjectName(buffer, sched, prettyPrint);
                SSBSchedulerFileWatcher.appendDirectoryPath(buffer, sched, prettyPrint);
                SSBSchedulerFileWatcher.appendFileName(buffer, sched, prettyPrint);
                SSBSchedulerFileWatcher.appendCredential(buffer, sched, prettyPrint);
                SSBSchedulerFileWatcher.appendDestination(buffer, sched, prettyPrint);
                SSBSchedulerFileWatcher.appendNewLine(buffer, prettyPrint, 1);
                SSBSchedulerFileWatcher.appendStringWithSpace(buffer, ");");
                this.appendAtrtributes(buffer, sched, prettyPrint, excludeMap);
                SSBSchedulerFileWatcher.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerFileWatcher.appendEnable(buffer, sched, prettyPrint);
                SSBSchedulerFileWatcher.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerFileWatcher.appendString(buffer, "END");
                SSBSchedulerFileWatcher.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, "");
            } else {
                SSBSchedulerFileWatcher.appendStringWithSpace(oldbuffer, "invalid FileWatcher definitiion for " + String.valueOf(sched.getName() + "\n file watcher name, directory path, file name and credentials name should be defined"));
            }
        }
    }

    public static void appendObjectName(StringBuffer buffer, SchedulerObject obj, boolean prettyPrint) {
        SSBSchedulerFileWatcher.appendNewLine(buffer, prettyPrint, 2);
        SSBSchedulerFileWatcher.appendString(buffer, "file_watcher_name => '" + obj.getNameFormatted() + "'");
    }

    public static void appendFileName(StringBuffer buffer, SchedulerObject obj, boolean prettyPrint) {
        String type = obj.getProperty("FILE_NAME");
        if (type != null && !type.isEmpty()) {
            SSBSchedulerFileWatcher.appendString(buffer, ',');
            SSBSchedulerFileWatcher.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerFileWatcher.appendString(buffer, "file_name => '" + type + "'");
        }
    }

    public static void appendDirectoryPath(StringBuffer buffer, SchedulerObject obj, boolean prettyPrint) {
        String type = obj.getProperty("DIRECTORY_PATH");
        if (type != null && !type.isEmpty()) {
            SSBSchedulerFileWatcher.appendString(buffer, ',');
            SSBSchedulerFileWatcher.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerFileWatcher.appendString(buffer, "directory_path => '" + type + "'");
        }
    }

    public static void appendEnable(StringBuffer buffer, SchedulerObject job, boolean prettyPrint) {
        String res = job.getProperty("ENABLED");
        if (res != null && !res.isEmpty() && "TRUE".equalsIgnoreCase(res)) {
            String name = job.getNameFormatted();
            SSBSchedulerFileWatcher.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerFileWatcher.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.enable(name => '" + name + "');");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchedulerFileWatcher;
    }

    public static void appendDestination(StringBuffer buffer, SchedulerObject job, boolean prettyPrint) {
        String res = job.getDestinationNameFormatted();
        if (res != null && !res.isEmpty()) {
            SSBSchedulerFileWatcher.appendString(buffer, ',');
            SSBSchedulerFileWatcher.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerFileWatcher.appendString(buffer, "DESTINATION => '" + res + "'");
        }
    }
}

