/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.MethodParamProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.MethodProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StructuredTypeProxyOraclev10g;

public class SSBStructuredTypeBodyOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        StructuredTypeProxyOraclev10g typeProxy;
        if (object instanceof StructuredTypeProxyOraclev10g && (typeProxy = (StructuredTypeProxyOraclev10g)object).isMarkedGenerate() && !typeProxy.getStructuredType().isPredefined()) {
            this.appendCreateTypeBody(buffer, typeProxy, prettyPrint);
        }
    }

    private void appendCreateTypeBody(StringBuffer oldbuffer, StructuredTypeProxyOracle typeProxy, boolean prettyPrint) {
        if (this.hasPLSQLMethod(typeProxy)) {
            this.storageDesign = typeProxy.getStorageDesign();
            StringBuffer buffer = new StringBuffer();
            String advancedComment = "";
            SSBStructuredTypeBodyOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "CREATE");
            SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "OR");
            SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "REPLACE");
            SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "TYPE");
            SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "BODY");
            if (typeProxy.getOwner() != null && this.storageDesign.getDesign().getSettings().isIncludeSchemaInDDL()) {
                SSBStructuredTypeBodyOraclev10g.appendString(buffer, this.storageDesign.getFormatedName(typeProxy.getOwner()));
                SSBStructuredTypeBodyOraclev10g.appendString(buffer, '.');
            }
            SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeProxy));
            advancedComment = buffer.toString();
            SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "AS");
            for (MethodProxyOraclev10g method : typeProxy.getMethods()) {
                boolean isConstructor = "YES".equalsIgnoreCase(method.getConstructor());
                if (!isConstructor && "NO".equalsIgnoreCase(method.getInstantiable())) continue;
                SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                if (!isConstructor) {
                    if (typeProxy.getMapOrderFunction() == method) {
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, typeProxy.getMapOrderType());
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "MEMBER");
                    } else if ("YES".equalsIgnoreCase(method.getIsStatic())) {
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "STATIC");
                        if ("YES".equalsIgnoreCase(method.getIsFinal())) {
                            SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "FINAL");
                        }
                    } else {
                        if ("YES".equalsIgnoreCase(method.getOverriding())) {
                            SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "OVERRIDING");
                        }
                        if ("YES".equalsIgnoreCase(method.getIsFinal())) {
                            SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "FINAL");
                        }
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "MEMBER");
                    }
                    if ("PROCEDURE".equalsIgnoreCase(method.getMethodType())) {
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "PROCEDURE");
                    } else {
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "FUNCTION");
                    }
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(method));
                } else {
                    if ("YES".equalsIgnoreCase(method.getIsFinal())) {
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "FINAL");
                    }
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "CONSTRUCTOR");
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "FUNCTION");
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeProxy));
                }
                if (method.getParams().size() > 0 || "NO".equalsIgnoreCase(method.getCopySelf())) {
                    SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, '(');
                    SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    boolean first = true;
                    if ("NO".equalsIgnoreCase(method.getCopySelf()) && "NO".equalsIgnoreCase(method.getIsStatic())) {
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "SELF");
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "IN");
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "OUT");
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "NOCOPY");
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeProxy));
                        first = false;
                    }
                    for (MethodParamProxyOracle param : method.getParams()) {
                        if (first) {
                            first = false;
                        } else {
                            this.appendComma(buffer);
                            SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        }
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(param));
                        if (!"".equalsIgnoreCase(param.getDirectionType())) {
                            SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, param.getDirectionType());
                        }
                        if ("NO".equalsIgnoreCase(param.getCopyArgument())) {
                            SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "NOCOPY");
                        }
                        String datatype = this.getMethodParamDatatype((MethodParam)param.getObject());
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, datatype);
                        String defaultValue = param.getDefaultValue().trim();
                        if (defaultValue.length() <= 0) continue;
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
                        String df = this.addQuotesToDefault(datatype, defaultValue);
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, df);
                    }
                    SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, ')');
                }
                if (isConstructor) {
                    SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "RETURN");
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "SELF");
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "AS");
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "RESULT");
                } else {
                    MethodParam returnValue = ((Method)method.getObject()).getReturnValue();
                    if (returnValue != null) {
                        SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "RETURN");
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, this.getMethodParamDatatype(returnValue));
                    }
                }
                SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "AS");
                SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                if ("PL/SQL".equalsIgnoreCase(method.getImplLanguage())) {
                    if (!"".equalsIgnoreCase(method.getPLSQLBody().trim())) {
                        SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, method.getPLSQLBody());
                        continue;
                    }
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "-- Empty PL/SQL Body");
                    SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "BEGIN NULL; END;");
                    continue;
                }
                SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "LANGUAGE");
                if ("Java".equalsIgnoreCase(method.getImplLanguage())) {
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "JAVA");
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "NAME");
                    SSBStructuredTypeBodyOraclev10g.appendString(buffer, '\'');
                    SSBStructuredTypeBodyOraclev10g.appendString(buffer, method.getJavaName());
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, '\'');
                    continue;
                }
                if (!"C".equalsIgnoreCase(method.getImplLanguage())) continue;
                SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "C");
                if (!"".equalsIgnoreCase(method.getCName())) {
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "NAME");
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, method.getCName());
                }
                SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "LIBRARY");
                if ("".equalsIgnoreCase(method.getCLibrary())) {
                    SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "-- Empty library");
                } else {
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, method.getCLibrary());
                }
                if (!"".equalsIgnoreCase(method.getAgentArguments())) {
                    SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "AGENT");
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "IN");
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, '(');
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, method.getAgentArguments());
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, ')');
                }
                if ("YES".equalsIgnoreCase(method.getWithContext())) {
                    SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "WITH");
                    SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "CONTEXT");
                }
                if ("".equalsIgnoreCase(method.getCPartemeters())) continue;
                SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "PARAMETERS");
                SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, '(');
                SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, method.getCPartemeters());
                SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, ')');
            }
            SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeBodyOraclev10g.appendStringWithSpace(buffer, "END");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisherWithSlash(buffer, prettyPrint);
            SSBStructuredTypeBodyOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.incrementCreateStructuredTypeBody();
        }
    }

    private String getMethodParamDatatype(MethodParam methodParam) {
        Object datatype = null;
        DesignObject paramDataType = methodParam.getType();
        if (paramDataType instanceof StructuredType || paramDataType instanceof CollectionType) {
            RelationalObjectProxy proxy = this.storageDesign.getProxy(paramDataType);
            datatype = proxy != null ? this.storageDesign.getFormatedLongNameDDL(proxy) : this.storageDesign.getFormatedName(paramDataType);
            if (methodParam.isReference() && paramDataType instanceof StructuredType) {
                datatype = "REF " + (String)datatype;
            }
        } else {
            datatype = methodParam.getDataType(this.storageDesign.getRDBMSType().getName());
        }
        return datatype;
    }

    private boolean hasPLSQLMethod(StructuredTypeProxyOracle typeProxy) {
        for (MethodProxyOraclev10g method : typeProxy.getMethods()) {
            if (!"PL/SQL".equalsIgnoreCase(method.getImplLanguage()) || !"YES".equalsIgnoreCase(method.getInstantiable())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof StructuredTypeProxyOraclev10g;
    }
}

