/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasetools.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasetools.model.DatabaseToolsKeyStoreGenericJdbcDetails;
import com.oracle.bmc.databasetools.model.DatabaseToolsUserPasswordDetails;
import com.oracle.bmc.databasetools.model.UpdateDatabaseToolsConnectionDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class UpdateDatabaseToolsConnectionGenericJdbcDetails
extends UpdateDatabaseToolsConnectionDetails {
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="userPassword")
    private final DatabaseToolsUserPasswordDetails userPassword;
    @JsonProperty(value="advancedProperties")
    private final Map<String, String> advancedProperties;
    @JsonProperty(value="keyStores")
    private final List<DatabaseToolsKeyStoreGenericJdbcDetails> keyStores;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdateDatabaseToolsConnectionGenericJdbcDetails(String displayName, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags, String url, String userName, DatabaseToolsUserPasswordDetails userPassword, Map<String, String> advancedProperties, List<DatabaseToolsKeyStoreGenericJdbcDetails> keyStores) {
        super(displayName, definedTags, freeformTags);
        this.url = url;
        this.userName = userName;
        this.userPassword = userPassword;
        this.advancedProperties = advancedProperties;
        this.keyStores = keyStores;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public DatabaseToolsUserPasswordDetails getUserPassword() {
        return this.userPassword;
    }

    public Map<String, String> getAdvancedProperties() {
        return this.advancedProperties;
    }

    public List<DatabaseToolsKeyStoreGenericJdbcDetails> getKeyStores() {
        return this.keyStores;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateDatabaseToolsConnectionGenericJdbcDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", url=").append(String.valueOf(this.url));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", userPassword=").append(String.valueOf((Object)this.userPassword));
        sb.append(", advancedProperties=").append(String.valueOf(this.advancedProperties));
        sb.append(", keyStores=").append(String.valueOf(this.keyStores));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDatabaseToolsConnectionGenericJdbcDetails)) {
            return false;
        }
        UpdateDatabaseToolsConnectionGenericJdbcDetails other = (UpdateDatabaseToolsConnectionGenericJdbcDetails)((Object)o);
        return Objects.equals(this.url, other.url) && Objects.equals(this.userName, other.userName) && Objects.equals((Object)this.userPassword, (Object)other.userPassword) && Objects.equals(this.advancedProperties, other.advancedProperties) && Objects.equals(this.keyStores, other.keyStores) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.userPassword == null ? 43 : this.userPassword.hashCode());
        result = result * 59 + (this.advancedProperties == null ? 43 : this.advancedProperties.hashCode());
        result = result * 59 + (this.keyStores == null ? 43 : this.keyStores.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="userPassword")
        private DatabaseToolsUserPasswordDetails userPassword;
        @JsonProperty(value="advancedProperties")
        private Map<String, String> advancedProperties;
        @JsonProperty(value="keyStores")
        private List<DatabaseToolsKeyStoreGenericJdbcDetails> keyStores;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder userPassword(DatabaseToolsUserPasswordDetails userPassword) {
            this.userPassword = userPassword;
            this.__explicitlySet__.add("userPassword");
            return this;
        }

        public Builder advancedProperties(Map<String, String> advancedProperties) {
            this.advancedProperties = advancedProperties;
            this.__explicitlySet__.add("advancedProperties");
            return this;
        }

        public Builder keyStores(List<DatabaseToolsKeyStoreGenericJdbcDetails> keyStores) {
            this.keyStores = keyStores;
            this.__explicitlySet__.add("keyStores");
            return this;
        }

        public UpdateDatabaseToolsConnectionGenericJdbcDetails build() {
            UpdateDatabaseToolsConnectionGenericJdbcDetails model = new UpdateDatabaseToolsConnectionGenericJdbcDetails(this.displayName, this.definedTags, this.freeformTags, this.url, this.userName, this.userPassword, this.advancedProperties, this.keyStores);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateDatabaseToolsConnectionGenericJdbcDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("url")) {
                this.url(model.getUrl());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("userPassword")) {
                this.userPassword(model.getUserPassword());
            }
            if (model.wasPropertyExplicitlySet("advancedProperties")) {
                this.advancedProperties(model.getAdvancedProperties());
            }
            if (model.wasPropertyExplicitlySet("keyStores")) {
                this.keyStores(model.getKeyStores());
            }
            return this;
        }
    }
}

