/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasetools.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasetools.model.DatabaseToolsKeyStoreContent;
import com.oracle.bmc.databasetools.model.DatabaseToolsKeyStorePassword;
import com.oracle.bmc.databasetools.model.KeyStoreType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseToolsKeyStore
extends ExplicitlySetBmcModel {
    @JsonProperty(value="keyStoreType")
    private final KeyStoreType keyStoreType;
    @JsonProperty(value="keyStoreContent")
    private final DatabaseToolsKeyStoreContent keyStoreContent;
    @JsonProperty(value="keyStorePassword")
    private final DatabaseToolsKeyStorePassword keyStorePassword;

    @Deprecated
    @ConstructorProperties(value={"keyStoreType", "keyStoreContent", "keyStorePassword"})
    public DatabaseToolsKeyStore(KeyStoreType keyStoreType, DatabaseToolsKeyStoreContent keyStoreContent, DatabaseToolsKeyStorePassword keyStorePassword) {
        this.keyStoreType = keyStoreType;
        this.keyStoreContent = keyStoreContent;
        this.keyStorePassword = keyStorePassword;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public KeyStoreType getKeyStoreType() {
        return this.keyStoreType;
    }

    public DatabaseToolsKeyStoreContent getKeyStoreContent() {
        return this.keyStoreContent;
    }

    public DatabaseToolsKeyStorePassword getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseToolsKeyStore(");
        sb.append("super=").append(super.toString());
        sb.append("keyStoreType=").append(String.valueOf((Object)this.keyStoreType));
        sb.append(", keyStoreContent=").append(String.valueOf((Object)this.keyStoreContent));
        sb.append(", keyStorePassword=").append(String.valueOf((Object)this.keyStorePassword));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseToolsKeyStore)) {
            return false;
        }
        DatabaseToolsKeyStore other = (DatabaseToolsKeyStore)((Object)o);
        return Objects.equals((Object)this.keyStoreType, (Object)other.keyStoreType) && Objects.equals((Object)this.keyStoreContent, (Object)other.keyStoreContent) && Objects.equals((Object)this.keyStorePassword, (Object)other.keyStorePassword) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.keyStoreType == null ? 43 : this.keyStoreType.hashCode());
        result = result * 59 + (this.keyStoreContent == null ? 43 : this.keyStoreContent.hashCode());
        result = result * 59 + (this.keyStorePassword == null ? 43 : this.keyStorePassword.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="keyStoreType")
        private KeyStoreType keyStoreType;
        @JsonProperty(value="keyStoreContent")
        private DatabaseToolsKeyStoreContent keyStoreContent;
        @JsonProperty(value="keyStorePassword")
        private DatabaseToolsKeyStorePassword keyStorePassword;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder keyStoreType(KeyStoreType keyStoreType) {
            this.keyStoreType = keyStoreType;
            this.__explicitlySet__.add("keyStoreType");
            return this;
        }

        public Builder keyStoreContent(DatabaseToolsKeyStoreContent keyStoreContent) {
            this.keyStoreContent = keyStoreContent;
            this.__explicitlySet__.add("keyStoreContent");
            return this;
        }

        public Builder keyStorePassword(DatabaseToolsKeyStorePassword keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            this.__explicitlySet__.add("keyStorePassword");
            return this;
        }

        public DatabaseToolsKeyStore build() {
            DatabaseToolsKeyStore model = new DatabaseToolsKeyStore(this.keyStoreType, this.keyStoreContent, this.keyStorePassword);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseToolsKeyStore model) {
            if (model.wasPropertyExplicitlySet("keyStoreType")) {
                this.keyStoreType(model.getKeyStoreType());
            }
            if (model.wasPropertyExplicitlySet("keyStoreContent")) {
                this.keyStoreContent(model.getKeyStoreContent());
            }
            if (model.wasPropertyExplicitlySet("keyStorePassword")) {
                this.keyStorePassword(model.getKeyStorePassword());
            }
            return this;
        }
    }
}

