/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mcp.transport;

import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.transport.StdioServerTransportProvider;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Consumer;
import oracle.dbtools.mcp.transport.BidirectionalPipe;
import oracle.dbtools.mcp.transport.ObjectMappers;
import oracle.dbtools.mcp.transport.StreamClientTransport;

public class McpRig
implements AutoCloseable {
    private final McpSchema.Implementation RIG = new McpSchema.Implementation("rig", "1.0.0");
    private final McpServerTransportProvider serverTransport;
    private final McpClientTransport clientTransport;
    private final McpSyncServer server;
    private final McpSyncClient client;

    private McpRig(McpServerTransportProvider serverTransport, McpClientTransport clientTransport, McpSyncServer server, McpSyncClient client) {
        this.serverTransport = serverTransport;
        this.clientTransport = clientTransport;
        this.server = server;
        this.client = client;
    }

    public static McpRig of() {
        try {
            return McpRig.of(BidirectionalPipe.open());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static McpRig of(BidirectionalPipe pipe) {
        return new McpRig((McpServerTransportProvider)new StdioServerTransportProvider(ObjectMappers.defaultMapper(), pipe.server().input(), pipe.server().output()), new StreamClientTransport(ObjectMappers.defaultMapper(), pipe.client().input(), pipe.client().output()), null, null);
    }

    public McpServerTransportProvider serverTransport() {
        return this.serverTransport;
    }

    public McpClientTransport clientTransport() {
        return this.clientTransport;
    }

    public McpRig withClient() {
        return this.withClient(spec -> spec.clientInfo(this.RIG));
    }

    public McpRig withClient(Consumer<McpClient.SyncSpec> configuration) {
        if (this.client == null) {
            McpClient.SyncSpec spec = McpClient.sync((McpClientTransport)this.clientTransport);
            configuration.accept(spec);
            McpSyncClient client = spec.build();
            return new McpRig(this.serverTransport, this.clientTransport, this.server, client);
        }
        return this;
    }

    public McpRig withServer() {
        return this.withServer(spec -> spec.serverInfo(this.RIG));
    }

    public McpRig withServer(Consumer<McpServer.SyncSpecification> configuration) {
        if (this.server == null) {
            McpServer.SyncSpecification spec = McpServer.sync((McpServerTransportProvider)this.serverTransport);
            configuration.accept(spec);
            McpSyncServer server = spec.build();
            return new McpRig(this.serverTransport, this.clientTransport, server, this.client);
        }
        return this;
    }

    public McpSyncClient client() {
        if (this.client == null) {
            throw new IllegalStateException("client not configured, call #withClient()");
        }
        return this.client;
    }

    public McpSyncServer server() {
        if (this.server == null) {
            throw new IllegalStateException("server not configured, call #withServer()");
        }
        return this.server;
    }

    @Override
    public void close() {
        this.clientTransport.close();
        this.serverTransport.close();
    }
}

