/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mcp.container;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.transport.StdioServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.SQLCLServices;
import oracle.dbtools.mcp.api.Mcp;
import oracle.dbtools.mcp.container.McpContainer;
import oracle.dbtools.mcp.container.Services;

public class McpStdioContainer
implements Mcp.Stdio {
    private final Mcp.Container delegate;

    private McpStdioContainer(Builder builder) {
        Logger.getLogger("io.modelcontextprotocol.server.transport.StdioServerTransportProvider").setLevel(Level.OFF);
        System.err.println("---------- MCP SERVER STARTUP ----------");
        System.err.println("MCP Server started successfully on " + String.valueOf(new Date()));
        System.err.println("Press Ctrl+C to stop the server");
        System.err.println("----------------------------------------");
        SQLCLServices.getInstance().registerServices();
        StdioServerTransportProvider transportProvider = new StdioServerTransportProvider(builder.find(ObjectMapper.class).orElseGet(ObjectMapper::new), builder.input(), builder.output());
        Runnable onClose = () -> builder.onClose().forEach(Runnable::run);
        this.delegate = McpContainer.builder(builder::find, (McpServerTransportProvider)transportProvider).onClose(onClose).register(this::configureServer).loadFeatures().build();
    }

    private void configureServer(Mcp.Definition definition) {
        definition.specification().serverInfo("sqlcl-mcp-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(true)).tools(Boolean.valueOf(true)).prompts(Boolean.valueOf(true)).logging().build());
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public static class Builder
    extends Mcp.Stdio.Builder {
        private final Services services = Services.of();

        private Builder() {
        }

        @Override
        public <T> Builder set(Class<T> serviceType, T service) {
            this.services.set(serviceType, service);
            return this;
        }

        @Override
        protected McpStdioContainer newContainer() {
            return new McpStdioContainer(this);
        }

        @Override
        public <T> Optional<T> find(Class<T> service) {
            return this.services.find(service);
        }
    }
}

