/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mcp.background;

import java.io.IOException;
import java.nio.file.Files;
import java.sql.Connection;
import java.util.List;
import java.util.Optional;
import oracle.dbtools.mcp.McpMessages;
import oracle.dbtools.mcp.background.JobsAction;
import oracle.dbtools.raptor.backgroundTask.command.CommandTask;
import oracle.dbtools.raptor.backgroundTask.jobs.JobCancelException;
import oracle.dbtools.raptor.backgroundTask.jobs.JobNotFoundException;
import oracle.dbtools.raptor.backgroundTask.jobs.JobsProcessor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class JobsHandler {
    public JobActionResult<?> handle(int jobId, JobsAction action) {
        Optional<JobsProcessor.Job> jobOpt = JobsProcessor.list().stream().filter(j -> j.getId() == jobId).findFirst();
        if (jobOpt.isEmpty()) {
            return JobActionResult.failure(McpMessages.format("NO_JOBS_FOUND_WITH_ID", jobId));
        }
        JobsProcessor.Job job = jobOpt.get();
        switch (action) {
            case STATUS: {
                return JobActionResult.success(McpMessages.getString("JOB_STATUS_RETRIEVED"), job.getTask().getStatus().value());
            }
            case CANCEL: {
                try {
                    JobsProcessor.cancel((int)jobId);
                    return JobActionResult.success(McpMessages.getString("JOB_CENCELED"), null);
                }
                catch (JobCancelException | JobNotFoundException e) {
                    return JobActionResult.failure(e.getMessage());
                }
            }
            case RESULTS: {
                try {
                    CommandTask task = (CommandTask)job.getTask();
                    String result = Files.readString(task.getLog().toPath());
                    return JobActionResult.success(McpMessages.getString("RESULT_RETRIEVED"), result);
                }
                catch (IOException e) {
                    return JobActionResult.failure(McpMessages.format("ERROR_RETRIEVING_JOB_RESULT", e.getMessage()));
                }
            }
        }
        return JobActionResult.failure(McpMessages.getString("UNSUPPORTED_ACTION"));
    }

    public JobActionResult<JobsProcessor.Job> submitTask(Task task) {
        ScriptRunnerContext ctx = task.ctx();
        Connection connection = ctx.getCurrentConnection();
        JobsProcessor.init((ScriptRunnerContext)ctx);
        JobsProcessor.Job job = JobsProcessor.run((ScriptRunnerContext)ctx, (Connection)connection, null, (String)task.cmToRun(), (String)task.taskName(), task.wiat4());
        return JobActionResult.success(McpMessages.format("COMMAND_SET_IN_BACKGROUND", job.getId()), job);
    }

    public record JobActionResult<T>(boolean isSuccess, String message, T result) {
        public static <T> JobActionResult<T> success(String message, T payload) {
            return new JobActionResult<T>(true, message, payload);
        }

        public static <T> JobActionResult<T> failure(String message) {
            return new JobActionResult<Object>(false, message, null);
        }
    }

    public record Task(ScriptRunnerContext ctx, String cmToRun, String taskName, List<String> wiat4) {
        public Task(ScriptRunnerContext ctx, String cmdToRun) {
            this(ctx, cmdToRun, null, null);
        }

        public Task(ScriptRunnerContext ctx, String cmdToRun, String taskName) {
            this(ctx, cmdToRun, taskName, null);
        }
    }
}

