/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.utils;

import java.util.Arrays;
import oracle.dbtools.core.connections.ConnectionException;
import oracle.dbtools.core.oci.DatabaseDetails;
import oracle.dbtools.extension.mcp.utils.ConnectionDetailsFactory;
import oracle.dbtools.extension.mcp.utils.ConnectionType;
import oracle.dbtools.extension.mcp.utils.ConnectionUtils;

public interface ConnectionFilter {
    public static final ConnectionFilter DEFAULT_FILTER = connection -> true;

    public static ConnectionFilter createFilterChain(ConnectionFilter ... filter) {
        return filter == null || filter.length == 0 ? DEFAULT_FILTER : (filter.length == 1 ? filter[0] : CompositeFilter.of(filter[0], ConnectionFilter.createFilterChain(Arrays.copyOfRange(filter, 1, filter.length))));
    }

    public boolean match(ConnectionDetailsFactory.ConnectionDetails var1);

    public static final class CompositeFilter
    implements ConnectionFilter {
        private final ConnectionFilter first;
        private final ConnectionFilter second;

        static CompositeFilter of(ConnectionFilter a, ConnectionFilter b) {
            return new CompositeFilter(a, b);
        }

        private CompositeFilter(ConnectionFilter first, ConnectionFilter second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public boolean match(ConnectionDetailsFactory.ConnectionDetails connection) {
            return this.first.match(connection) && this.second.match(connection);
        }
    }

    public static final class UserFilter
    implements ConnectionFilter {
        private final String username;

        public static UserFilter of(String user) {
            return new UserFilter(user);
        }

        private UserFilter(String username) {
            this.username = username;
        }

        @Override
        public boolean match(ConnectionDetailsFactory.ConnectionDetails connection) {
            String connType;
            boolean match = false;
            String string = connType = connection != null ? connection.getConnectionProperty("type") : null;
            if ("ORACLE_BASIC".equals(connType) || "ORACLE_DATABASE".equals(connType)) {
                String username = connection.getConnectionProperty("userName");
                match = this.username.equalsIgnoreCase(username);
            } else if ("OCI_DBTOOLS".equals(connType)) {
                try {
                    DatabaseDetails details = ConnectionUtils.getConnectionDetails(connection);
                    match = this.username.equalsIgnoreCase(details.getUserName());
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
            }
            return match;
        }
    }

    public static final class ConnectionTypeFilter
    implements ConnectionFilter {
        private final ConnectionType type;

        public static ConnectionTypeFilter of(ConnectionType type) {
            return new ConnectionTypeFilter(type);
        }

        private ConnectionTypeFilter(ConnectionType type) {
            this.type = type;
        }

        @Override
        public boolean match(ConnectionDetailsFactory.ConnectionDetails connection) {
            String connectionType = connection.getConnectionProperty("type");
            return connectionType != null && this.type.matches(connectionType);
        }
    }

    public static final class NameFilter
    implements ConnectionFilter {
        private final String name;

        public static NameFilter of(String name) {
            return new NameFilter(name);
        }

        private NameFilter(String name) {
            this.name = name.toLowerCase();
        }

        @Override
        public boolean match(ConnectionDetailsFactory.ConnectionDetails connection) {
            String connectionName = connection.getConnectionName();
            return connectionName != null && connectionName.toLowerCase().contains(this.name);
        }
    }
}

