/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.Collections;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.extension.mcp.exceptions.AuditTableException;
import oracle.dbtools.extension.mcp.exceptions.UnAuthorizedActionException;
import oracle.dbtools.extension.mcp.schemas.Schemas;
import oracle.dbtools.extension.mcp.utils.McpUtils;
import oracle.dbtools.mcp.McpMessages;
import oracle.dbtools.mcp.api.Mcp;
import oracle.dbtools.mcp.background.JobsAction;
import oracle.dbtools.mcp.background.JobsHandler;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.ParsedSql;
import oracle.dbtools.raptor.backgroundTask.jobs.JobsProcessor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class RunSqlAsyncTool
implements Mcp.Feature {
    public static final String NAME = "run-sql-async";
    public static final String DESCRIPTION = "This tool provides a way to execute sql queries in the background as asynchronous tasks, it allows also to manage the submitted tasks, by checking status, canceling and retrieving the resultsNote: This tool requires a database connection.";

    @Override
    public void configure(Mcp.Definition definition) {
        McpServer.SyncSpecification specification = definition.specification();
        McpSchema.Tool tool = new McpSchema.Tool(NAME, DESCRIPTION, Schemas.getSchema(Schemas.SchemaName.RUN_SQL_ASYNC_SCHEMA));
        specification.tool(tool, (exchange, args) -> {
            ArrayList<McpSchema.TextContent> contents;
            block10: {
                contents = new ArrayList<McpSchema.TextContent>();
                try {
                    ParsedSql parsed;
                    ParseNode root;
                    ScriptRunnerContext ctx = definition.find(ScriptRunnerContext.class).orElseGet(ScriptRunnerContext::new);
                    String model = McpUtils.optionalArgument(args, "model", McpUtils.MODEL_DEFAULT_VALUE);
                    String task = McpUtils.requiredArgument(args, "task");
                    String command = McpUtils.requiredArgument(args, "command");
                    String mcpClientName = exchange.getClientInfo().name();
                    if (null == ctx.getCurrentConnection()) {
                        throw new McpError((Object)McpMessages.getString("NOT_CONNECTED"));
                    }
                    ctx.putProperty("sql.format", (Object)McpUtils.MCP_RETURN_FORMAT);
                    String injectedComment = "/* LLM in use is " + McpUtils.sanitizeSqlComments(model) + " */";
                    String sanitizedQuery = McpUtils.injectAfterFirstWord(task, injectedComment);
                    if (sanitizedQuery.toUpperCase().contains("DBTOOLS$MCP_LOG") && !(root = (parsed = new ParsedSql(sanitizedQuery)).getRoot()).contains("select")) {
                        throw new UnAuthorizedActionException(McpMessages.format("ONLY_SELECT_ALLOWED", "DBTOOLS$MCP_LOG"));
                    }
                    JobsAction action = JobsAction.valueOfIgnoreCase(command);
                    JobsHandler handler = new JobsHandler();
                    if (action.equals((Object)JobsAction.SUBMIT)) {
                        try {
                            McpUtils.mcpLogs(ctx, NAME, model, mcpClientName, McpUtils.McpCapabilities.TOOL, SqlRecognizer.reductPwd((String)sanitizedQuery));
                        }
                        catch (AuditTableException e) {
                            contents.add(new McpSchema.TextContent(e.getLocalizedMessage()));
                        }
                        JobsHandler.JobActionResult<JobsProcessor.Job> result = handler.submitTask(new JobsHandler.Task(ctx, task));
                        contents.add(new McpSchema.TextContent(result.message()));
                        break block10;
                    }
                    JobsAction jobAction = JobsAction.valueOfIgnoreCase(command);
                    int jobId = Integer.parseInt(task);
                    McpUtils.mcpLogs(ctx, NAME, model, mcpClientName, McpUtils.McpCapabilities.TOOL, McpMessages.format("JOB_LOG_MESSAGE", jobAction.displayName(), jobId));
                    JobsHandler.JobActionResult<?> result = handler.handle(jobId, jobAction);
                    if (result.isSuccess()) {
                        contents.add(new McpSchema.TextContent(result.result().toString()));
                    } else {
                        contents.add(new McpSchema.TextContent(result.message()));
                    }
                }
                catch (NumberFormatException e) {
                    return new McpSchema.CallToolResult(Collections.singletonList(new McpSchema.TextContent(McpMessages.format("MCP_ERROR", "Invalid job ID format " + e.getLocalizedMessage()))), Boolean.valueOf(true));
                }
                catch (Exception e) {
                    return new McpSchema.CallToolResult(Collections.singletonList(new McpSchema.TextContent(McpMessages.format("MCP_ERROR", e.getLocalizedMessage()))), Boolean.valueOf(true));
                }
            }
            return new McpSchema.CallToolResult(contents, Boolean.valueOf(false));
        });
    }
}

