/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.core.connections.util.ConnectionsSupport;
import oracle.dbtools.db.ConnectionDetails;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.ConnectionStoreBridge;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.extension.mcp.exceptions.ArgumentException;
import oracle.dbtools.extension.mcp.exceptions.AuditTableException;
import oracle.dbtools.extension.mcp.schemas.Schemas;
import oracle.dbtools.extension.mcp.tools.McpTool;
import oracle.dbtools.extension.mcp.utils.McpUtils;
import oracle.dbtools.extension.mcp.utils.QueryUtils;
import oracle.dbtools.mcp.McpMessages;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NamedConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NamedConnectionsConnectorType;

public class ConnectTool
implements McpTool {
    private final String toolName = "connect";

    @Override
    public McpServerFeatures.SyncToolSpecification create(ScriptRunnerContext ctx) {
        return new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool("connect", "Provides an interface to connect to a specified database. If a database connection is already active, prompt the user for confirmation before switching to the new connection. If no connection exists, list the available schemas for selection.\nthe connection name is case sensitive\nNote: If the provided connection is invalid or does not match any saved connection, display instructions to the user on how to create a named connection in SQLcl\n" + McpUtils.MCP_FIXED_ARGS_PROMPT, Schemas.getSchema(Schemas.SchemaName.CONNECTION_SCHEMA)), (exchange, arguments) -> {
            ArrayList<McpSchema.TextContent> contents = new ArrayList<McpSchema.TextContent>();
            try {
                String savedConnectionName = McpUtils.requiredArgument(arguments, "connection_name");
                String model = McpUtils.optionalArgument(arguments, "model", McpUtils.MODEL_DEFAULT_VALUE);
                String mcp_client = exchange.getClientInfo().name();
                ConnectionsSupport support = ConnectionsSupport.builder().productProperty("v$session.program", McpUtils.PRODUCT_NAME).build();
                this.registerConnectionForResolver(support, ctx, savedConnectionName);
                if (ctx.getCurrentConnection() != null) {
                    McpUtils.mcpLogs(ctx, "connect", model, mcp_client, McpUtils.McpCapabilities.TOOL, McpMessages.format("CONNECT_LOG_MESSAGE", ctx.getCurrentConnection().getSchema()));
                    contents.add(new McpSchema.TextContent("### DATABASE CONNECTION ESTABLISHED ###\nSuccessfully connected to: **" + String.valueOf(arguments.get("connection_name")) + "**"));
                    contents.add(new McpSchema.TextContent("\n### DATABASE ENVIRONMENT CONTEXT ###\n"));
                    Version oracleVersion = VersionTracker.getDbVersion((ConnectionIdentifier)DefaultConnectionIdentifier.createIdentifier((Connection)ctx.getCurrentConnection()));
                    contents.add(new McpSchema.TextContent("**1. Oracle Database Version:** \n" + String.valueOf(oracleVersion)));
                    contents.add(new McpSchema.TextContent("**2. Access Mode:** \nThe Oracle database is currently in '" + QueryUtils.getOpenMode(ctx.getCurrentConnection()) + "' mode"));
                    contents.add(new McpSchema.TextContent("**3. NLS Parameters:** \nThe current Oracle database uses the following NLS configuration:\nDatabase character set:" + QueryUtils.getCharacterSet(ctx.getCurrentConnection()) + "\n Full NLS parameters: \n" + QueryUtils.getNlsParams(ctx.getCurrentConnection()) + "\n This is important for correctly interpreting data formats, encodings, and locale-specific behavior.\n"));
                    contents.add(new McpSchema.TextContent("Here\u2019s the Oracle database context you need: version, open mode, and NLS parameters. Use this information to run the following queries accurately and ensure they align with the database\u2019s current environment and settings."));
                } else {
                    contents.add(new McpSchema.TextContent(McpMessages.format("USER_NOT_CONNECTED", arguments.get("connection_name"))));
                }
            }
            catch (SQLException | ArgumentException | AuditTableException e) {
                return new McpSchema.CallToolResult(Collections.singletonList(new McpSchema.TextContent(McpMessages.format("MCP_ERROR", ((Throwable)e).getLocalizedMessage()))), Boolean.valueOf(true));
            }
            return new McpSchema.CallToolResult(contents, Boolean.valueOf(false));
        });
    }

    private void registerConnectionForResolver(ConnectionsSupport support, ScriptRunnerContext ctx, String connectionName) throws SQLException {
        Connection connection = support.openConnection(connectionName);
        ConnectionStoreBridge connResolver = ConnectionStoreBridge.getBridge((ScriptRunnerContext)ctx);
        ConnectionDetails connectionDetails = new ConnectionDetails(connection.getMetaData().getURL());
        connectionDetails.setConn(connection);
        connResolver.addConnection(connectionDetails);
        ctx.setCurrentConnection(connection);
        ctx.putProperty("cli.conn.name", (Object)connection.getMetaData().getURL());
        ConnectionContext connectionContext = (ConnectionContext)ctx.getService(ConnectionContext.class);
        connectionContext.setCurrentConnectionSpec("");
        NamedConnectionsConnectorType namedConnectionsConnectorType = new NamedConnectionsConnectorType();
        connectionContext.setCurrentConnectorType((ConnectorType)namedConnectionsConnectorType);
        String connCmd = "connect -name " + connectionName;
        SQLCommand currentConnCmd = new SQLCommand(connCmd);
        currentConnCmd.setSql(connCmd);
        currentConnCmd.setModifiedSQL(connCmd);
        connectionContext.setCurrentCommand((ISQLCommand)currentConnCmd);
        connectionContext.getCurrentPropertyValues().setValueOf((Property)NamedConnectionProperty.NAME, (Object)connectionName);
    }
}

