/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.schemas;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.mcp.McpMessages;

public class Schemas {
    private static final String SCHEMAS_RESOURCE = "oracle/dbtools/mcp/schemas.json";
    private static Map<String, String> schemas;

    public static synchronized void init() {
        schemas = Schemas.loadSchemas();
    }

    private static Map<String, String> loadSchemas() {
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> result = new HashMap<String, String>();
        try (InputStream inputStream = Schemas.class.getClassLoader().getResourceAsStream(SCHEMAS_RESOURCE);){
            if (inputStream == null) {
                throw new FileNotFoundException(McpMessages.format("RESOURCE_NOT_FOUND_EXCEPTION", SCHEMAS_RESOURCE));
            }
            JsonNode root = mapper.readTree(inputStream);
            root.fields().forEachRemaining(entry -> {
                try {
                    result.put((String)entry.getKey(), mapper.writeValueAsString(entry.getValue()));
                }
                catch (JsonProcessingException e) {
                    throw new IllegalStateException(McpMessages.format("FAILED_TO_PROCESS_SCHEMA_EXCEPTION", entry.getKey()), e);
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(McpMessages.format("FAILED_TO_LOAD_SCHEMA_EXCEPTION", SCHEMAS_RESOURCE), e);
        }
        return result;
    }

    public static String getSchema(SchemaName name) {
        String schema;
        if (schemas == null) {
            Schemas.init();
        }
        if ((schema = schemas.get(name.name())) == null) {
            throw new IllegalArgumentException(McpMessages.format("SCHEMA_NOT_FOUND_EXCEPTION", new Object[]{name}));
        }
        return schema;
    }

    public static enum SchemaName {
        CONNECTION_SCHEMA,
        RUN_SQL_ASYNC_SCHEMA,
        RUN_SQL_SCHEMA,
        RUN_SQL_CL_SCHEMA,
        DISCONNECT_SCHEMA,
        LIST_CONNECTIONS_SCHEMA,
        SCHEMA_INFORMATION_SCHEMA,
        SHOW_CONNECTION_SCHEMA;

    }
}

