/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.apexlang.core.APEXLangCompilerContext;
import oracle.apexlang.core.APEXLangManifest;
import oracle.apexlang.core.APEXLangSyntaxError;
import oracle.apexlang.core.Component;

public class Transpiler {
    public static final String PLSQL_PLACEHOLDER_PARAMETERS = "%parameters%";
    public static final String PLSQL_PLACEHOLDER_VALUE = ":value";
    public static final String PLSQL_PLACEHOLDER_PARENT_EXTERNAL_IDENTIFICATION = ":parent_identifier";
    public static final String PLSQL_PLACEHOLDER_GRAND_PARENT_EXTERNAL_IDENTIFICATION = ":grandparent_identifier";
    public static final String PLSQL_PLACEHOLDER_GREAT_GRAND_PARENT_EXTERNAL_IDENTIFICATION = ":great_grandparent_identifier";
    public static final String PLSQL_PLACEHOLDER_GREAT_GREAT_GRAND_PARENT_EXTERNAL_IDENTIFICATION = ":great_great_grandparent_identifier";
    public static final String PLSQL_PLACEHOLDER_IS_CENTRAL = ":is_central";
    public static final String PLSQL_PLACEHOLDER_REF_APP_ID = ":ref_app_id";
    public static final String PLSQL_PLACEHOLDER_IS_NOT = ":is_not";
    public static final String PLSQL_PLACEHOLDER_EXTERNAL_IDENTIFIER = ":external_identifier";
    public static final String PLSQL_PLACEHOLDER_API_VERSION = ":api_version";
    public static final String PLSQL_PLACEHOLDER_APEX_VERSION = ":apex_version";
    public static final String PLSQL_PLACEHOLDER_WORKSPACE_ID = ":workspace_id";
    public static final String PLSQL_PLACEHOLDER_APP_ID = ":app_id";
    public static final String PLSQL_PLACEHOLDER_DEFAULT_ID_OFFSET = ":default_id_offset";
    public static final String PLSQL_PLACEHOLDER_DEFAULT_OWNER = ":default_owner";
    public static final String PLSQL_PLACEHOLDER_CENTRAL_THEME_APP_ID = ":central_theme_app_id";
    public static final String PLSQL_PLACEHOLDER_CURRENT_THEME_ID = ":current_theme_id";
    public static final String PLSQL_PLACEHOLDER_PLUGIN_ATTR_EXPRESSION = ":plugin_attribute_expression";
    public static final String PLSQL_PLACEHOLDER_PLUGIN_ATTR_STATIC_ID = ":plugin_attribute_static_id";
    public static final String PLSQL_PLACEHOLDER_EXT_FILE_VARIABLE = "wwv_flow_imp.g_varchar2_table := wwv_flow_imp.empty_varchar2_table; \n";
    public static final String PLSQL_PLACEHOLDER_EXT_FILE_VARIABLE_HEX_VALUE = ":hexValue";
    public static final String PLSQL_PLACEHOLDER_EXT_FILE_VARIABLE_INDEX_VALUE = ":index";
    public static final String PLSQL_PLACEHOLDER_EXT_FILE_VARIABLE_VALUE = "wwv_flow_imp.g_varchar2_table(:index) := ':hexValue';\n";
    public static final String PLSQL_PLACEHOLDER_EXT_FILE_PARAM_VALUE = "wwv_flow_imp.varchar2_to_blob(wwv_flow_imp.g_varchar2_table)";
    public static final String PLSQL_PLACEHOLDER_PLUGIN_EXT_IDENTIFIER = ":plugin_external_identifier";
    public static final String PLSQL_PLACEHOLDER_TODATE_DATE_VALUE = ":dateValue";
    public static final String PLSQL_PLACEHOLDER_TODATE_FORMAT = "to_date(':dateValue', 'YYYY-MM-DD\"T\"HH24:MI:SS')";
    static final String COMPONENT_ID_APPLICATION = "1000";
    private static final String IMPORT_ERROR_MARKER = "<<IMPORT-ERROR>>";
    private static final String IMPORT_ERROR_CODE = "-20999";
    private static final String IMPORT_ERROR_ORA_CODE = "ORA-20999";
    private static final Integer maxAnonBlockSize = 2500000;
    private static final ThreadLocal<Integer> maxAnonBlockSizeOverride = new ThreadLocal();

    public static String replaceAllSafely(String template, String bindVariable, String replacement) {
        String result = String.join((CharSequence)replacement, (template + " ").split(bindVariable));
        return result.substring(0, result.length() - 1);
    }

    public static String transpile(List<Component> componentsParsed, String generatedSQLArtifiacts, APEXLangManifest manifest, APEXLangCompilerContext appCtx) {
        String post;
        String centralThemeAppId = appCtx.getCentralThemeAppId() != null && !appCtx.getCentralThemeAppId().equals("") ? appCtx.getCentralThemeAppId() : "null";
        String currentThemeId = appCtx.getCurrentTheme();
        Integer maxSize = maxAnonBlockSizeOverride.get();
        if (maxSize == null) {
            maxSize = maxAnonBlockSize;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("set define off verify off feedback off\n");
        stringBuilder.append("whenever sqlerror exit sql.sqlcode rollback\n");
        Integer anonBlockStart = stringBuilder.length();
        Transpiler.addAnonBlockBegin(stringBuilder);
        boolean anyAdded = false;
        String pre = manifest.getImportPlSQL(centralThemeAppId);
        if (pre != null && pre.trim().length() > 0) {
            stringBuilder.append("l_source := '").append(manifest.getFileName()).append(":1:0:{';\n").append(pre).append("\n");
            anyAdded = true;
        }
        Iterator<Component> componentsValues = Transpiler.sortedComponents(componentsParsed).iterator();
        while (componentsValues.hasNext()) {
            if (stringBuilder.length() > anonBlockStart + maxSize && anyAdded) {
                Transpiler.addAnonBlockEnd(stringBuilder);
                anonBlockStart = stringBuilder.length();
                Transpiler.addAnonBlockBegin(stringBuilder);
            }
            Component currentComponent = componentsValues.next();
            Transpiler.addComponentAPICall(currentComponent, stringBuilder);
            anyAdded = true;
        }
        Transpiler.addAnonBlockEnd(stringBuilder);
        if (!generatedSQLArtifiacts.isBlank()) {
            stringBuilder.append("\n").append(generatedSQLArtifiacts);
        }
        if ((post = manifest.getEndPlSQL()) != null && post.trim().length() > 0) {
            stringBuilder.append("\nbegin\n").append(post).append("\nend;\n/\n");
        }
        stringBuilder.append("\nset verify on feedback on define on\n");
        return Transpiler.replaceAllSafely(stringBuilder.toString(), PLSQL_PLACEHOLDER_CURRENT_THEME_ID, "'" + currentThemeId + "'");
    }

    private static void addAnonBlockBegin(StringBuilder stringBuilder) {
        stringBuilder.append("declare\n").append("l_source varchar2(4000);\n").append("begin\n");
    }

    private static void addAnonBlockEnd(StringBuilder stringBuilder) {
        stringBuilder.append("exception\n").append("  when others then\n").append("    declare\n").append("        l_error varchar2(32000);\n").append("        l_stack varchar2(32000);\n").append("        l_start pls_integer;\n").append("        l_end pls_integer;\n").append("    begin\n").append("        l_error := '{'||chr(10);\n").append("        if l_source is not null then\n").append("            l_error := l_error || regexp_replace(l_source, '([^:]*):([^:]*):([^:]*):(.*)',\n").append("                '\"filename\":\"\\1\",\"line\":\\2,\"column\":\\3,\"token\":\"\\4\",') || chr(10);\n").append("        end if;\n").append("        l_error := l_error||'\"error\":\"'||apex_escape.json(sqlerrm)||'\",'||chr(10);\n").append("        l_error := l_error||'\"stack\":[';\n").append("        l_stack := dbms_utility.format_error_backtrace;\n").append("        l_start := 1;\n").append("        while l_start < length(l_stack) loop\n").append("            l_end := instr(l_stack, chr(10), l_start);\n").append("            if (l_end > 0) then\n").append("                if l_start > 1 then\n").append("                    l_error := l_error || ',';\n").append("                end if;\n").append("                l_error := l_error || chr(10) || '  \"'||apex_escape.json(substr(l_stack,l_start, l_end - l_start)) || '\"';\n").append("                l_start := l_end + 1;\n").append("            else\n").append("                exit;\n").append("            end if;\n").append("        end loop;\n").append("        l_error := l_error||chr(10)||']}';\n").append("        raise_application_error(").append(IMPORT_ERROR_CODE).append(",'").append(IMPORT_ERROR_MARKER).append("'||l_error||'").append(IMPORT_ERROR_MARKER).append("');\n").append("    end;\n").append("end;\n").append("/\n");
    }

    private static void addComponentAPICall(Component component, StringBuilder stringBuilder) {
        stringBuilder.append("l_source := ");
        if (component.getFilename() != null) {
            stringBuilder.append("'").append(component.getFilename()).append(":").append(component.getLine()).append(":").append(component.getColumn()).append(":").append(component.getName()).append("'");
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append(";\n");
        stringBuilder.append(component.generatePlSQLCode());
    }

    public static void setMaxAnonBlockSize(Integer max) {
        maxAnonBlockSizeOverride.set(max);
    }

    public static APEXLangSyntaxError parsePLSQLError(String output) {
        if (output != null) {
            int start = output.indexOf(IMPORT_ERROR_MARKER);
            if (start >= 0) {
                int end;
                if ((start += IMPORT_ERROR_MARKER.length()) < output.length() && (end = output.indexOf(IMPORT_ERROR_MARKER, start)) > start) {
                    Map map;
                    ObjectMapper mapper = new ObjectMapper();
                    try {
                        map = (Map)mapper.readValue(output.substring(start, end).trim(), HashMap.class);
                    }
                    catch (JsonProcessingException e) {
                        map = null;
                    }
                    if (map != null) {
                        String filename = "";
                        Integer line = 1;
                        Integer column = 0;
                        String token = "";
                        String error = "";
                        if (map.get("filename") instanceof String) {
                            filename = (String)map.get("filename");
                        }
                        if (map.get("line") instanceof Integer) {
                            line = (Integer)map.get("line");
                        }
                        if (map.get("column") instanceof Integer) {
                            column = (Integer)map.get("column");
                        }
                        if (map.get("token") instanceof String) {
                            token = (String)map.get("token");
                        }
                        if (map.get("error") instanceof String) {
                            error = (String)map.get("error");
                        }
                        return new APEXLangSyntaxError(line, column, error, column, token, 0, 0, filename, APEXLangSyntaxError.ErrorType.PLSQL_ERROR, null);
                    }
                }
            } else {
                int end;
                start = output.indexOf("ORA-");
                if (start >= 0 && (end = output.indexOf("\n", start)) > start) {
                    return new APEXLangSyntaxError(1, 0, output.substring(start, end), 0, "", 0, 0, "", APEXLangSyntaxError.ErrorType.PLSQL_ERROR, null);
                }
            }
        }
        return null;
    }

    public static Collection<Component> sortedComponents(Collection<Component> components) {
        HashMap<Component, List<Component>> nodeComponentMap = new HashMap<Component, List<Component>>();
        for (Component component : components) {
            Component parent = component.getParent();
            if (nodeComponentMap.get(parent) == null) {
                nodeComponentMap.put(parent, new ArrayList());
            }
            ((List)nodeComponentMap.get(parent)).add(component);
        }
        ArrayList<Component> sortedComponents = new ArrayList<Component>();
        Component cursor = null;
        Transpiler.traverseComponents(cursor, nodeComponentMap, sortedComponents);
        return sortedComponents;
    }

    public static void traverseComponents(Component cursor, Map<Component, List<Component>> nodeComponentMap, List<Component> sortedComponents) {
        List<Component> levelComponents = nodeComponentMap.get(cursor);
        if (levelComponents == null) {
            return;
        }
        Collections.sort(levelComponents);
        for (Component component : levelComponents) {
            sortedComponents.add(component);
            Transpiler.traverseComponents(component, nodeComponentMap, sortedComponents);
        }
    }
}

