/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.apexlang.core.APEXLangCompilerUtils;
import oracle.apexlang.core.ComponentGroup;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.core.ComponentPlugin;
import oracle.apexlang.core.ComponentRelation;
import oracle.apexlang.core.PluginType;
import oracle.apexlang.core.Range;
import oracle.apexlang.core.Transpiler;
import oracle.apexlang.metametadata.ComponentType;
import oracle.apexlang.metametadata.Metametadata;

public class Component
implements Comparable<Component> {
    private Map<String, ComponentParameter> componentParameters;
    private List<ComponentGroup> componentGroups;
    private String typeId;
    private ComponentType componentType;
    private String parentId;
    private Range range;
    private int line;
    private int column;
    private String filename;
    private String parentExternalIdentifier;
    private PluginType pluginType;
    private Component parent;
    private ComponentPlugin componentPlugin;
    private Map<String, ComponentRelation> possibleComponentRelations;
    private Map<String, Component> relatedComponentsFound;
    private String externalFileHexContent;
    private String externalFilePath;

    public Component(String typeId, ComponentType componentType, String parentId, Integer start, Integer stop, int line, int column, String filename, String parentExternalIdentifier, List<ComponentGroup> componentGroups, Map<String, ComponentRelation> possibleComponentRelations) {
        this.typeId = typeId;
        this.componentParameters = new HashMap<String, ComponentParameter>();
        this.parentId = parentId;
        this.range = new Range(start, stop);
        this.line = line;
        this.column = column;
        this.filename = filename;
        this.parentExternalIdentifier = parentExternalIdentifier;
        this.componentGroups = componentGroups;
        this.possibleComponentRelations = possibleComponentRelations;
        this.relatedComponentsFound = new HashMap<String, Component>();
        this.componentType = componentType;
    }

    public Component(String typeId, ComponentType componentType, String parentId, Component relatedComponent, List<ComponentGroup> componentGroups, Map<String, ComponentRelation> possibleComponentRelations) {
        this.typeId = typeId;
        this.componentParameters = new HashMap<String, ComponentParameter>();
        this.parentId = parentId;
        this.range = new Range(relatedComponent.getRange().getStart(), relatedComponent.getRange().getEnd());
        this.line = relatedComponent.getLine();
        this.column = relatedComponent.getColumn();
        this.filename = relatedComponent.getFilename();
        this.parentExternalIdentifier = relatedComponent.getExternalIdentifier();
        this.componentGroups = componentGroups;
        this.possibleComponentRelations = possibleComponentRelations;
        this.relatedComponentsFound = new HashMap<String, Component>();
        this.componentType = componentType;
    }

    public List<Component> getRelatedComponentsFound() {
        return this.relatedComponentsFound.values().stream().collect(Collectors.toUnmodifiableList());
    }

    public Map<String, Component> getRelatedComponentsFoundMap() {
        return this.relatedComponentsFound;
    }

    public Map<String, ComponentRelation> getPossibleComponentRelations() {
        return this.possibleComponentRelations;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public String getName() {
        return this.componentType.getName().getSingular();
    }

    public void setComponentPlugin(ComponentPlugin componentPlugin) {
        this.componentPlugin = componentPlugin;
    }

    public ComponentPlugin getComponentPlugin() {
        return this.componentPlugin;
    }

    public PluginType getPluginType() {
        return this.pluginType;
    }

    public void setPluginType(PluginType plugin) {
        this.pluginType = plugin;
    }

    public void addParameter(String parameterId, ComponentParameter componentParameter) {
        this.componentParameters.put(parameterId, componentParameter);
    }

    public int getColumn() {
        return this.column;
    }

    public String getExternalIdentifierPropertyId() {
        return this.componentType.getExternalIdentifierPropertyId();
    }

    public String getExternalIdentifier() {
        ComponentParameter externalIdentifierParameter = this.componentParameters.get(this.componentType.getExternalIdentifierPropertyId());
        if (externalIdentifierParameter != null) {
            return externalIdentifierParameter.getValue();
        }
        return "";
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public Map<String, ComponentParameter> getParameters() {
        return this.componentParameters;
    }

    public List<ComponentGroup> getComponentGroups() {
        return this.componentGroups;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getExpression() {
        ComponentType.Api api = this.componentType.getApi();
        return api == null ? null : api.getExpression();
    }

    public Integer getInsertOrder() {
        return this.componentType.getInsertOrder();
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    public Component getParent() {
        return this.parent;
    }

    public String getParentId() {
        return this.parentId;
    }

    public Range getRange() {
        return this.range;
    }

    public String getParentExternalIdentifier() {
        return this.parentExternalIdentifier;
    }

    public void setParentExternalIdentifier(String parentExternalIdentifier) {
        this.parentExternalIdentifier = parentExternalIdentifier;
    }

    public void setExternalFileHexContent(String externalFileBased64Content) {
        this.externalFileHexContent = externalFileBased64Content;
    }

    public String getExternalFileHexContent() {
        return this.externalFileHexContent;
    }

    public String getExternalFilePath() {
        return this.externalFilePath;
    }

    public void setExternalFilePath(String externalFilePath) {
        this.externalFilePath = externalFilePath;
    }

    public String generatePlSQLCode() {
        Object plsql = "";
        if (this.getParameters().size() == 0) {
            return "null;\n";
        }
        String grandParent = "";
        String greatGrandParent = "";
        String greatGreatGrandParent = "";
        if (this.parent != null) {
            grandParent = this.parent.getParentExternalIdentifier();
            Component grandParentComponent = this.parent.getParent();
            if (grandParentComponent != null) {
                greatGrandParent = grandParentComponent.getParentExternalIdentifier();
                Component greatGrandParentComponent = grandParentComponent.getParent();
                if (greatGrandParentComponent != null) {
                    greatGreatGrandParent = greatGrandParentComponent.getParentExternalIdentifier();
                }
            }
        }
        ArrayList<String> parametersResult = new ArrayList<String>();
        for (String currentParameterKey : this.getParameters().keySet()) {
            String paramPLSQL;
            ComponentParameter currentParameter = this.getParameters().get(currentParameterKey);
            if (currentParameter.isPluginParameter().booleanValue() || (paramPLSQL = currentParameter.generatePlSQLCode()).length() <= 0) continue;
            parametersResult.add(paramPLSQL);
        }
        Iterator<String> parameterKeys = this.getParameters().keySet().iterator();
        ArrayList<String> pluginParametersResult = new ArrayList<String>();
        while (parameterKeys.hasNext()) {
            String paramPLSQL;
            String currentParameterKey = parameterKeys.next();
            ComponentParameter currentParameter = this.getParameters().get(currentParameterKey);
            if (!currentParameter.isPluginParameter().booleanValue() || (paramPLSQL = currentParameter.generatePlSQLCode()).length() <= 0) continue;
            pluginParametersResult.add(paramPLSQL);
        }
        String parameters = "\n" + String.join((CharSequence)", \n", parametersResult);
        if (pluginParametersResult.size() > 0) {
            String pre = "";
            String post = "";
            if (this.pluginType != null && this.pluginType.getApi() != null && this.pluginType.getApi().getExpression() != null) {
                pre = this.pluginType.getApi().getExpression().getPre() != null ? this.pluginType.getApi().getExpression().getPre() : "";
                String string = post = this.pluginType.getApi().getExpression().getPost() != null ? this.pluginType.getApi().getExpression().getPost() : "";
            }
            if (parametersResult.size() > 0) {
                parameters = parameters + ", \n";
            }
            parameters = parameters + pre + String.join((CharSequence)", \n", pluginParametersResult) + post;
        }
        Object expressionResult = this.getExpression();
        if (this.externalFileHexContent != null) {
            Object hexContentPrefix = "wwv_flow_imp.g_varchar2_table := wwv_flow_imp.empty_varchar2_table; \n";
            int charactersPerLine = 200;
            int index = 1;
            for (int i = 0; i < this.externalFileHexContent.length(); i += charactersPerLine) {
                int endIndex = Math.min(i + charactersPerLine, this.externalFileHexContent.length());
                hexContentPrefix = (String)hexContentPrefix + "wwv_flow_imp.g_varchar2_table(:index) := ':hexValue';\n".replace(":hexValue", this.externalFileHexContent.substring(i, endIndex)).replace(":index", Integer.toString(index++));
            }
            expressionResult = (String)hexContentPrefix + (String)expressionResult;
        }
        expressionResult = Transpiler.replaceAllSafely((String)expressionResult, "%parameters%", parameters);
        ComponentParameter externalIdentifier = this.getParameters().get(this.getExternalIdentifierPropertyId());
        if (externalIdentifier != null) {
            expressionResult = Transpiler.replaceAllSafely((String)expressionResult, ":external_identifier", externalIdentifier.getData().toPlSql(":value", ":value"));
        }
        if (!"".equals(this.getParentExternalIdentifier()) || this.getParentExternalIdentifier() != null) {
            expressionResult = Transpiler.replaceAllSafely((String)expressionResult, ":parent_identifier", "'" + this.getParentExternalIdentifier() + "'");
        }
        expressionResult = Transpiler.replaceAllSafely((String)expressionResult, ":grandparent_identifier", "'" + grandParent + "'");
        expressionResult = Transpiler.replaceAllSafely((String)expressionResult, ":great_grandparent_identifier", "'" + greatGrandParent + "'");
        expressionResult = Transpiler.replaceAllSafely((String)expressionResult, ":great_great_grandparent_identifier", "'" + greatGreatGrandParent + "'");
        plsql = (String)plsql + String.format("%s\n\n", expressionResult);
        return plsql;
    }

    @Override
    public int compareTo(Component other) {
        return Integer.compare(this.getInsertOrder(), other.getInsertOrder());
    }

    public List<Component> getAllRelatedComponents() {
        ArrayList<Component> related = new ArrayList<Component>();
        this.buildRelatedComponentTree(this.getRelatedRootComponent(this), related);
        return related;
    }

    private Component getRelatedRootComponent(Component component) {
        Component parent;
        if (component != null && (parent = component.getParent()) != null && parent.getRelatedComponentsFoundMap().get(component.getTypeId()) != null) {
            return this.getRelatedRootComponent(parent);
        }
        return component;
    }

    private void buildRelatedComponentTree(Component component, List<Component> allComponents) {
        allComponents.add(component);
        component.getRelatedComponentsFound().forEach(c -> this.buildRelatedComponentTree((Component)c, allComponents));
    }

    public Set<String> getFeatures(Metametadata metametadata) {
        HashSet<String> allFeatures = new HashSet<String>();
        if (this.componentType.getFeatures() != null) {
            for (ComponentType.Feature conditional : this.componentType.getFeatures()) {
                if (!APEXLangCompilerUtils.isParameterVisibleAccordingDependOnRule(this, conditional.getCondition(), metametadata)) continue;
                allFeatures.add(conditional.getName());
            }
        }
        return allFeatures;
    }
}

