/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.apexlang.metametadata.Property;

public class APEXLangSuggestion {
    private final SuggestionType type;
    private final String value;
    private final String detail;
    private final List<APEXLangSuggestion> children;
    private final Property property;

    public APEXLangSuggestion(SuggestionType type, String value, String detail) {
        this(type, value, detail, null);
    }

    public APEXLangSuggestion(SuggestionType type, String value, String detail, Property property) {
        this.type = type;
        this.value = value;
        this.detail = detail;
        this.children = new ArrayList<APEXLangSuggestion>();
        this.property = property;
    }

    public SuggestionType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getDetail() {
        return this.detail;
    }

    public Property getProperty() {
        return this.property;
    }

    public List<APEXLangSuggestion> getChildren() {
        return this.children;
    }

    public static List<APEXLangSuggestion> fromStrings(Collection<String> values, SuggestionType type) {
        return APEXLangSuggestion.fromStrings(values, type, null);
    }

    public static List<APEXLangSuggestion> fromStrings(Collection<String> values, SuggestionType type, String detail) {
        if (values != null) {
            return values.stream().sorted().map(v -> new APEXLangSuggestion(type, (String)v, detail)).toList();
        }
        return null;
    }

    public static enum SuggestionType {
        VALUE,
        PROPERTY_IN_CURRENT_GROUP,
        PROPERTY_IN_NEW_GROUP,
        PROPERTY_IN_EXISTING_GROUP,
        GROUP,
        COMPONENT;

    }
}

