/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.apexlang.APEXLangCompiler;
import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.APEXLangSyntaxError;
import oracle.apexlang.core.APEXLangValidationException;
import oracle.apexlang.core.Transpiler;
import oracle.apexlang.metametadata.Property;
import oracle.apexlang.metametadata.PropertyType;

public class APEXLangStringDataType
extends APEXLangDataType {
    private String outputType;
    private boolean isCentral;
    private String refAppId;
    private boolean notFlag;
    private boolean supportsNotFlag;
    private String pluginExternalIdentifier;
    private boolean valueIsMLT;
    private static final String UPPER_TEXT_CASE_RULE = "UPPER";
    private static final String LOWER_TEXT_CASE_RULE = "LOWER";
    private static final Map<String, Pattern> restrictedChars = new HashMap<String, Pattern>();

    public APEXLangStringDataType(String data, String outputType) {
        super(null);
        this.setData(data);
        this.outputType = outputType;
        this.refAppId = "";
        this.notFlag = false;
        this.supportsNotFlag = false;
    }

    @Override
    public String toPlSql(String template, String bindVariable) {
        String result = this.data;
        if (this.outputType != null && (this.outputType.equals("integer") || this.outputType.equals("number") || this.outputType.equals("blob"))) {
            return Transpiler.replaceAllSafely(template, bindVariable, result);
        }
        if ("boolean".equals(this.outputType)) {
            result = this.data.equals("Y") ? "true" : "false";
            return Transpiler.replaceAllSafely(template, bindVariable, result);
        }
        if (this.valueIsMLT) {
            String join = Arrays.stream(this.data.split("\n")).map(l -> l.replaceAll("'", "''").replaceAll("\\\\```", "```")).map(l -> "'" + l + "'").collect(Collectors.joining(",\n"));
            return Transpiler.replaceAllSafely(template, bindVariable, this.outputType != null && this.outputType.equals("clob") ? "wwv_flow_string.join_clob(wwv_flow_t_varchar2(\n" + join + "))" : "wwv_flow_string.join(wwv_flow_t_varchar2(\n" + join + "))");
        }
        result = Transpiler.replaceAllSafely(template, bindVariable, "'" + result.replaceAll("'", "''") + "'");
        result = Transpiler.replaceAllSafely(result, ":is_central", this.isCentral ? "true" : "false");
        result = Transpiler.replaceAllSafely(result, ":ref_app_id", this.refAppId);
        if (this.supportsNotFlag) {
            result = Transpiler.replaceAllSafely(result, ":is_not", this.notFlag ? "true" : "false");
        }
        if (this.pluginExternalIdentifier != null) {
            result = Transpiler.replaceAllSafely(result, ":plugin_external_identifier", "'" + this.pluginExternalIdentifier + "'");
        }
        return result;
    }

    @Override
    protected void validateImpl(Property property, PropertyType propertyType) throws APEXLangValidationException {
        Matcher matcher;
        Pattern pattern;
        Property.Validation validation;
        String regex;
        if (property.getMaxLen() != null && this.data.getBytes().length > property.getMaxLen()) {
            throw new APEXLangValidationException("String value too large, maximum " + property.getMaxLen() + " bytes");
        }
        if (!propertyType.isMultiLine() && (this.data.contains("\n") || this.data.contains("\r"))) {
            throw new APEXLangValidationException("Multiline text not allowed");
        }
        if (UPPER_TEXT_CASE_RULE.equals(property.getTextCase()) && !this.data.equals(this.data.toUpperCase())) {
            throw new APEXLangValidationException("String value must be upper case", APEXLangSyntaxError.ErrorType.VALUE_NOT_UPPERCASE);
        }
        if (LOWER_TEXT_CASE_RULE.equals(property.getTextCase()) && !this.data.equals(this.data.toLowerCase())) {
            throw new APEXLangValidationException("String value must be lower case", APEXLangSyntaxError.ErrorType.VALUE_NOT_LOWERCASE);
        }
        if (property.getValidation() != null && !this.data.matches(regex = (validation = property.getValidation()).getRegExp())) {
            Map<String, String> errorMap = validation.getError();
            String error = errorMap == null ? null : errorMap.get("en");
            Object message = error == null ? "Property does not match regular expression: " + regex : error;
            throw new APEXLangValidationException((String)message);
        }
        if (property.getRestrictedChars() != null && (pattern = restrictedChars.get(property.getRestrictedChars())) != null && (matcher = pattern.matcher(this.data)).find()) {
            throw new APEXLangValidationException("String contains one or more restricted characters: " + pattern.pattern());
        }
    }

    public void setData(String text) {
        this.valueIsMLT = false;
        if (text.startsWith("\"") && text.endsWith("\"") && text.length() > 1) {
            this.data = text.substring(1, text.length() - 1);
        } else {
            String mlt = APEXLangCompiler.getNormalizedText(text);
            if (mlt != null) {
                this.data = mlt;
                this.valueIsMLT = true;
            } else {
                this.data = text;
            }
        }
    }

    public void setSupportsNotFlag(boolean supportsNotFlag) {
        this.supportsNotFlag = supportsNotFlag;
    }

    public void setCentral(boolean isCentral) {
        this.isCentral = isCentral;
    }

    public void setRefAppId(String refAppId) {
        this.refAppId = refAppId;
    }

    public void setNotFlag(boolean notFlag) {
        this.notFlag = notFlag;
    }

    public String getRefAppId() {
        return this.refAppId;
    }

    public String getData() {
        return this.data;
    }

    public void setPluginExternalIdentifier(String pluginExternalIdentifier) {
        this.pluginExternalIdentifier = pluginExternalIdentifier;
    }

    public String toString() {
        return this.data;
    }

    static {
        restrictedChars.put("US_ONLY", Pattern.compile("[^a-zA-Z0-9 ]"));
        restrictedChars.put("US_ONLY_NO_SPACE", Pattern.compile("[^a-zA-Z0-9]"));
        restrictedChars.put("US_ONLY_UNDERSCORE_NO_SPACE", Pattern.compile("[^a-zA-Z0-9_]"));
        restrictedChars.put("WEB_SAFE", Pattern.compile("[<>\"]"));
        restrictedChars.put("SAFE_COMPONENT_NAME", Pattern.compile("[ :&,.+?^'\"\n\r]", 8));
        restrictedChars.put("SAFE_COMPONENT_NAME_NO_NUMBER", Pattern.compile("[ :&,.+?^'\"\n\r]|(^0$|^-?[1-9]\\d*(\\.\\d+)?$)", 8));
    }
}

