/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.APEXLangNumericDataType;
import oracle.apexlang.core.APEXLangValidationException;
import oracle.apexlang.core.Transpiler;
import oracle.apexlang.metametadata.Property;
import oracle.apexlang.metametadata.PropertyType;

public class APEXLangNumberDataType
extends APEXLangDataType
implements APEXLangNumericDataType {
    private Double number;
    private String outputType;

    public APEXLangNumberDataType(String data, String outputType) {
        super(data);
        try {
            this.number = Double.parseDouble(data);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.outputType = outputType;
    }

    @Override
    public String toPlSql(String template, String bindVariable) {
        if (template == null) {
            return "";
        }
        if (this.outputType == null || this.outputType.equals("string")) {
            return Transpiler.replaceAllSafely(template, ":value", "'" + this.number + "'");
        }
        return Transpiler.replaceAllSafely(template, bindVariable, "" + this.number);
    }

    @Override
    protected void validateImpl(Property property, PropertyType propertyType) throws APEXLangValidationException {
        try {
            Double.parseDouble(this.data);
        }
        catch (NumberFormatException nfe) {
            throw new APEXLangValidationException("Invalid number: " + this.data);
        }
        if (property.getMinValue() != null && Double.valueOf(property.getMinValue().intValue()).compareTo(this.number) > 0) {
            throw new APEXLangValidationException("Number out of range: " + this.number + ". Valid number between (" + property.getMinValue() + " - " + property.getMaxValue() + ")");
        }
        if (property.getMaxValue() != null && Double.valueOf(property.getMaxValue().intValue()).compareTo(this.number) < 0) {
            throw new APEXLangValidationException("Number out of range: " + this.number + ". Valid number between (" + property.getMinValue() + " - " + property.getMaxValue() + ")");
        }
        if (property.getMaxLen() != null) {
            int maxlen = property.getMaxLen();
            if (this.data.startsWith("-")) {
                ++maxlen;
            }
            if (this.data.contains(".")) {
                ++maxlen;
            }
            if (this.data.length() > maxlen) {
                throw new APEXLangValidationException("Number max digit length exceeded. Max digit length is " + property.getMaxLen());
            }
        }
    }

    public String toString() {
        return this.data;
    }

    @Override
    public Number getNumber() {
        return this.number;
    }
}

