/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.math.BigInteger;
import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.APEXLangNumericDataType;
import oracle.apexlang.core.APEXLangValidationException;
import oracle.apexlang.core.Transpiler;
import oracle.apexlang.metametadata.Property;
import oracle.apexlang.metametadata.PropertyType;

public class APEXLangIntegerDataType
extends APEXLangDataType
implements APEXLangNumericDataType {
    private BigInteger number;
    private String outputType;

    public APEXLangIntegerDataType(String data, String outputType) {
        super(data);
        this.outputType = outputType;
        try {
            this.number = new BigInteger(data);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public String toPlSql(String template, String bindVariable) {
        if (this.outputType == null || this.outputType.equals("string")) {
            return Transpiler.replaceAllSafely(template, bindVariable, "'" + String.valueOf(this.number) + "'");
        }
        return Transpiler.replaceAllSafely(template, bindVariable, String.valueOf(this.number));
    }

    public String toString() {
        return String.valueOf(this.number);
    }

    @Override
    protected void validateImpl(Property property, PropertyType propertyType) throws APEXLangValidationException {
        try {
            new BigInteger(this.data);
        }
        catch (NumberFormatException e) {
            throw new APEXLangValidationException("Invalid integer: " + this.data);
        }
        if (property.getMinValue() != null && BigInteger.valueOf(property.getMinValue().intValue()).compareTo(this.number) > 0) {
            throw new APEXLangValidationException("Integer out of range: " + String.valueOf(this.number) + ". Valid integer between (" + property.getMinValue() + " - " + property.getMaxValue() + ")");
        }
        if (property.getMaxValue() != null && BigInteger.valueOf(property.getMaxValue().intValue()).compareTo(this.number) < 0) {
            throw new APEXLangValidationException("Integer out of range: " + String.valueOf(this.number) + ". Valid integer between (" + property.getMinValue() + " - " + property.getMaxValue() + ")");
        }
        if (property.getMaxLen() != null) {
            int maxlen = property.getMaxLen();
            if (this.data.startsWith("-")) {
                ++maxlen;
            }
            if (this.data.length() > maxlen) {
                throw new APEXLangValidationException("Integer max digit length exceeded : " + this.data.length() + ". Max digit length is " + property.getMaxLen());
            }
        }
    }

    @Override
    public Number getNumber() {
        return this.number;
    }
}

