/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.apexlang.core.APEXLangStarterApp;

public class APEXLangFileWriter {
    public static void writeStarterAppFilesFromZipInputStream(InputStream input, List<String> filters, String pathPrefix, String pathPrefixReplacement, String appNameOverride, String appAliasOverride, String parsingSchemaOverride) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(input);
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            String filename = entry.getName();
            if (filters != null && !filters.isEmpty() && !filters.stream().anyMatch(filter -> filename.matches((String)filter))) continue;
            Path outputFilePath = !pathPrefix.isEmpty() ? Path.of(filename.replace(pathPrefix, pathPrefixReplacement), new String[0]) : Path.of(filename, new String[0]);
            Files.createDirectories(outputFilePath.getParent(), new FileAttribute[0]);
            if (outputFilePath.endsWith("application.apx") || outputFilePath.endsWith("p00001-home.apx") || outputFilePath.endsWith("p09999-login.apx")) {
                String fileData = new String(zis.readAllBytes(), StandardCharsets.UTF_8);
                fileData = fileData.replaceAll(APEXLangStarterApp.APP_NAME_PLACEHOLDER, appNameOverride != null && !appNameOverride.isBlank() ? appNameOverride : APEXLangStarterApp.DEFAULT_APP_NAME);
                fileData = fileData.replaceAll(APEXLangStarterApp.APP_TITLE_PLACEHOLDER, appNameOverride != null && !appNameOverride.isBlank() ? appNameOverride : APEXLangStarterApp.DEFAULT_APP_NAME);
                fileData = fileData.replaceAll(APEXLangStarterApp.APP_ALIAS_PLACEHOLDER, appAliasOverride != null && !appAliasOverride.isBlank() ? appAliasOverride.toUpperCase() : APEXLangStarterApp.DEFAULT_APP_ALIAS);
                fileData = fileData.replaceAll(APEXLangStarterApp.APP_SCHEMA_PLACEHOLDER, parsingSchemaOverride != null && !parsingSchemaOverride.isBlank() ? parsingSchemaOverride.toUpperCase() : APEXLangStarterApp.DEFAULT_APP_SCHEMA);
                Files.writeString(outputFilePath, (CharSequence)fileData, new OpenOption[0]);
                continue;
            }
            Files.copy(zis, outputFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

