/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.APEXLangValidationException;
import oracle.apexlang.core.Transpiler;
import oracle.apexlang.metametadata.Property;
import oracle.apexlang.metametadata.PropertyType;

public class APEXLangBooleanDataType
extends APEXLangDataType {
    private boolean internalBoolean;
    private String yesValue;
    private String noValue;
    private String outputType;

    public APEXLangBooleanDataType(String data, String yesValue, String noValue, String outputType) {
        super(data);
        this.internalBoolean = "true".equals(data);
        this.yesValue = yesValue;
        this.noValue = noValue;
        this.outputType = outputType;
    }

    @Override
    public String toPlSql(String template, String bindVariable) {
        Object result;
        Object object = result = this.internalBoolean ? "true" : "false";
        if (this.outputType == null || this.outputType.equals("string")) {
            Object object2 = result = this.internalBoolean ? "'" + this.yesValue + "'" : "'" + this.noValue + "'";
        }
        if (this.outputType != null && this.outputType.equals("number")) {
            result = this.internalBoolean ? this.yesValue : this.noValue;
        }
        return Transpiler.replaceAllSafely(template, bindVariable, (String)result);
    }

    @Override
    protected void validateImpl(Property property, PropertyType propertyType) throws APEXLangValidationException {
        if (!"true".equals(this.data) && !"false".equals(this.data)) {
            throw new APEXLangValidationException("Invalid boolean type: " + this.data);
        }
    }

    public String toString() {
        return this.internalBoolean ? this.yesValue : this.noValue;
    }

    public boolean booleanValue() {
        return this.internalBoolean;
    }
}

